/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.query;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.dao.factory.ErDaoFactory;
import kd.fi.er.common.order.HotelOrderCons;
import kd.fi.er.common.order.PlaneOrderCons;
import kd.fi.er.report.query.FilterParam;
import org.apache.commons.lang3.StringUtils;

public class TripOrderRpt
extends AbstractReportListDataPlugin {
    private static Log logger = LogFactory.getLog(TripOrderRpt.class);
    public static final String algoKey = TripOrderRpt.class.getName();

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        FilterParam filterParam = this.convertToFilterParam(queryParam);
        logger.info(String.format("\u5546\u65c5\u8ba2\u5355\u62a5\u8868\u8fc7\u6ee4\u6761\u4ef6\uff1a%s(\u539f\u59cb\uff1a%s)", filterParam, queryParam.getFilter()));
        QFilter orderFilter = this.convertToQFilter(filterParam);
        DataSet detailData = this.getDetailData(orderFilter);
        ArrayList<String> groupField = new ArrayList<String>();
        groupField.add("server");
        DataSet sumData = this.computeSumData(detailData, groupField);
        DataSet result = detailData.union(sumData);
        result = result.orderBy(new String[]{"order_1", "summarytype"});
        return result;
    }

    private DataSet computeSumData(DataSet data, List<String> groupFields) {
        DataSet result = data.groupBy(groupFields.toArray(new String[0])).sum("order_amount").sum("payable_amount").sum("paid_amount").sum("invoice_amount").sum("unbilled_amount").finish();
        List<String> sumField = groupFields.subList(0, groupFields.size());
        sumField.add("order_amount");
        sumField.add("payable_amount");
        sumField.add("paid_amount");
        sumField.add("invoice_amount");
        sumField.add("unbilled_amount");
        if (groupFields.contains("server")) {
            sumField.add(String.format("%s as %s", "server", "order_1"));
        } else {
            sumField.add(String.format("NULL as %s", "order_1"));
        }
        result = result.select(sumField.toArray(new String[0]));
        result = result.addField("'1'", "summarytype");
        String total = String.format("'%s'", ResManager.loadKDString((String)"\u5408\u8ba1", (String)"TripOrderRpt_2", (String)"fi-er-report", (Object[])new Object[0]));
        result = result.addField(total, "server");
        result = this.addLostField(this.getRptFieldList(), result);
        return result;
    }

    private DataSet getDetailData(QFilter filter) {
        List<String> fieldList = this.getRptFieldList();
        DataSet result = this.getOrderData("er_hotelbill", filter);
        result = result.addField(String.format("'%s'", HotelOrderCons.getSERVER_TYPE()), "server_type");
        result = this.addLostField(fieldList, result);
        DataSet planeData = this.getOrderData("er_planebill", filter);
        planeData = planeData.addField(String.format("'%s'", PlaneOrderCons.getSERVER_TYPE()), "server_type");
        planeData = this.addLostField(fieldList, planeData);
        result = result.union(planeData);
        return result;
    }

    private DataSet getOrderData(String pageId, QFilter filter) {
        LinkedList<String> selectFields = new LinkedList<String>();
        selectFields.add(String.format("%s as %s", "server", "server"));
        selectFields.add(String.format("%s as %s", "expcommitcomnum", "bear_cost_company"));
        selectFields.add(String.format("%s as %s", "ordernum", "order_number"));
        selectFields.add(String.format("%s as %s", "orderdate", "order_date"));
        selectFields.add(String.format("%s as %s", "totalamount", "order_amount"));
        selectFields.add(String.format("CASE WHEN %s is null or %s='' THEN %s ELSE 0 END %s", "paybillnum", "paybillnum", "totalamount", "payable_amount"));
        selectFields.add(String.format("CASE WHEN %s is null or %s='' THEN 0 ELSE %s END %s", "paybillnum", "paybillnum", "totalamount", "paid_amount"));
        selectFields.add(String.format("CASE WHEN (%s is null or %s='')and(%s is null or %s='') THEN 0 ELSE %s END %s", "vatcominvoicenum", "vatcominvoicenum", "vatdednvoicenum", "vatdednvoicenum", "totalamount", "invoice_amount"));
        selectFields.add(String.format("CASE WHEN (%s is null or %s='')and(%s is null or %s='') THEN %s ELSE 0 END %s", "vatcominvoicenum", "vatcominvoicenum", "vatdednvoicenum", "vatdednvoicenum", "totalamount", "unbilled_amount"));
        selectFields.add(String.format("CASE WHEN %s is not null and %s!='' THEN %s WHEN %s is not null and %s!='' THEN %s ELSE NULL END %s", "vatcominvoicecode", "vatcominvoicecode", "vatcominvoicecode", "vatdednvoicecode", "vatdednvoicecode", "vatdednvoicecode", "invoice_code"));
        selectFields.add(String.format("CASE WHEN %s is not null and %s!='' THEN %s WHEN %s is not null and %s!='' THEN %s ELSE NULL END %s", "vatcominvoicenum", "vatcominvoicenum", "vatcominvoicenum", "vatdednvoicenum", "vatdednvoicenum", "vatdednvoicenum", "invoice_number"));
        selectFields.add(String.format("%s as %s", "orderdate", "invoice_date"));
        selectFields.add(String.format("%s as %s", "server", "order_1"));
        DataSet result = ErDaoFactory.getInstance((String)pageId).queryDataSet(algoKey, String.join((CharSequence)",", selectFields), new QFilter[]{filter});
        return result;
    }

    private FilterParam convertToFilterParam(ReportQueryParam queryParam) {
        FilterInfo filterCondition = queryParam.getFilter();
        String temp = filterCondition.getString("filter_server");
        ArrayList<String> server = new ArrayList<String>();
        if (temp != null) {
            for (String elem : temp.replaceAll("\\[", "").replaceAll("\\]", "").split(",")) {
                server.add(elem);
            }
        }
        List date = filterCondition.getFilterItems("filter_date");
        Date startDate = null;
        Date endDate = null;
        if (date != null && date.size() == 2) {
            startDate = ((FilterItemInfo)date.get(0)).getDate();
            if (startDate.before(((FilterItemInfo)date.get(1)).getDate())) {
                endDate = ((FilterItemInfo)date.get(1)).getDate();
            } else {
                endDate = startDate;
                startDate = ((FilterItemInfo)date.get(1)).getDate();
            }
        }
        long company = filterCondition.getValue("filter_company.id") == null ? -1L : filterCondition.getLong("filter_company.id");
        return new FilterParam(server, startDate, endDate, company);
    }

    private QFilter convertToQFilter(FilterParam filterParam) {
        QFilter result = null;
        if (!filterParam.getServer().isEmpty()) {
            result = new QFilter("server", "in", filterParam.getServer());
        }
        if (filterParam.getStartDate() != null) {
            if (result != null) {
                result.and("orderdate", ">=", (Object)filterParam.getStartDate());
                result.and("orderdate", "<=", (Object)filterParam.getEndDate());
            } else {
                result = new QFilter("orderdate", ">=", (Object)filterParam.getStartDate());
                result.and("orderdate", "<=", (Object)filterParam.getEndDate());
            }
        }
        if (filterParam.getCompany() != -1L) {
            if (result != null) {
                result.and("company.id", "=", (Object)filterParam.getCompany());
            } else {
                result = new QFilter("company.id", "=", (Object)filterParam.getCompany());
            }
        }
        return result;
    }

    public List<String> getRptFieldList() {
        LinkedList<String> result = new LinkedList<String>();
        result.add("server");
        result.add("bear_cost_company");
        result.add("server_type");
        result.add("order_number");
        result.add("order_date");
        result.add("order_amount");
        result.add("payable_amount");
        result.add("paid_amount");
        result.add("invoice_amount");
        result.add("unbilled_amount");
        result.add("invoice_code");
        result.add("invoice_number");
        result.add("invoice_date");
        result.add("summarytype");
        result.add("order_1");
        return result;
    }

    public DataSet addLostField(List<String> fieldList, DataSet data) {
        HashSet haveFieldSet = Sets.newHashSetWithExpectedSize((int)32);
        for (Field elem : data.getRowMeta().getFields()) {
            haveFieldSet.add(elem.getName().toLowerCase());
        }
        for (String field : fieldList) {
            if (haveFieldSet.contains(field)) continue;
            if (StringUtils.equalsIgnoreCase((CharSequence)"summarytype", (CharSequence)field)) {
                data = data.addField("'0'", "summarytype");
                continue;
            }
            data = data.addNullField(field);
        }
        return data.select(fieldList.toArray(new String[0]));
    }

    public DataSet addSumDesc(String desc, String field, DataSet data) {
        for (Field elem : data.getRowMeta().getFields()) {
            if (!field.equalsIgnoreCase(elem.getName())) continue;
            field = "server";
        }
        return data.addField(String.format("'%s' as %s", desc, field), field);
    }
}

