/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.reimctl;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.Month;
import java.time.YearMonth;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.FormShowParameter;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.fi.er.business.daily.service.model.ReimburseAmountDetailBean;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.common.constant.ErExpenseItemConstant;

public abstract class ErAbstractReimCtlUseDetailPlugin
extends AbstractFormPlugin {
    protected static final String treeRootId = "0";

    public void afterCreateNewData(EventObject e) {
        this.genEntry();
    }

    private void genEntry() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object userQueryParam = formShowParameter.getCustomParam("reimAmountQueryBean");
        QuotaAmountBO quotaAmountBO = (QuotaAmountBO)((JSONObject)userQueryParam).toJavaObject(QuotaAmountBO.class);
        Integer year = quotaAmountBO.getHappenYear();
        if (quotaAmountBO == null) {
            return;
        }
        LocalDate startDate = LocalDate.of((int)year, 1, 1);
        LocalDate endDate = LocalDate.of((int)year, 12, 31);
        quotaAmountBO.setHappenDatePeriod(new LocalDate[]{startDate, endDate});
        Long currencyId = quotaAmountBO.getCurrencyId();
        QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)quotaAmountBO);
        List reimedDetails = quotaCtrlMode.getReimbursedBills(quotaAmountBO);
        quotaAmountBO.setHappenDate(YearMonth.of((int)year, YearMonth.now().getMonth()));
        if (ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue().equals(quotaAmountBO.getCtrlMethod())) {
            quotaAmountBO.setHappenDatePeriod(new HashMap());
            Map amountLimitedMontyly = quotaCtrlMode.getMonthQuotaAmount(quotaAmountBO);
            this.buildUseSummaryByMonthControl(reimedDetails, amountLimitedMontyly, year, currencyId);
        } else {
            quotaAmountBO.setIsByFreedRatio(false);
            quotaAmountBO.setHappenDatePeriod(new HashMap());
            BigDecimal totalLimitedAmount = quotaCtrlMode.getQuotaAmount(quotaAmountBO);
            this.buildUseSummaryByYearControl(reimedDetails, totalLimitedAmount, year, currencyId);
        }
        Boolean isDeptAmount = (Boolean)formShowParameter.getCustomParam("isDeptAmount");
        if (isDeptAmount.booleanValue()) {
            this.updateDeptDetailEntity(currencyId, reimedDetails);
        } else {
            this.updateUseDetailEntity(currencyId, reimedDetails);
        }
    }

    protected void updateDeptDetailEntity(Long currencyId, List<ReimburseAmountDetailBean> reimedDetails) {
    }

    protected void updateUseDetailEntity(Long currencyId, List<ReimburseAmountDetailBean> reimedDetails) {
    }

    protected abstract void buildUseSummaryByMonthControl(List<ReimburseAmountDetailBean> var1, Map<Month, BigDecimal> var2, int var3, Long var4);

    protected abstract void buildUseSummaryByYearControl(List<ReimburseAmountDetailBean> var1, BigDecimal var2, int var3, Long var4);

    public static class GroupListKey {
        private String metaKey;
        private String billName;
        private Long billId;
        private String billno;
        private String mobFormKey;

        public GroupListKey(String metaKey, String billName, Long billId, String billno) {
            this.metaKey = metaKey;
            this.billName = billName;
            this.billId = billId;
            this.billno = billno;
        }

        public GroupListKey() {
        }

        public String getMetaKey() {
            return this.metaKey;
        }

        public void setMetaKey(String metaKey) {
            this.metaKey = metaKey;
        }

        public String getBillName() {
            return this.billName;
        }

        public void setBillName(String billName) {
            this.billName = billName;
        }

        public Long getBillId() {
            return this.billId;
        }

        public void setBillId(Long billId) {
            this.billId = billId;
        }

        public String getBillno() {
            return this.billno;
        }

        public void setBillno(String billno) {
            this.billno = billno;
        }

        public String getMobFormKey() {
            return this.mobFormKey;
        }

        public void setMobFormKey(String mobFormKey) {
            this.mobFormKey = mobFormKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.billId == null ? 0 : this.billId.hashCode());
            result = 31 * result + (this.billName == null ? 0 : this.billName.hashCode());
            result = 31 * result + (this.billno == null ? 0 : this.billno.hashCode());
            result = 31 * result + (this.metaKey == null ? 0 : this.metaKey.hashCode());
            result = 31 * result + (this.mobFormKey == null ? 0 : this.mobFormKey.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            GroupListKey other = (GroupListKey)obj;
            if (this.billId == null ? other.billId != null : !this.billId.equals(other.billId)) {
                return false;
            }
            if (this.billName == null ? other.billName != null : !this.billName.equals(other.billName)) {
                return false;
            }
            if (this.billno == null ? other.billno != null : !this.billno.equals(other.billno)) {
                return false;
            }
            if (this.metaKey == null ? other.metaKey != null : !this.metaKey.equals(other.metaKey)) {
                return false;
            }
            return !(this.mobFormKey == null ? other.mobFormKey != null : !this.mobFormKey.equals(other.mobFormKey));
        }
    }
}

