/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.report.treerpt;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.report.treerpt.RowWrap;
import org.apache.commons.lang3.StringUtils;

public class RowWrapGroup {
    private Map<RowWrap, Set<RowWrap>> finalMap = Maps.newHashMapWithExpectedSize((int)32);
    private Map<RowWrap, Set<RowWrap>> groupIndex = Maps.newHashMapWithExpectedSize((int)32);
    private Map<String, RowWrap> index = Maps.newHashMapWithExpectedSize((int)32);
    private final ArrayListMultimap<String, RowWrap> noParentRowWrap = ArrayListMultimap.create((int)32, (int)8);
    private String maxLengthRowId = "";
    private static final String LEVELUP = "+";
    private static Set<String> sumFields = Sets.newHashSet((Object[])new String[]{"pid", "rowid", "isgroupnode", "costcompany", "currency"});

    public void addRowWrap(RowWrap curRowWrap) {
        RowWrap parentRow;
        RowWrap head = this.groupRowWrap(curRowWrap, curRowWrap.getNumber());
        if (!StringUtils.isBlank((CharSequence)head.getPnumber()) && (parentRow = this.findParent(head)) == null) {
            RowWrap row;
            List list = this.noParentRowWrap.get((Object)curRowWrap.getPnumber());
            if (list != null && !list.isEmpty() && (row = (RowWrap)list.stream().filter(v -> v.getNumber().equals(head.getNumber())).findAny().orElse(null)) != null) {
                list.remove(row);
            }
            this.noParentRowWrap.put((Object)curRowWrap.getPnumber(), (Object)head);
        }
    }

    public List<RowWrap> get() {
        int formatTreeStruct = this.formatTreeStruct();
        ArrayList list = Lists.newArrayListWithExpectedSize((int)formatTreeStruct);
        Set<Map.Entry<RowWrap, Set<RowWrap>>> entrySet = this.finalMap.entrySet();
        Iterator<Map.Entry<RowWrap, Set<RowWrap>>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            this.preOrder(list, iterator.next().getKey());
        }
        return list;
    }

    private void preOrder(List<RowWrap> result, RowWrap node) {
        result.add(node);
        Set<RowWrap> children = this.groupIndex.get(node);
        if (children != null && !children.isEmpty()) {
            for (RowWrap child : children) {
                this.preOrder(result, child);
            }
        }
    }

    private int formatTreeStruct() {
        this.buildTree();
        int count = 0;
        Set<Map.Entry<RowWrap, Set<RowWrap>>> entrySet = this.finalMap.entrySet();
        for (Map.Entry<RowWrap, Set<RowWrap>> next : entrySet) {
            RowWrap head = next.getKey();
            this.preOrderSum(head);
        }
        return count;
    }

    private void buildTree() {
        if (!this.noParentRowWrap.isEmpty()) {
            DynamicObjectCollection collection;
            Iterator iterator = this.noParentRowWrap.asMap().entrySet().iterator();
            HashSet companyNumbers = Sets.newHashSetWithExpectedSize((int)this.noParentRowWrap.size());
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                ((Collection)next.getValue()).stream().forEach(v -> {
                    String longnumber = v.getLongnumber();
                    if (StringUtils.isNotBlank((CharSequence)longnumber)) {
                        companyNumbers.addAll(Stream.of(longnumber.split("!")).collect(Collectors.toList()));
                    }
                });
            }
            Map<String, Long> idMaps = null;
            if (!companyNumbers.isEmpty() && !(collection = QueryServiceHelper.query((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", (Object)companyNumbers)})).isEmpty()) {
                idMaps = collection.stream().collect(Collectors.toMap(k -> k.getString("number"), v -> v.getLong("id"), (v1, v2) -> v1));
            }
            iterator = this.noParentRowWrap.asMap().entrySet().iterator();
            LinkedList newNodes = Lists.newLinkedList();
            HashSet numberset = Sets.newHashSetWithExpectedSize((int)32);
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (((Collection)next.getValue()).isEmpty()) continue;
                RowWrap head = (RowWrap)((Collection)next.getValue()).iterator().next();
                String longnumber = head.getLongnumber();
                String rowid = head.getRowid();
                if (!StringUtils.isNotBlank((CharSequence)longnumber)) continue;
                String[] numbers = longnumber.split("!");
                for (int i = numbers.length; i > 0; --i) {
                    String curNumber = numbers[i - 1];
                    if (head.getNumber().equals(curNumber)) continue;
                    RowWrap rowWrap = this.index.get(curNumber);
                    if (rowWrap != null) {
                        this.findChild(rowWrap);
                        continue;
                    }
                    if (numberset.contains(curNumber)) continue;
                    RowWrap newHead = this.getNewRowWrap(head);
                    newHead.setCostcompany(idMaps == null ? Long.valueOf(0L) : idMaps.get(curNumber));
                    newHead.setNumber(curNumber);
                    newHead.setPnumber(this.getParentNumber(numbers, i));
                    newHead.setCurrency(head.getCurrency());
                    rowid = this.rowIdLevelUp(rowid);
                    newHead.setRowid(rowid);
                    newNodes.add(newHead);
                    numberset.add(curNumber);
                }
            }
            newNodes.stream().forEach(this::addRowWrap);
        }
    }

    private RowWrap getNewRowWrap(RowWrap head) {
        RowMeta rowMeta = head.getRowMeta();
        return new RowWrap(new Object[rowMeta.getFieldCount()], rowMeta);
    }

    private void preOrderSum(RowWrap head) {
        Set<RowWrap> children = this.groupIndex.get(head);
        if (children != null && !children.isEmpty()) {
            head.setIsleaf(false);
            for (RowWrap child : children) {
                if (child.getRowid().equals(head.getRowid())) continue;
                Set<RowWrap> grandsons = this.groupIndex.get(child);
                if (grandsons != null && !grandsons.isEmpty()) {
                    this.preOrderSum(child);
                    continue;
                }
                child.setIsleaf(true);
            }
            this.sumData(head, children);
        } else {
            head.setIsleaf(true);
        }
    }

    private String rowIdLevelUp(String rowid) {
        String newId = rowid.concat(LEVELUP);
        if (newId.length() > this.maxLengthRowId.length()) {
            this.maxLengthRowId = newId;
        }
        return newId;
    }

    private String rowIdSumUp(String rowid) {
        String newId = rowid.concat("&");
        return newId;
    }

    private String getParentNumber(String[] numbers, int i) {
        if (i - 2 >= 0) {
            return numbers[i - 2];
        }
        return null;
    }

    private void sumData(RowWrap newHead, Set<RowWrap> children) {
        this.clearStaticFiled(newHead);
        BigDecimal finished = BigDecimal.ZERO;
        BigDecimal inorder = BigDecimal.ZERO;
        BigDecimal finished_notax = BigDecimal.ZERO;
        BigDecimal inorder_notax = BigDecimal.ZERO;
        BigDecimal currNoTax = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal approve = BigDecimal.ZERO;
        BigDecimal entryamount = BigDecimal.ZERO;
        for (RowWrap row : children) {
            finished = finished.add(row.getFinished() == null ? BigDecimal.ZERO : row.getFinished());
            inorder = inorder.add(row.getInorder() == null ? BigDecimal.ZERO : row.getInorder());
            finished_notax = finished_notax.add(row.getFinished_notax() == null ? BigDecimal.ZERO : row.getFinished_notax());
            inorder_notax = inorder_notax.add(row.getInorder_notax() == null ? BigDecimal.ZERO : row.getInorder_notax());
            approve = approve.add(row.getCurrApprove() == null ? BigDecimal.ZERO : row.getCurrApprove());
            tax = tax.add(row.getTaxAmt() == null ? BigDecimal.ZERO : row.getTaxAmt());
            currNoTax = currNoTax.add(row.getCurrApproveNoTax() == null ? BigDecimal.ZERO : row.getCurrApproveNoTax());
            entryamount = entryamount.add(row.getEntryAmount() == null ? BigDecimal.ZERO : row.getEntryAmount());
            row.setPid(newHead.getRowid());
        }
        newHead.setFinished(finished);
        newHead.setInorder(inorder);
        newHead.setCurrApprove(approve);
        newHead.setTaxAmt(tax);
        newHead.setCurrApproveNoTax(currNoTax);
        newHead.setEntryAmount(entryamount);
        newHead.setFinished_notax(finished_notax);
        newHead.setInorder_notax(inorder_notax);
    }

    private void clearStaticFiled(RowWrap newHead) {
        Object[] rowData = newHead.getRowData();
        Field[] fields = newHead.getRowMeta().getFields();
        for (int i = 0; i < fields.length; ++i) {
            if (sumFields.contains(fields[i].getName().toLowerCase())) continue;
            rowData[i] = null;
        }
    }

    private RowWrap findParent(RowWrap curRowWrap) {
        String pcostcompanyNumber = curRowWrap.getPnumber();
        RowWrap pRowWrap = this.index.get(pcostcompanyNumber);
        if (pRowWrap != null) {
            this.transToList(curRowWrap, pRowWrap);
            Collection collection = (Collection)this.noParentRowWrap.asMap().get(curRowWrap.getNumber());
            if (collection != null) {
                collection.clear();
            }
            this.finalMap.remove(curRowWrap);
            return pRowWrap;
        }
        return null;
    }

    private RowWrap groupRowWrap(RowWrap curRowWrap, String costcompanyNumber) {
        RowWrap rowWrap = this.index.get(costcompanyNumber);
        if (rowWrap != null) {
            this.transToList(curRowWrap, rowWrap);
        } else {
            this.index.put(curRowWrap.getNumber(), curRowWrap);
            this.groupIndex.put(curRowWrap, null);
            this.finalMap.put(curRowWrap, null);
            rowWrap = curRowWrap;
            this.findChild(rowWrap);
        }
        return rowWrap;
    }

    private void findChild(RowWrap rowWrap) {
        List childRowWraps = this.noParentRowWrap.get((Object)rowWrap.getNumber());
        if (childRowWraps != null && !childRowWraps.isEmpty()) {
            childRowWraps.forEach(this::findParent);
        }
    }

    private RowWrap transToList(RowWrap curRowWrap, RowWrap pRowWrap) {
        LinkedHashSet sets = this.groupIndex.get(pRowWrap);
        if (sets == null) {
            sets = Sets.newLinkedHashSetWithExpectedSize((int)32);
            if (pRowWrap.getNumber().equals(curRowWrap.getNumber())) {
                RowWrap copyRowWrap = this.getNewRowWrap(pRowWrap);
                sets.add(copyRowWrap);
                Object[] rowData = pRowWrap.getRowData();
                copyRowWrap.setRowData(Arrays.copyOf(rowData, rowData.length));
                copyRowWrap.setRowid(pRowWrap.getRowid());
                pRowWrap.setRowid(this.rowIdSumUp(pRowWrap.getRowid()));
                copyRowWrap.setNumber(pRowWrap.getNumber());
                copyRowWrap.setPnumber(pRowWrap.getPnumber());
                copyRowWrap.setLongnumber(pRowWrap.getLongnumber());
                copyRowWrap.setCostcompany(pRowWrap.getCostcompany());
                copyRowWrap.setCurrency(pRowWrap.getCurrency());
                copyRowWrap.setFinished(pRowWrap.getFinished());
                copyRowWrap.setInorder(pRowWrap.getInorder());
                copyRowWrap.setInorder_notax(pRowWrap.getInorder_notax());
                copyRowWrap.setFinished_notax(pRowWrap.getFinished_notax());
                copyRowWrap.setCurrApprove(pRowWrap.getCurrApprove());
                copyRowWrap.setCurrApproveNoTax(pRowWrap.getCurrApproveNoTax());
                copyRowWrap.setTaxAmt(pRowWrap.getTaxAmt());
                copyRowWrap.setEntryAmount(pRowWrap.getEntryAmount());
            }
            this.groupIndex.put(pRowWrap, sets);
            this.finalMap.put(pRowWrap, sets);
        }
        sets.add(curRowWrap);
        return pRowWrap;
    }
}

