/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.ext.opplugin.budget;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.isc.IscHelper;
import kd.fi.er.business.servicehelper.ErExceptionServiceHelper;

public class BillCheckBudgetEASValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(BillCheckBudgetEASValidator.class);

    public void validate() {
        try {
            ExtendedDataEntity[] billEntitys;
            for (ExtendedDataEntity billEntity : billEntitys = this.getDataEntities()) {
                DynamicObject srcBill = billEntity.getDataEntity();
                try {
                    String flowNumber = IscHelper.getISCSettingValue((String)"eas_check_bg_flownum");
                    String easBgIscNumber = IscHelper.getEasBgIscNumber((DynamicObject)srcBill);
                    if (IscHelper.isEasShareBudget((String)easBgIscNumber)) {
                        return;
                    }
                    long buildStartTime = System.currentTimeMillis();
                    String targetJson = IscHelper.buildTargetBillJson((DynamicObject)srcBill, (String)easBgIscNumber);
                    logger.info("iscbudgeteas buildTargetBillJson\u8017\u65f6: " + (System.currentTimeMillis() - buildStartTime));
                    if (StringUtils.isNotBlank((CharSequence)flowNumber)) {
                        long execStartTime = System.currentTimeMillis();
                        IscHelper.execBudgetService((String)flowNumber, (String)"checkEASBillBudget", (String)targetJson);
                        logger.info("iscbudgeteas execBudgetService\u8017\u65f6: " + (System.currentTimeMillis() - execStartTime));
                        continue;
                    }
                    long doEASFacadeStartTime = System.currentTimeMillis();
                    IscHelper.doEASFacade((String)"checkEASBillBudget", (Object)targetJson);
                    logger.info("iscbudgeteas doEASFacade\u8017\u65f6: " + (System.currentTimeMillis() - doEASFacadeStartTime));
                }
                catch (KDBizException kdBizExcepetion) {
                    logger.info("EAS\u96c6\u6210,\u82cd\u7a79\u5355\u636e\u8fdb\u884cEAS\u8d39\u7528\u9884\u7b97\u68c0\u67e5\u5931\u8d251:", (Object)kdBizExcepetion);
                    this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"\u661f\u701a\u8d39\u7528\u5355\u636e\u8fdb\u884cEAS\u8d39\u7528\u9884\u7b97\u68c0\u67e5\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EM-W-831271", (String)"fi-er-opplugin", (Object[])new Object[0]), new Object[0]));
                }
                catch (Exception exception) {
                    logger.info("EAS\u96c6\u6210,\u82cd\u7a79\u5355\u636e\u8fdb\u884cEAS\u8d39\u7528\u9884\u7b97\u68c0\u67e5\u5931\u8d252:", (Object)exception);
                    String detail = ErExceptionServiceHelper.getStackTrace((Throwable)exception);
                    int start = detail.lastIndexOf("BgControlException:");
                    if (start == -1) {
                        this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4e0d\u8db3\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"EM-W-051134", (String)"fi-er-opplugin", (Object[])new Object[0]), new Object[0]));
                        continue;
                    }
                    this.addErrorMessage(billEntity, String.format(ResManager.loadKDString((String)"\u9884\u7b97\u4e0d\u8db3,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!\u8be6\u7ec6\u4fe1\u606f\u4e3a:%s", (String)"BillCheckBudgetEASValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]), IscHelper.getExceptionDescription((String)detail)));
                }
            }
        }
        catch (Exception e) {
            logger.error("EAS\u96c6\u6210,\u82cd\u7a79\u5355\u636e\u8fdb\u884cEAS\u8d39\u7528\u9884\u7b97\u68c0\u67e5\u5931\u8d253:", (Throwable)e);
            throw e;
        }
    }
}

