/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.OperateUtils;

public class ErConfirmStopReimOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ErConfirmStopReimOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            DynamicObjectCollection accEntry;
            BigDecimal payedAmount = BigDecimal.ZERO;
            BigDecimal payAmount = BigDecimal.ZERO;
            BigDecimal notPayAmount = dataEntity.getBigDecimal("notpayamount");
            BigDecimal approveAmount = dataEntity.getBigDecimal("approveamount");
            if (ErEntityTypeUtils.isPublicReimburseBill((String)dataEntity.getDataEntityType().getName()) || ErEntityTypeUtils.isDailyReimburseBill((String)dataEntity.getDataEntityType().getName())) {
                payedAmount = dataEntity.getBigDecimal("payedamount");
                payAmount = dataEntity.getBigDecimal("payamount");
                if (payAmount.compareTo(payedAmount) < 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4ed8\u73b0\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u5df2\u4ed8\u91d1\u989d\u3002", (String)"ErConfirmStopReimOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            } else {
                payedAmount = dataEntity.getBigDecimal("payamount");
                if (approveAmount.compareTo(payedAmount) < 0) {
                    if (!ErEntityTypeUtils.isApplyPayBill((String)dataEntity.getDataEntityType().getName())) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6838\u5b9a\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u5df2\u4ed8\u91d1\u989d\u3002", (String)"ErConfirmStopReimOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    }
                    throw new KDBizException(ResManager.loadKDString((String)"\u672c\u6b21\u6838\u5b9a\u4ed8\u6b3e\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u5df2\u4ed8\u91d1\u989d\u3002", (String)"ErConfirmStopReimOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
            if ((accEntry = dataEntity.getDynamicObjectCollection("accountentry")) != null && accEntry.size() > 0) {
                for (int i = 0; i < accEntry.size(); ++i) {
                    if (((DynamicObject)accEntry.get(i)).getBigDecimal("accnotpayamount").compareTo(BigDecimal.ZERO) != 0) continue;
                    ((DynamicObject)accEntry.get(i)).set("billstatusfield", (Object)"G");
                }
            }
            if (payedAmount.compareTo(BigDecimal.ZERO) == 0 && notPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                dataEntity.set("billstatus", (Object)"I");
            } else if (payedAmount.compareTo(BigDecimal.ZERO) > 0 && notPayAmount.compareTo(BigDecimal.ZERO) == 0) {
                dataEntity.set("billstatus", (Object)"G");
            }
            dataEntity.set("isstopreim", (Object)true);
            if (!ErEntityTypeUtils.isPrePayBill((String)dataEntity.getDataEntityType().getName()) && !ErEntityTypeUtils.isPublicReimburseBill((String)dataEntity.getDataEntityType().getName())) continue;
            PublicBillUtil.calNonpayAmount((DynamicObject)dataEntity);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new StopReimValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.endOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            OperationResult operationResult;
            String billstatus = dataEntity.getString("billstatus");
            Object[] pKids = Arrays.stream(new DynamicObject[]{dataEntity}).map(v -> v.getPkValue()).toArray(Object[]::new);
            OperateOption option = OperateOption.create();
            if ("G".equals(billstatus) && !ErEntityTypeUtils.isApplyPayBill((String)dataEntity.getDataEntityType().getName())) {
                ValidateResultCollection validateResult;
                logger.info("\u51fa\u7eb3\u96c6\u6210,\u9884\u4ed8\u5355/\u501f\u6b3e\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u5f00\u59cb,\u9884\u4ed8\u5355/\u501f\u6b3e\u5355ids:" + Arrays.toString(pKids));
                if (ErEntityTypeUtils.isDailyLoanBill((String)dataEntity.getDataEntityType().getName())) {
                    operationResult = OperationServiceHelper.executeOperate((String)"wbsourcebill", (String)"er_dailyloanbill", (Object[])pKids, (OperateOption)option);
                    if (operationResult.isSuccess()) {
                        logger.info("\u51fa\u7eb3\u96c6\u6210,\u501f\u6b3e\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u6210\u529f!");
                        continue;
                    }
                    validateResult = operationResult.getValidateResult();
                    logger.info("\u51fa\u7eb3\u96c6\u6210,\u501f\u6b3e\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
                    continue;
                }
                if (ErEntityTypeUtils.isPrePayBill((String)dataEntity.getDataEntityType().getName())) {
                    operationResult = OperationServiceHelper.executeOperate((String)"wbsourcebill", (String)"er_prepaybill", (Object[])pKids, (OperateOption)option);
                    if (operationResult.isSuccess()) {
                        logger.info("\u51fa\u7eb3\u96c6\u6210,\u9884\u4ed8\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u6210\u529f!");
                        continue;
                    }
                    validateResult = operationResult.getValidateResult();
                    logger.info("\u51fa\u7eb3\u96c6\u6210,\u9884\u4ed8\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
                    continue;
                }
                if (ErEntityTypeUtils.isPublicReimburseBill((String)dataEntity.getDataEntityType().getName())) {
                    operationResult = OperationServiceHelper.executeOperate((String)"wbsourcebill", (String)"er_publicreimbursebill", (Object[])pKids, (OperateOption)option);
                    if (operationResult.isSuccess()) {
                        logger.info("\u51fa\u7eb3\u96c6\u6210,\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u4e0a\u6e38\u5355\u636e\u6210\u529f!");
                        continue;
                    }
                    validateResult = operationResult.getValidateResult();
                    logger.info("\u51fa\u7eb3\u96c6\u6210,\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u4e0a\u6e38\u5355\u636e\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
                    continue;
                }
                if (!ErEntityTypeUtils.isDailyReimburseBill((String)dataEntity.getDataEntityType().getName())) continue;
                operationResult = OperationServiceHelper.executeOperate((String)"wbsourcebill", (String)"er_dailyreimbursebill", (Object[])pKids, (OperateOption)option);
                if (operationResult.isSuccess()) {
                    logger.info("\u51fa\u7eb3\u96c6\u6210,\u8d39\u7528\u62a5\u9500\u5355\u53cd\u5199\u4e0a\u6e38\u5355\u636e\u6210\u529f!");
                    continue;
                }
                validateResult = operationResult.getValidateResult();
                logger.info("\u51fa\u7eb3\u96c6\u6210,\u8d39\u7528\u62a5\u9500\u5355\u53cd\u5199\u4e0a\u6e38\u5355\u636e\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
                continue;
            }
            if (!ErEntityTypeUtils.isApplyPayBill((String)dataEntity.getDataEntityType().getName())) continue;
            logger.info("\u51fa\u7eb3\u96c6\u6210,\u4ed8\u6b3e\u7533\u8bf7\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u5f00\u59cb,\u4ed8\u6b3e\u7533\u8bf7\u5355ids:" + Arrays.toString(pKids));
            operationResult = OperationServiceHelper.executeOperate((String)"wbsourcebill", (String)"er_applypaybill", (Object[])pKids, (OperateOption)option);
            HashSet recsrcbillid = new HashSet();
            if (operationResult.isSuccess()) {
                Arrays.stream(pKids).forEach(data -> {
                    DynamicObjectCollection accountentry = dataEntity.getDynamicObjectCollection("accountentry");
                    recsrcbillid.addAll(accountentry.stream().map(v -> v.get("recsrcbillid")).collect(Collectors.toSet()));
                });
                DynamicObjectCollection pubColl = QueryServiceHelper.query((String)"er_publicreimbursebill", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", recsrcbillid)});
                if (pubColl.size() > 0) {
                    OperateOption operateOption;
                    Object[] pubids = pubColl.stream().map(v -> v.get("id")).toArray(Object[]::new);
                    operationResult = OperationServiceHelper.executeOperate((String)"wbsourcebill", (String)"er_publicreimbursebill", (Object[])pubids, (OperateOption)(operateOption = OperateOption.create()));
                    if (operationResult.isSuccess()) {
                        logger.info("\u51fa\u7eb3\u96c6\u6210,\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u8d39\u7528\u5408\u540c\u53f0\u8d26\u6210\u529f\uff01");
                    } else {
                        ValidateResultCollection validateResult = operationResult.getValidateResult();
                        logger.info("\u51fa\u7eb3\u96c6\u6210,\u5bf9\u516c\u62a5\u9500\u5355\u53cd\u5199\u8d39\u7528\u5408\u540c\u53f0\u8d26\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
                    }
                }
            } else {
                ValidateResultCollection validateResult = operationResult.getValidateResult();
                logger.info("\u51fa\u7eb3\u96c6\u6210,\u4ed8\u6b3e\u7533\u8bf7\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u5931\u8d25,\u539f\u56e0:" + validateResult.getMessage());
                String msg = ResManager.loadKDString((String)"\u51fa\u7eb3\u96c6\u6210\uff0c\u53cd\u5199\u4e0a\u6e38\u5355\u636e\u5931\u8d25\uff1a", (String)"PublicReimBillWriteBackService_0", (String)"fi-er-mservice", (Object[])new Object[0]);
                throw new KDBizException(msg + SerializationUtils.toJsonString((Object)operationResult));
            }
            logger.info("\u51fa\u7eb3\u96c6\u6210,\u4ed8\u6b3e\u7533\u8bf7\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u6210\u529f!");
            logger.info("\u51fa\u7eb3\u96c6\u6210,\u4ed8\u6b3e\u7533\u8bf7\u5355\u53cd\u5199\u5408\u540c\u4ed8\u6b3e\u6761\u76ee\u7ed3\u675f!");
        }
    }

    static class StopReimValidator
    extends AbstractValidator {
        StopReimValidator() {
        }

        public void validate() {
            ExtendedDataEntity[] billsExtendedDataEntity;
            for (ExtendedDataEntity billExtendedDataEntity : billsExtendedDataEntity = this.getDataEntities()) {
                BigDecimal accEntryTotalPayAmount;
                DynamicObject bill = billExtendedDataEntity.getDataEntity();
                BigDecimal payAmount = BigDecimal.ZERO;
                payAmount = ErEntityTypeUtils.isDailyReimburseBill((String)bill.getDataEntityType().getName()) || ErEntityTypeUtils.isPublicReimburseBill((String)bill.getDataEntityType().getName()) ? bill.getBigDecimal("payamount") : bill.getBigDecimal("approveamount");
                DynamicObjectCollection accEntry = bill.getDynamicObjectCollection("accountentry");
                if (!ErEntityTypeUtils.isApplyPayBill((String)bill.getDataEntityType().getName())) {
                    BigDecimal accEntryTotalPayAmount2 = accEntry.stream().map(row -> row.getBigDecimal("receiveamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                    if (payAmount.compareTo(accEntryTotalPayAmount2) != 0) {
                        this.addErrorMessage(billExtendedDataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u7d2f\u8ba1\u91d1\u989d\u4e0d\u7b49\u4e8e\u4ed8\u73b0\u91d1\u989d\u3002", (String)"ReimburseBillSubmitValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (accEntry == null || accEntry.size() <= 0) continue;
                    for (int i = 0; i < accEntry.size(); ++i) {
                        if (((DynamicObject)accEntry.get(i)).getBigDecimal("receiveamount").compareTo(((DynamicObject)accEntry.get(i)).getBigDecimal("accpayedamount")) >= 0) continue;
                        this.addErrorMessage(billExtendedDataEntity, String.format(ResManager.loadKDString((String)"\"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\"\u7b2c%1$s\u884c\u6536\u6b3e\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u5df2\u4ed8\u91d1\u989d\u3002", (String)"ErConfirmStopReimOp_5", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1));
                        return;
                    }
                    continue;
                }
                if (bill.containsProperty("accapprovecurramount") && payAmount.compareTo(accEntryTotalPayAmount = accEntry.stream().map(row -> row.getBigDecimal("accapprovecurramount")).reduce(BigDecimal.ZERO, BigDecimal::add)) != 0) {
                    this.addErrorMessage(billExtendedDataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u7d2f\u8ba1\u6838\u5b9a\u91d1\u989d\u4e0d\u7b49\u4e8e\u672c\u6b21\u6838\u5b9a\u4ed8\u6b3e\u91d1\u989d\u3002", (String)"ErConfirmStopReimOp_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (accEntry == null || accEntry.size() <= 0) continue;
                for (int i = 0; i < accEntry.size(); ++i) {
                    if (((DynamicObject)accEntry.get(i)).getBigDecimal("accapprovecurramount").compareTo(((DynamicObject)accEntry.get(i)).getBigDecimal("accpayedamount")) >= 0) continue;
                    this.addErrorMessage(billExtendedDataEntity, String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u5206\u5f55\u7b2c%1$s\u884c\u6838\u5b9a\u91d1\u989d\u4e0d\u5141\u8bb8\u5c0f\u4e8e\u5df2\u4ed8\u91d1\u989d\u3002", (String)"ErConfirmStopReimOp_3", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1));
                    return;
                }
            }
        }
    }
}

