/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily.web;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.daily.reimburse.AmountObject;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.utils.AmountUtils;

public class ReimSubmitCheckProxyTaxValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            boolean isProxy = bill.getBoolean("proxytax");
            String message = null;
            if (!isProxy || (message = this.proxyAmountValidator(bill, "expeapprovecurramount", "curproxyamt", "curraccloanamount", "receiveamount")) == null) continue;
            this.addErrorMessage(dataEntity, message);
            return;
        }
    }

    private String proxyAmountValidator(DynamicObject bill, String approveAmount, String proxyAmount, String woAmount, String accAmount) {
        String writeofftype = bill.getString("writeofftype");
        DynamicObjectCollection expColl = bill.getDynamicObjectCollection("expenseentryentity");
        DynamicObjectCollection woColl = bill.getDynamicObjectCollection("writeoffmoney");
        if (woColl.size() == 0) {
            return null;
        }
        if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeofftype)) {
            AmountObject expAmount;
            Map expeCurrcyAmount = AmountUtils.groupByCurrencyToObject((String)"expquotetype", (DynamicObjectCollection)expColl, (String)"expeapproveamount", (String)"expeapprovecurramount", (String)"entrycurrency", (String)"exchangerate");
            Map proxyCurrencyAmount = AmountUtils.groupByCurrencyToObject((String)"expquotetype", (DynamicObjectCollection)expColl, (String)"proxyamt", (String)"curproxyamt", (String)"entrycurrency", (String)"exchangerate");
            for (Map.Entry expeEntry : expeCurrcyAmount.entrySet()) {
                String currency = (String)expeEntry.getKey();
                expAmount = (AmountObject)expeCurrcyAmount.get(currency);
                AmountObject expProxyAmount = (AmountObject)proxyCurrencyAmount.get(currency);
                expAmount.setCurrAmount(expAmount.getCurrAmount().subtract(expProxyAmount.getCurrAmount()));
                expAmount.setOrgiAmount(expAmount.getOrgiAmount().subtract(expProxyAmount.getOrgiAmount()));
            }
            Map woCurrencyAmount = AmountUtils.groupByCurrency((DynamicObjectCollection)woColl, (String)"loancurrency", (String)"accloanamount");
            for (Map.Entry woEntry : woCurrencyAmount.entrySet()) {
                expAmount = (AmountObject)expeCurrcyAmount.get(woEntry.getKey());
                if (expAmount == null) {
                    return null;
                }
                if (expAmount.getOrgiAmount().compareTo((BigDecimal)woEntry.getValue()) >= 0) continue;
                return ResManager.loadKDString((String)"\u51b2\u9500\u91d1\u989d\u6c47\u603b\u5e94\u5c0f\u4e8e\u7b49\u4e8e\u6838\u5b9a\u91d1\u989d\u4e0e\u4ee3\u6263\u4ee3\u7f34\u91d1\u989d\u4e4b\u5dee\u3002", (String)"ReimSubmitCheckProxyTaxValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]);
            }
            return null;
        }
        BigDecimal curExpeAmount = AmountUtils.getEntryAmount((DynamicObjectCollection)expColl, (String)approveAmount);
        BigDecimal curProxytax = AmountUtils.getEntryAmount((DynamicObjectCollection)expColl, (String)proxyAmount);
        BigDecimal curWoAmount = AmountUtils.getEntryAmount((DynamicObjectCollection)woColl, (String)woAmount);
        if (curWoAmount.compareTo(curExpeAmount.subtract(curProxytax)) > 0) {
            return ResManager.loadKDString((String)"\u51b2\u9500\u91d1\u989d\u672c\u4f4d\u5e01\u6c47\u603b\u5e94\u5c0f\u4e8e\u7b49\u4e8e\uff08\u6838\u5b9a\u91d1\u989d\u672c\u4f4d\u5e01-\u4ee3\u6263\u4ee3\u7f34\u91d1\u989d\u672c\u4f4d\u5e01\uff09\u3002", (String)"ReimSubmitCheckProxyTaxValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        return null;
    }
}

