/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily.web;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.common.field.invoiceentry.InvoiceEntryfields;
import kd.fi.er.common.field.writeoffmoney.DailyReimburseWriteOffFields;
import kd.fi.er.opplugin.daily.web.ReimSubmitCheckAmountValidator;
import kd.fi.er.opplugin.daily.web.ReimSubmitCheckProxyTaxValidator;
import kd.fi.er.validator.BillPoolOverDescValidator;
import kd.fi.er.validator.ErBillCheckExpItemCanUseValidator;
import kd.fi.er.validator.LoanAndAccountCurrencyUniqueValidator;
import kd.fi.er.validator.LoanClearAmountSubmitValidator;
import kd.fi.er.validator.PayeraccountSubmitValidator;
import kd.fi.er.validator.ReimBillOverApplySubmitValidator;
import kd.fi.er.validator.ReimburseBillSubmitValidator;
import kd.fi.er.validator.invoicecloud.checkInvoice.ReimSubmitCheckInvoiceValidator;
import org.apache.commons.lang3.StringUtils;

public class ReimburseBillSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List list = e.getFieldKeys();
        list.add("expenseentryentity");
        list.add("expenseamount");
        list.add("entrycostdept");
        list.add("entrycostcompany");
        list.add("projecttype");
        list.add("currexpenseamount");
        list.add("expeapproveamount");
        list.add("taxamount");
        list.add("expenseitem");
        list.add("expeapprovecurramount");
        list.add("happendate");
        list.add("entrycurrency");
        list.add("reimburser");
        list.add("proxytax");
        list.add("writeofftype");
        list.add("expquotetype");
        list.add("exchangerate");
        list.add("billstatus");
        list.add("currency");
        list.add("abovequota");
        list.add("org");
        list.add("reimburseamount");
        list.add("writeoffmoney");
        list.add("accloanamount");
        list.add("currloanamount");
        list.add("payamount");
        list.add("loanamount");
        list.add("totalaccloanamount");
        list.add("curraccloanamount");
        list.add("approveamount");
        list.add("costcompany");
        list.add("applier");
        list.add("ismultireimburser");
        list.add("reimctldept");
        list.add("company");
        list.add("noinvoice");
        list.add("deductibletax");
        list.add("invoiceno_entry");
        list.add("proxyamt");
        list.add("curproxyamt");
        list.add("accountentry");
        list.add("orireceiveamount");
        list.add("receiveamount");
        list.add("oriaccnotpayamount");
        list.add("accnotpayamount");
        list.add("payer");
        list.add("reimbursecontrolcomany");
        list.add("writeoffapply");
        list.add("applycurrency");
        list.add("reimbursedamount");
        list.add("reimbursedcurramount");
        list.add("orgiexpebalanceamount");
        list.add("expebalanceamount");
        list.add("invoiceitementry");
        list.add("itementryid");
        list.add("excludeamount");
        list.add("invoiceitemtaxamout");
        list.add("excludeamount");
        list.add("itemfrom");
        list.add("invoiceandexpense.expenseentryid");
        list.add("invoiceandexpense.invoiceentryid");
        list.add("invoiceandexpense");
        list.add("automapinvoice");
        list.add("ismapexpense");
        list.add("taxamount_invoice");
        list.add("personalinvoice");
        list.add("passverifybuyername");
        list.add("passverifybuyertaxno");
        list.addAll(InvoiceEntryfields.getInstance().getAllFiedName());
        list.addAll(DailyReimburseWriteOffFields.getInstance().getAllFiedName());
        list.add(ReimburseControlUtils.getPersonReimCtlCompanyField());
        list.add("currency");
        list.add("needsuppleinvoice");
        list.add("expenseitem");
        list.add("writeoffapply");
        list.add("expenseitemfield");
        list.add("writeoffmoney");
        list.add("sourceexpenseitem");
        list.add("sourceapplyentryid");
        list.add("accountentry");
        list.add("accountentry.payerbank");
        list.add("accountentry.payertype");
        list.add("accountentry.casorg");
        list.add("accountentry.payer");
        list.add("accountentry.payeraccount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new ReimburseBillSubmitValidator());
        if (StringUtils.equalsIgnoreCase((CharSequence)((String)this.operateMeta.get("key")), (CharSequence)"submit")) {
            e.addValidator((AbstractValidator)new ReimSubmitCheckInvoiceValidator());
            e.addValidator((AbstractValidator)new ReimSubmitCheckProxyTaxValidator());
            e.addValidator((AbstractValidator)new ReimBillOverApplySubmitValidator());
            e.addValidator((AbstractValidator)new LoanClearAmountSubmitValidator(DailyReimburseWriteOffFields.getInstance()));
            e.addValidator((AbstractValidator)new LoanAndAccountCurrencyUniqueValidator());
            e.addValidator((AbstractValidator)new ReimSubmitCheckAmountValidator());
            e.addValidator((AbstractValidator)new PayeraccountSubmitValidator());
            List validators = e.getValidators();
            if (validators.stream().noneMatch(validator -> validator.getClass() == ErBillCheckExpItemCanUseValidator.class)) {
                e.addValidator((AbstractValidator)new ErBillCheckExpItemCanUseValidator());
            }
            e.addValidator((AbstractValidator)new BillPoolOverDescValidator());
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)((String)this.operateMeta.get("key")), (CharSequence)"saveapprove")) {
            // empty if block
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            this.dealAccountEntry(dataEntity);
            this.dealTaxAmountDiffenrence(dataEntity);
        }
    }

    private void dealAccountEntry(DynamicObject dataEntity) {
        DynamicObjectCollection accpEntrys = dataEntity.getDynamicObjectCollection("accountentry");
        for (DynamicObject accEntry : accpEntrys) {
            BigDecimal accEntryAmount = accEntry.getBigDecimal("receiveamount");
            if (null != accEntryAmount && accEntryAmount.compareTo(BigDecimal.ZERO) != 0) continue;
            accEntry.set("oriaccnotpayamount", (Object)BigDecimal.ZERO);
            accEntry.set("accnotpayamount", (Object)BigDecimal.ZERO);
        }
    }

    private void dealTaxAmountDiffenrence(DynamicObject dataEntity) {
        if (StringUtils.equalsIgnoreCase((CharSequence)((String)this.operateMeta.get("key")), (CharSequence)"submit")) {
            InvoiceUtils.checkTaxAmount((DynamicObject)dataEntity, (InvoiceUtils.BillEntityType)InvoiceUtils.BillEntityType.DailyReimburse);
        }
    }
}

