/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.daily.web.importplugin.importdatahandle.importdatahandleimpl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErOrgUtils;
import kd.fi.er.opplugin.daily.web.importplugin.importdatahandle.importdatahandleimpl.ErBillBaseImportHandle;
import kd.fi.er.opplugin.daily.web.importplugin.utils.ImportUtils;
import org.apache.commons.lang3.StringUtils;

public class TripReimburseBillImportHandle
extends ErBillBaseImportHandle {
    protected static final String[] VEHIC_ATTRIBUTE = new String[]{"2", "4", "7"};
    protected static final String[] ACCD_ALLOWANCE_ATTRIBUTE = new String[]{"5", "1"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean handleExpenseEntry(ImportBillData data, Iterator<ImportBillData> iterator, ImportLogger logger) {
        JSONObject dataMap = data.getData();
        String entityName = data.getEntityMapping().getEntityType().getName();
        JSONArray tripEntry = (JSONArray)dataMap.get("tripentry");
        boolean isCurrency = false;
        for (int i = 0; i < tripEntry.size(); ++i) {
            Map row = (Map)tripEntry.get(i);
            if (row.get("tripcurrency") == null || dataMap.get("currency") == null || ((JSONObject)row.get("tripcurrency")).get((Object)"number").equals(((JSONObject)dataMap.get("currency")).get((Object)"number"))) continue;
            isCurrency = true;
        }
        dataMap.put("iscurrency", isCurrency);
        BigDecimal amount = new BigDecimal(0);
        JSONObject jsonTripType = (JSONObject)dataMap.get("triptype");
        DynamicObject tripType = BusinessDataServiceHelper.loadSingleFromCache((String)"er_triptype", (String)"enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)jsonTripType.getString("number"))});
        if (tripType == null || !tripType.getBoolean("enable")) {
            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u51fa\u5dee\u7c7b\u578b\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\u3002", (String)"TripReimburseBillImportHandle_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            return false;
        }
        int costOrgShowTypes = ErCommonUtils.getExpenseAssumeShowTypes((long)((Long)dataMap.get("companyid")));
        int i = 0;
        block11: while (true) {
            BigDecimal exchangeRate;
            String endDateStr;
            String startDateStr;
            long dayCount;
            Map row;
            block47: {
                block48: {
                    JSONObject costcompany;
                    String projectNumber;
                    DynamicObject project;
                    if (i >= tripEntry.size()) {
                        String amountStr = amount.toString();
                        dataMap.put("amount", amountStr);
                        dataMap.put("approveamount", amountStr);
                        dataMap.put("notpayamount", amountStr);
                        dataMap.put("payamount", "0");
                        dataMap.remove("companyid");
                        return true;
                    }
                    row = (Map)tripEntry.get(i);
                    JSONObject entryCostDept = (JSONObject)row.get("entrycostdept");
                    JSONObject entryCostCompany = (JSONObject)row.get("entrycostcompany");
                    JSONObject tripExpenseItem = (JSONObject)row.get("tripexpenseitem");
                    if (!ImportUtils.isenableExpenseItem((String)tripExpenseItem.getString("number"), (String)entityName)) {
                        this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee\u5df2\u7981\u7528\u3002", (String)"TripReimburseBillImportHandle_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return false;
                    }
                    JSONObject JsonTripArea = (JSONObject)row.get("tripentryarea");
                    String tripAreanumber = JsonTripArea.getString("number");
                    DynamicObject tripArea = BusinessDataServiceHelper.loadSingleFromCache((String)"er_triparea", (String)"enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)tripAreanumber)});
                    if (tripArea == null || !tripArea.getBoolean("enable")) {
                        this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u51fa\u5dee\u5730\u57df\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\u3002", (String)"TripReimburseBillImportHandle_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return false;
                    }
                    JSONObject jsonProject = (JSONObject)row.get("std_project");
                    if (!(jsonProject == null || (project = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_project", (String)"enable", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)(projectNumber = jsonProject.getString("number")))})) != null && project.getBoolean("enable"))) {
                        this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u9879\u76ee\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528\u3002", (String)"TripReimburseBillImportHandle_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return false;
                    }
                    JSONObject jsonTravelers = (JSONObject)row.get("travelers");
                    if (jsonTravelers != null) {
                        String[] numbers = jsonTravelers.getString("number").split(",");
                        if (numbers != null) {
                            QFilter number = new QFilter("number", "in", (Object)numbers);
                            QFilter disable = new QFilter("enable", "=", (Object)false);
                            number.and(disable);
                            Map users = BusinessDataServiceHelper.loadFromCache((String)"bos_user", (String)"enable", (QFilter[])new QFilter[]{number});
                            if (users.size() > 0) {
                                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u51fa\u5dee\u4eba\u5b58\u5728\u88ab\u7981\u7528\u3002", (String)"TripReimburseBillImportHandle_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                return false;
                            }
                        }
                    } else {
                        row.put("travelers", dataMap.get("applier"));
                    }
                    dayCount = 0L;
                    startDateStr = (String)row.get("startdate");
                    endDateStr = (String)row.get("enddate");
                    try {
                        Date startDate = ImportUtils.formatDate((String)startDateStr);
                        Date endDate = ImportUtils.formatDate((String)endDateStr);
                        if (startDate.after(endDate)) {
                            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u665a\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"TripReimburseBillImportHandle_5", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                        dayCount = (endDate.getTime() - startDate.getTime()) / 86400000L;
                    }
                    catch (Exception e) {
                        this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u65f6\u95f4\u683c\u5f0f\u9519\u8bef", (String)"TripReimburseBillImportHandle_6", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return false;
                    }
                    if (entryCostDept == null || entryCostDept.get((Object)"number") == null || costOrgShowTypes == 1) {
                        row.put("entrycostdept", dataMap.get("costdept"));
                        if (entryCostCompany == null || entryCostCompany.get((Object)"number") == null) {
                            row.put("entrycostcompany", dataMap.get("costcompany"));
                        }
                    } else if (entryCostDept != null) {
                        String msg;
                        String orgNumber = entryCostDept.getString("number");
                        DynamicObject org = ImportUtils.getOrgByNumber((String)orgNumber);
                        Long companyID = CoreBaseBillServiceHelper.getAccountOrgId((boolean)false, (Long)ErCommonUtils.getPk((Object)org));
                        DynamicObject company = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)companyID)});
                        if (entryCostCompany == null || entryCostCompany.get((Object)"number") == null) {
                            row.put("entrycostcompany", ImportUtils.packageJsonObject((DynamicObject)company));
                        }
                        if (!StringUtils.isEmpty((CharSequence)(msg = ImportUtils.checkCostDeptSelectInRange((long)((JSONObject)dataMap.get("applier")).getLong("id"), (long)((Long)dataMap.get("companyid")), (long)ErCommonUtils.getPk((Object)org))))) {
                            this.fail(data.getStartIndex(), iterator, logger, msg);
                        }
                        if (i == 0) {
                            dataMap.put("costdept", row.get("entrycostdept"));
                            dataMap.put("coscompany", row.get("entrycostcompany"));
                        }
                    }
                    if (entryCostCompany != null) {
                        String costCompanyNumber = entryCostCompany.getString("number");
                        DynamicObject costCompanyObject = ImportUtils.getCompany((String)costCompanyNumber);
                        if (costCompanyObject == null) {
                            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7684\u201c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201d\u4e0d\u5b58\u5728\uff0c\u6216\u5df2\u5c01\u5b58\uff0c\u6216\u975e\u53f6\u5b50\u8282\u70b9\u3002", (String)"ErBillBaseImportHandle_18", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                        JSONObject entrycostdept = (JSONObject)row.get("entrycostdept");
                        String orgNumber = entrycostdept.getString("number");
                        DynamicObject entrycostdeptdyn = ImportUtils.getOrgByNumber((String)orgNumber);
                        List costcompanyNumbers = ErOrgUtils.getCostCompanySelectable((Long)ErCommonUtils.getPk((Object)entrycostdeptdyn), (Long)((Long)dataMap.get("companyid")));
                        if (costcompanyNumbers.size() > 0 && !costcompanyNumbers.contains(costCompanyNumber)) {
                            this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5206\u5f55\u4e2d\u7684\u201c\u8d39\u7528\u627f\u62c5\u516c\u53f8\u201d\u4e0d\u5728\u9009\u62e9\u6743\u9650\u8303\u56f4\u5185\u3002", (String)"ErBillBaseImportHandle_20", (String)"fi-er-opplugin", (Object[])new Object[0]));
                            return false;
                        }
                    }
                    if (costOrgShowTypes == 1 && (costcompany = (JSONObject)dataMap.get("costcompany")) != null && entryCostCompany != null && !StringUtils.equals((CharSequence)costcompany.getString("number"), (CharSequence)entryCostCompany.getString("number"))) {
                        this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e0e\u90e8\u95e8\u5728\u5355\u5934\u663e\u793a\uff0c\u8981\u6c42\u5206\u5f55\u627f\u62c5\u516c\u53f8\u4e0d\u586b\u6216\u4e0e\u5355\u5934\u627f\u62c5\u516c\u53f8\u4e00\u81f4\u3002", (String)"ReimburseBillImportHandle_36", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return false;
                    }
                    exchangeRate = new BigDecimal(1);
                    if (!isCurrency) break block48;
                    JSONObject entryJsonCurrency = (JSONObject)row.get("tripcurrency");
                    if (entryJsonCurrency == null || entryJsonCurrency.getString("number") == null) {
                        this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u672a\u627e\u5230\u5e01\u79cd\u4fe1\u606f\u3002", (String)"TripReimburseBillImportHandle_7", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return false;
                    }
                    if (row.get("tripexchangerate") == null) {
                        JSONObject jsonCompany = (JSONObject)dataMap.get("company");
                        String currencyNumber = ((JSONObject)dataMap.get("currency")).getString("number");
                        Date bizdate = new Date();
                        if (dataMap.get("bizdate") instanceof Date) {
                            bizdate = (Date)dataMap.get("bizdate");
                        }
                        if (dataMap.get("bizdate") != null && dataMap.get("bizdate") instanceof String) {
                            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                            try {
                                bizdate = sdf.parse(String.valueOf(dataMap.get("bizdate")));
                            }
                            catch (ParseException e) {
                                this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u7533\u8bf7\u65e5\u671f\u683c\u5f0f\u6709\u8bef\u3002", (String)"TripReimburseBillImportHandle_21", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                return false;
                            }
                        }
                        exchangeRate = ImportUtils.getExchangeRate((String)entryJsonCurrency.getString("number"), (String)currencyNumber, (String)jsonCompany.getString("number"), (Date)bizdate);
                        row.put("tripexchangerate", exchangeRate.toString());
                        break block47;
                    } else {
                        try {
                            exchangeRate = new BigDecimal((String)row.get("tripexchangerate"));
                            if (exchangeRate.compareTo(new BigDecimal(0)) < 0) {
                                throw new IllegalArgumentException();
                            }
                            break block47;
                        }
                        catch (Exception e) {
                            return false;
                        }
                    }
                }
                row.put("tripexchangerate", "1");
                row.put("tripcurrency", dataMap.get("currency"));
            }
            BigDecimal tripAppOriAmount = new BigDecimal(0);
            JSONArray expenseEntry = (JSONArray)row.get("entryentity");
            int j = 0;
            while (true) {
                BigDecimal oriEntryAmount;
                BigDecimal deductibleTax;
                boolean offset;
                Map expenseRow;
                block51: {
                    int n;
                    String[] stringArray;
                    JSONObject mulseatgrade;
                    String expenseItemAttribute;
                    block52: {
                        block49: {
                            String name;
                            block50: {
                                String[] nameArr;
                                if (j >= expenseEntry.size()) break block49;
                                expenseRow = (Map)expenseEntry.get(j);
                                expenseRow.put("caldaycount", String.valueOf(dayCount));
                                expenseRow.put("daycount", String.valueOf(dayCount));
                                expenseRow.put("exchangerate", row.get("tripexchangerate"));
                                expenseRow.put("trip2startdate", startDateStr);
                                expenseRow.put("trip2enddate", endDateStr);
                                JSONObject jsonExpenseItem = (JSONObject)expenseRow.get("expenseitem");
                                QFilter number = new QFilter("number", "in", (Object)jsonExpenseItem.getString("number"));
                                DynamicObject expenseItem = BusinessDataServiceHelper.loadSingleFromCache((String)"er_tripexpenseitem", (String)"attribute,enable", (QFilter[])new QFilter[]{number});
                                if (!expenseItem.getBoolean("enable")) {
                                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u5dee\u65c5\u9879\u76ee\u5b58\u5728\u88ab\u7981\u7528\u3002", (String)"TripReimburseBillImportHandle_9", (String)"fi-er-opplugin", (Object[])new Object[0]));
                                    return false;
                                }
                                expenseItemAttribute = expenseItem.getString("attribute");
                                if (!Arrays.asList(VEHIC_ATTRIBUTE).contains(expenseItemAttribute)) break block50;
                                if (expenseRow.get("mulseatgrade") == null || ((JSONObject)expenseRow.get("mulseatgrade")).get((Object)"name") == null) break block51;
                                mulseatgrade = (JSONObject)expenseRow.get("mulseatgrade");
                                name = mulseatgrade.getString("name");
                                stringArray = nameArr = name.split(",");
                                n = stringArray.length;
                                break block52;
                            }
                            if (Arrays.asList(ACCD_ALLOWANCE_ATTRIBUTE).contains(expenseItemAttribute) && expenseRow.get("mulseatgrade") != null && ((JSONObject)expenseRow.get("mulseatgrade")).get((Object)"name") != null) {
                                JSONObject mulseatgrade2 = (JSONObject)expenseRow.get("mulseatgrade");
                                name = mulseatgrade2.getString("name");
                                String expenseItemType = "1".equals(expenseItemAttribute) ? ResManager.loadKDString((String)"\u8865\u52a9", (String)"TripReimburseBillImportHandle_19", (String)"fi-er-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4f4f\u5bbf", (String)"TripReimburseBillImportHandle_20", (String)"fi-er-opplugin", (Object[])new Object[0]);
                                this.fail(data.getStartIndex() + j, iterator, logger, String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u578b\u7684\u5dee\u65c5\u9879\u76ee\u4e0d\u5b58\u5728\u5ea7\u4f4d\u7b49\u7ea7\u201c%2$s\u201c", (String)"TripReimburseBillImportHandle_22", (String)"fi-er-opplugin", (Object[])new Object[0]), expenseItemType, name));
                                return false;
                            }
                            break block51;
                        }
                        row.put("tripapporiamount", tripAppOriAmount);
                        row.put("triporiamount", tripAppOriAmount);
                        row.put("tripappamount", tripAppOriAmount.multiply(exchangeRate));
                        row.put("tripamount", tripAppOriAmount.multiply(exchangeRate));
                        ++i;
                        continue block11;
                    }
                    for (int k = 0; k < n; ++k) {
                        String expenseItemType;
                        String item = stringArray[k];
                        DynamicObject[] load = BusinessDataServiceHelper.load((String)"er_seatgradestd", (String)"number", (QFilter[])new QFilter[]{new QFilter("name", "=", (Object)item), new QFilter("attribute", "=", (Object)expenseItemAttribute)});
                        String string = "2".equals(expenseItemAttribute) ? ResManager.loadKDString((String)"\u98de\u673a", (String)"TripReimburseBillImportHandle_16", (String)"fi-er-opplugin", (Object[])new Object[0]) : (expenseItemType = "4".equals(expenseItemAttribute) ? ResManager.loadKDString((String)"\u706b\u8f66", (String)"TripReimburseBillImportHandle_17", (String)"fi-er-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8f6e\u8239", (String)"TripReimburseBillImportHandle_18", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        if (load.length == 0) {
                            this.fail(data.getStartIndex() + j, iterator, logger, String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u578b\u7684\u5dee\u65c5\u9879\u76ee\u4e0d\u5b58\u5728\u5ea7\u4f4d\u7b49\u7ea7\u201c%2$s\u201c", (String)"TripReimburseBillImportHandle_22", (String)"fi-er-opplugin", (Object[])new Object[0]), expenseItemType, item));
                            return false;
                        }
                        if (load.length > 1) {
                            this.fail(data.getStartIndex() + j, iterator, logger, String.format(ResManager.loadKDString((String)"%1$s\u7c7b\u578b\u7684\u5dee\u65c5\u9879\u76ee\u5b58\u5728\u91cd\u590d\u5ea7\u4f4d\u7b49\u7ea7\u201c%2$s\u201c", (String)"TripReimburseBillImportHandle_23", (String)"fi-er-opplugin", (Object[])new Object[0]), expenseItemType, item));
                            return false;
                        }
                        mulseatgrade.put("number", load[0].get("number"));
                    }
                }
                if (!(offset = ((Boolean)expenseRow.get("offset")).booleanValue())) {
                    expenseRow.put("deductibletax", "0");
                }
                try {
                    deductibleTax = new BigDecimal((String)expenseRow.get("deductibletax"));
                    if (deductibleTax.compareTo(new BigDecimal(0)) < 0) {
                        this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u62b5\u6263\u7a0e\u989d\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"TripReimburseBillImportHandle_10", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        return false;
                    }
                }
                catch (Exception e) {
                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u62b5\u6263\u7a0e\u989d\u683c\u5f0f\u9519\u8bef\u3002", (String)"TripReimburseBillImportHandle_11", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return false;
                }
                expenseRow.put("taxamount", deductibleTax.toString());
                try {
                    oriEntryAmount = new BigDecimal((String)expenseRow.get("orientryamount"));
                }
                catch (Exception e) {
                    this.fail(data.getStartIndex(), iterator, logger, ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"TripReimburseBillImportHandle_12", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return false;
                }
                expenseRow.put("price", oriEntryAmount.subtract(deductibleTax).toString());
                tripAppOriAmount = tripAppOriAmount.add(oriEntryAmount);
                BigDecimal noTaxAmount = oriEntryAmount.subtract(deductibleTax);
                expenseRow.put("notaxamount", noTaxAmount);
                BigDecimal entryAmount = oriEntryAmount.multiply(exchangeRate);
                expenseRow.put("entryamount", entryAmount);
                expenseRow.put("entryappamount", entryAmount);
                expenseRow.put("orientryappamount", oriEntryAmount);
                amount = amount.add(entryAmount);
                expenseRow.put("entrycurrency", row.get("tripcurrency"));
                ++j;
            }
            break;
        }
    }
}

