/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.invoicecloud.excel;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.IImportPlugin;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class InvoiceCloudCfgImportPlugin
implements IImportPlugin {
    private static final Log log = LogFactory.getLog(InvoiceCloudCfgImportPlugin.class);
    public static final String NEW = "new";
    public static final String OVERRIDE = "override";
    public static final String OVERRIDE_NEW = "overridenew";

    public boolean beforeImportData(Map<String, Object> data, Map<String, Object> option, List<ImportLogger.ImportLog> importlogs) {
        log.info("\u5bfc\u5165\u53d1\u7968\u4e91\u914d\u7f6e\u6570\u636e:" + data);
        String importType = (String)option.get("importtype");
        JSONObject jsonObject = new JSONObject(data);
        String orgNumber = jsonObject.getJSONObject("org").getString("number");
        DynamicObject org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id,number,ftaxregnum", (QFilter[])new QFilter[]{QFilter.of((String)"number=?", (Object[])new Object[]{orgNumber})});
        if (org == null) {
            log.info("\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u7f16\u53f7\u4e3a:" + orgNumber + "\u7684\u7ec4\u7ec7");
            importlogs.add(new ImportLogger.ImportLog("\u516c\u53f8\u7f16\u7801" + orgNumber + "\uff0c\u7ec4\u7ec7\u7f16\u7801\u4e0d\u6b63\u786e\uff0c\u5bfc\u5165\u5931\u8d25"));
            return false;
        }
        DynamicObject cfg = QueryServiceHelper.queryOne((String)"er_kdinvoicecloudcfg", (String)"id,taxregnum", (QFilter[])new QFilter[]{QFilter.of((String)"org.number=?", (Object[])new Object[]{orgNumber})});
        String taxRegNumFromExcel = jsonObject.getString("taxregnum");
        if (StringUtils.isBlank((CharSequence)taxRegNumFromExcel)) {
            if (cfg != null) {
                data.put("taxregnum", cfg.getString("taxregnum"));
            } else {
                data.put("taxregnum", org.getString("ftaxregnum"));
            }
        }
        if (StringUtils.equals((CharSequence)importType, (CharSequence)NEW) && cfg != null) {
            importlogs.add(new ImportLogger.ImportLog("\u65b0\u589e\u5931\u8d25, \u56e0\u4e3a\u516c\u53f8\u7f16\u7801\u4e3a:" + orgNumber + "\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u6570\u636e\u5df2\u5b58\u5728"));
            return false;
        }
        if (cfg != null) {
            data.put("id", cfg.getLong("id"));
        } else if (StringUtils.equals((CharSequence)importType, (CharSequence)OVERRIDE) && cfg == null) {
            importlogs.add(new ImportLogger.ImportLog("\u8986\u76d6\u5931\u8d25, \u56e0\u4e3a\u516c\u53f8\u7f16\u7801\u4e3a:" + orgNumber + "\u7684\u53d1\u7968\u4e91\u914d\u7f6e\u6570\u636e\u4e0d\u5b58\u5728, \u8bf7\u9009\u62e9\u65b0\u589e\u6216\u8986\u76d6\u65b0\u589e\u5bfc\u5165\u65b9\u5f0f"));
            return false;
        }
        if (StringUtils.isBlank((CharSequence)data.get("taxregnum").toString())) {
            log.info("\u516c\u53f8\u7f16\u7801" + orgNumber + ", \u9700\u5728\u3010\u53d1\u7968\u4e91\u914d\u7f6e\u3011\u8865\u9f50\u7a0e\u53f7;");
            importlogs.add(new ImportLogger.ImportLog("\u516c\u53f8\u7f16\u7801" + orgNumber + ", \u9700\u5728\u3010\u53d1\u7968\u4e91\u914d\u7f6e\u3011\u8865\u9f50\u7a0e\u53f7;"));
            data.put("enable", Boolean.FALSE);
        } else {
            data.put("enable", Boolean.TRUE);
        }
        return true;
    }
}

