/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.invoicecloud.excel;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class InvoiceHistoryInfoImportPlugin
extends BatchImportPlugin {
    public ApiResult save(List<ImportBillData> rowDatas, ImportLogger logger) {
        Map option = this.ctx.getOption();
        Iterator<ImportBillData> iterator = rowDatas.iterator();
        while (iterator.hasNext()) {
            ImportBillData rowData = iterator.next();
            String errMsg = this.validate(rowData, option);
            if (!StringUtils.isNotEmpty((CharSequence)errMsg)) continue;
            logger.log(Integer.valueOf(rowData.getStartIndex()), errMsg);
            logger.fail();
            iterator.remove();
        }
        return super.save(rowDatas, logger);
    }

    private String validate(ImportBillData billData, Map<String, Object> option) {
        QFilter invoicenoFilter;
        QFilter invoicecodeFilter;
        DynamicObject invoiceInfo;
        QFilter billnoFilter;
        JSONObject data = billData.getData();
        if (data == null) {
            return "";
        }
        if (!InvoiceHistoryInfoImportPlugin.validDate(data.get((Object)"invoicedate").toString())) {
            return ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e;", (String)"InvoiceHistoryInfoImportPlugin_0", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        Object billno = data.get((Object)"billno");
        String billType = (String)data.get((Object)"billtype");
        DynamicObjectCollection billColl = QueryServiceHelper.query((String)billType, (String)"id,currency", (QFilter[])new QFilter[]{billnoFilter = new QFilter("billno", "=", billno)});
        if (billColl.size() == 0) {
            return ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u5b58\u5728;", (String)"InvoiceHistoryInfoImportPlugin_1", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        Object currency = ((DynamicObject)billColl.get(0)).get("currency");
        data.put("currency.id", currency);
        data.put("count", (Object)1);
        Object rawTaxRate = data.getOrDefault((Object)"taxrate_invoice", (Object)"-1");
        Double taxrate_invoice = Double.parseDouble(rawTaxRate.toString());
        if ((double)taxrate_invoice.intValue() != taxrate_invoice) {
            return ResManager.loadKDString((String)"\u7a0e\u7387\u662f\u8303\u56f4[0,100]\u7684\u6574\u6570;", (String)"InvoiceHistoryInfoImportPlugin_2", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        if (taxrate_invoice < 0.0 || taxrate_invoice > 100.0) {
            return ResManager.loadKDString((String)"\u7a0e\u7387\u8303\u56f4[0,100],\u5f53\u524d\u7a0e\u7387\u4e0d\u5408\u6cd5;", (String)"InvoiceHistoryInfoImportPlugin_3", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        String importType = (String)option.get("importtype");
        String invoicetype = (String)data.get((Object)"invoicetype");
        ArrayList invoiceTypes = Lists.newArrayList((Object[])new String[]{"4", "1", "3", "5", "15"});
        boolean valueAddInvoice = invoiceTypes.contains(invoicetype);
        String invoicecode = (String)data.getOrDefault((Object)"invoicecode", (Object)"");
        String invoiceno = (String)data.getOrDefault((Object)"invoiceno", (Object)"");
        if (valueAddInvoice && "new".equals(importType) && (invoiceInfo = QueryServiceHelper.queryOne((String)"er_invoiceinforptbill", (String)"id", (QFilter[])new QFilter[]{invoicecodeFilter = new QFilter("invoicecode", "=", (Object)invoicecode), invoicenoFilter = new QFilter("invoiceno", "=", (Object)invoiceno), billnoFilter})) != null) {
            return ResManager.loadKDString((String)"\u552f\u4e00\u6027\u6821\u9a8c\u5931\u8d25\uff1a\u53d1\u7968\u53f7\u7801+\u53d1\u7968\u4ee3\u7801+\u5355\u636e\u7f16\u53f7;", (String)"InvoiceHistoryInfoImportPlugin_4", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        if (valueAddInvoice && (StringUtils.isBlank((CharSequence)invoicecode) || StringUtils.isBlank((CharSequence)invoiceno))) {
            return ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u548c\u53d1\u7968\u53f7\u7801\u5fc5\u987b\u586b\u5199;", (String)"InvoiceHistoryInfoImportPlugin_5", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        if (invoicecode != null && invoicecode.length() > 12) {
            return ResManager.loadKDString((String)"\u53d1\u7968\u4ee3\u7801\u8d85\u957f\uff0c\u957f\u5ea6\u6700\u592712;", (String)"InvoiceHistoryInfoImportPlugin_6", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        if (invoiceno != null && invoiceno.length() > 12) {
            return ResManager.loadKDString((String)"\u53d1\u7968\u53f7\u7801\u8d85\u957f\uff0c\u957f\u5ea6\u6700\u592712;", (String)"InvoiceHistoryInfoImportPlugin_7", (String)"fi-er-opplugin", (Object[])new Object[0]);
        }
        this.subStr((Map<String, Object>)data, "goodsname", 100);
        this.subStr((Map<String, Object>)data, "buyerorgname", 255);
        this.subStr((Map<String, Object>)data, "makeoutcompname", 255);
        this.subStr((Map<String, Object>)data, "passengername", 80);
        return "";
    }

    private void subStr(Map<String, Object> data, String prop, int length) {
        String value = (String)data.getOrDefault(prop, "");
        if (value != null && value.length() > length) {
            data.put(prop, value.substring(0, length));
        }
    }

    public static boolean validDate(String str) {
        boolean convertSuccess = true;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            format.setLenient(false);
            format.parse(str);
        }
        catch (ParseException e) {
            convertSuccess = false;
        }
        return convertSuccess;
    }
}

