/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.invoicecloud.kingdee;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.args.RollbackOperationArgs;
import kd.fi.er.business.invoicecloud.InvoiceService;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceStatusEnum;
import kd.fi.er.business.invoicecloud.provider.param.req.BillOperationInfo;
import kd.fi.er.business.invoicecloud.provider.param.req.DeleteInvoiceReqParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.DeleteInvoiceRespParam;
import kd.fi.er.business.invoicecloud.provider.param.resp.UpdateInvoiceStatusRespParam;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.opplugin.invoicecloud.kingdee.BillOpPlugin;

public class BillDeletePlugin
extends BillOpPlugin {
    @Override
    protected InvoiceStatusEnum getTargetStatus() {
        return InvoiceStatusEnum.unused;
    }

    @Override
    protected InvoiceStatusEnum getRollbackStatus(DynamicObject dataEntity) {
        String billStatus = dataEntity.getString("billstatus");
        if (ErBillStatusEnum.A.toString().equals(billStatus)) {
            return InvoiceStatusEnum.submitted;
        }
        if (ErBillStatusEnum.H.toString().equals(billStatus)) {
            return InvoiceStatusEnum.unused;
        }
        if (ErBillStatusEnum.D.toString().equals(billStatus)) {
            if (ErStdConfig.isSetInvoiceStatusUnusedWhenUnsubmit()) {
                return InvoiceStatusEnum.unused;
            }
            return InvoiceStatusEnum.submitted;
        }
        return InvoiceStatusEnum.unused;
    }

    @Override
    public void rollbackOperation(RollbackOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntitys();
        if (dataEntities.length > 0 && this.getTargetStatus().getValue() == this.getRollbackStatus(dataEntities[0]).getValue()) {
            return;
        }
        super.rollbackOperation(e);
    }

    @Override
    protected UpdateInvoiceStatusRespParam updateInvoiceStatus(DynamicObject dataEntity, String taxRegNum) throws Exception {
        super.updateInvoiceStatus(dataEntity, taxRegNum);
        DeleteInvoiceReqParam request = new DeleteInvoiceReqParam();
        BillOperationInfo billOperationInfo = new BillOperationInfo();
        billOperationInfo.setBillId(dataEntity.getLong("id"));
        billOperationInfo.setBillNumber(dataEntity.getString("billno"));
        billOperationInfo.setBillMetadataNumber(this.billEntityName);
        billOperationInfo.setIcpId(this.icpId);
        billOperationInfo.setOperationId(this.operationId);
        billOperationInfo.setAsync(this.isAsyncOperation);
        billOperationInfo.setOrgId((Object)this.getInvoiceOrgDO(dataEntity));
        request.setBillOperationInfo(billOperationInfo);
        DeleteInvoiceRespParam delRespParam = InvoiceService.getInstanceService().deleteRelationBetweenInvoiceAndBill(request, dataEntity, ErCommonUtils.getPk((Object)this.getInvoiceOrgDO(dataEntity)), null);
        UpdateInvoiceStatusRespParam result = new UpdateInvoiceStatusRespParam();
        result.setErrcode(delRespParam.getErrcode());
        return result;
    }

    @Override
    protected String getOpDesc() {
        return ResManager.loadKDString((String)"\u5220\u9664", (String)"BillDeletePlugin_0", (String)"fi-er-opplugin", (Object[])new Object[0]);
    }
}

