/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.invoicecloud.kingdee;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceStatusEnum;
import kd.fi.er.business.invoicecloud.util.HeadInvoiceStatusUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.opplugin.invoicecloud.kingdee.BillOpPlugin;

public class BillSupplementSavePlugin
extends BillOpPlugin {
    private static final Log logger = LogFactory.getLog(BillSupplementSavePlugin.class);

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("company");
        fieldKeys.add("expenseentryentity.expeapproveamount");
        fieldKeys.add("entryentity.orientryappamount");
        fieldKeys.add("invoiceitementry");
        fieldKeys.add("invoiceitementry.totalamount");
        fieldKeys.add("invoiceitementry.itementryid");
        fieldKeys.add("invoiceitementry.invoiceheadentryid");
        fieldKeys.add("invoiceandexpense");
        fieldKeys.add("invoiceandexpense.expenseentryid");
        fieldKeys.add("invoiceandexpense.invoiceentryid");
        fieldKeys.add("invoiceentry.totalamount");
        fieldKeys.add("imageno");
        fieldKeys.add("creator");
        fieldKeys.add("createtime");
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
        fieldKeys.add("company");
        fieldKeys.add("billno");
        fieldKeys.add("is_all_einvoice");
        fieldKeys.add("noinvoice");
        fieldKeys.add("needimagescan");
        fieldKeys.add("expenseentryentity");
        fieldKeys.add("tripentry");
        fieldKeys.add("entryentity");
        fieldKeys.add("invoiceentry");
        fieldKeys.add("invoicetype");
        fieldKeys.add("expenseitem");
        fieldKeys.add("expenseitem.noinvoice");
        fieldKeys.add("needimagescan");
        fieldKeys.add("itemfrom");
        fieldKeys.add("invoicefrom");
        fieldKeys.add("expenseitem.noinvoice");
        fieldKeys.add("settlementtype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    InvoiceUtils.BillEntityType type;
                    Boolean allowOver;
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObject company = bill.getDynamicObject("company");
                    if (company == null) {
                        return;
                    }
                    Long companyId = (Long)company.getPkValue();
                    DynamicObjectCollection invoiceItemEntryDOs = bill.getDynamicObjectCollection("invoiceitementry");
                    if (invoiceItemEntryDOs.isEmpty() || (allowOver = Boolean.valueOf(SystemParamterUtil.isAmountOverInvoice((Long)companyId))).booleanValue() || (type = BillSupplementSavePlugin.this.currenBillType(bill.getDynamicObjectType().getName())) == null) continue;
                    List results = InvoiceUtils.checkKeyAmount((DynamicObject)bill, (InvoiceUtils.BillEntityType)type, (String)BillSupplementSavePlugin.this.getAmount(bill.getDynamicObjectType().getName()), (String)ResManager.loadKDString((String)"\u6838\u5b9a\u91d1\u989d", (String)"BillSupplementSavePlugin_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    for (String result : results) {
                        this.addErrorMessage(dataEntity, result);
                    }
                }
            }
        });
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if ("saveinvoice".equals(e.getOperationKey())) {
            DynamicObject[] dataEntities;
            for (DynamicObject dynamicObject : dataEntities = e.getDataEntities()) {
                HeadInvoiceStatusUtil.needScanSetting((DynamicObject)dynamicObject);
            }
        }
    }

    @Override
    protected InvoiceStatusEnum getTargetStatus() {
        return InvoiceStatusEnum.audited;
    }

    @Override
    protected InvoiceStatusEnum getRollbackStatus(DynamicObject dataEntity) {
        return InvoiceStatusEnum.unused;
    }

    @Override
    protected String getOpDesc() {
        return ResManager.loadKDString((String)"\u4fdd\u5b58\u540e\u8865\u53d1\u7968", (String)"BillSupplementSavePlugin_0", (String)"fi-er-opplugin", (Object[])new Object[0]);
    }

    protected InvoiceUtils.BillEntityType currenBillType(String entityId) {
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId)) {
            return InvoiceUtils.BillEntityType.DailyReimburse;
        }
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            return InvoiceUtils.BillEntityType.PublicReimburse;
        }
        if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            return InvoiceUtils.BillEntityType.TripReimburse;
        }
        return null;
    }

    protected String getAmount(String entityId) {
        if (ErEntityTypeUtils.isDailyReimburseBill((String)entityId)) {
            return "expeapproveamount";
        }
        if (ErEntityTypeUtils.isPublicReimburseBill((String)entityId)) {
            return "expeapproveamount";
        }
        if (ErEntityTypeUtils.isTripReimburseBill((String)entityId)) {
            return "orientryappamount";
        }
        return "";
    }
}

