/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.publicbiz.bill.importinit;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.pub.ContractUtil;
import kd.fi.er.opplugin.daily.web.importplugin.importdatahandle.ErBillImportDataHandle;
import kd.fi.er.opplugin.publicbiz.bill.importhandle.ContractBillImportHandle;
import kd.fi.er.opplugin.publicbiz.bill.importinit.ErPubBillInitImportPlugin;
import org.apache.commons.lang3.StringUtils;

public class ContractBillInitImportPlugin
extends ErPubBillInitImportPlugin {
    private static Log logger = LogFactory.getLog(ContractBillInitImportPlugin.class);

    @Override
    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ListIterator<ImportBillData> iterator = ((ArrayList)rowdatas).listIterator();
        ErBillImportDataHandle importHandle = this.getHandle();
        while (iterator.hasNext()) {
            ImportBillData next = (ImportBillData)iterator.next();
            if (!importHandle.handleHeadData(next, iterator, logger)) continue;
            importHandle.handleExpenseEntry(next, iterator, logger);
            this.handlePartyEntry(next, iterator, logger);
        }
        return super.save(rowdatas, logger);
    }

    @Override
    protected ErBillImportDataHandle getHandle() {
        return new ContractBillImportHandle();
    }

    public boolean handlePartyEntry(ImportBillData data, Iterator<ImportBillData> iterator, ImportLogger logger) {
        JSONObject dataMap = data.getData();
        String errMsg = this.handlePartyEntryData((Map<String, Object>)dataMap);
        if (StringUtils.isNotBlank((CharSequence)errMsg)) {
            logger.log(Integer.valueOf(data.getStartIndex()), errMsg);
            logger.fail();
            iterator.remove();
            return false;
        }
        return true;
    }

    protected String handlePartyEntryData(Map<String, Object> dataMap) {
        logger.info("ContractBillImportHandle.handleCustomHeadData>>>>>>>>>>>>>>>>>>>>>\u5408\u540c\u53f0\u8d26\u5355\u5bfc\u5165\u5355\u5934\u6570\u636e\u7ed3\u675f>>>>>>>>>>");
        return ContractUtil.handlepartyEntryDataForContractBill(dataMap);
    }
}

