/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.share;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ExpenseShareBillDeleteOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("shareway");
        fieldKeys.add("billhead_lk");
        fieldKeys.add("billhead_lk.billhead_lk_stableid");
        fieldKeys.add("billhead_lk.billhead_lk_sbillid");
        fieldKeys.add("billhead_lk.billhead_lk_sid");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        this.handleDeleteBeforeShareBill(e);
    }

    private void handleDeleteBeforeShareBill(AfterOperationArgs e) {
        String opKey = e.getOperationKey();
        if (!"delete".equals(opKey)) {
            return;
        }
        HashMap<String, HashSet<Object>> srcEntityName_sBillId = new HashMap<String, HashSet<Object>>();
        for (DynamicObject bill : e.getDataEntities()) {
            DynamicObjectCollection billHeadLks;
            if (!"A".equals(bill.getString("shareway")) || (billHeadLks = bill.getDynamicObjectCollection("billhead_lk")).isEmpty()) continue;
            DynamicObject billHeadLk = (DynamicObject)billHeadLks.get(0);
            TableDefine tableDefine = EntityMetadataCache.loadTableDefine((Long)billHeadLk.getLong("billhead_lk_stableid"));
            String srcEntityNumber = tableDefine.getEntityNumber();
            HashSet<Object> sBillIds = (HashSet<Object>)srcEntityName_sBillId.get(srcEntityNumber);
            if (sBillIds == null) {
                sBillIds = new HashSet<Object>();
                srcEntityName_sBillId.put(srcEntityNumber, sBillIds);
            }
            sBillIds.add(billHeadLk.get("billhead_lk_sbillid"));
        }
        for (Map.Entry entry : srcEntityName_sBillId.entrySet()) {
            this.updateAutoGenShare((String)entry.getKey(), (Set)entry.getValue());
        }
    }

    private void updateAutoGenShare(String srcEntityNumber, Set<Object> sBillIds) {
        DynamicObject[] bills;
        for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)srcEntityNumber, (String)"autogenshare", (QFilter[])new QFilter("id", "in", sBillIds).toArray())) {
            bill.set("autogenshare", (Object)false);
        }
        SaveServiceHelper.save((DynamicObject[])bills);
    }
}

