/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.share;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;

public class ExpenseShareBillOpPlugin
extends AbstractOperationServicePlugIn {
    private static final String OP_SUBMIT = "submit";
    private static final String OP_APPROVE_SUBMIT = "approveandsubmit";
    private static final Log logger = LogFactory.getLog(AbstractOperationServicePlugIn.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("shareway");
        fieldKeys.add("billhead_lk");
        fieldKeys.add("billhead_lk.billhead_lk_stableid");
        fieldKeys.add("billhead_lk.billhead_lk_sbillid");
        fieldKeys.add("billhead_lk.billhead_lk_sid");
        fieldKeys.add("currency");
        fieldKeys.add("currency.amtprecision");
        fieldKeys.add("expenseentryentity");
        fieldKeys.add("currexpenseamount");
        fieldKeys.add("expeapprovecurramount");
        fieldKeys.add("expenseentryentity_wait");
        fieldKeys.add("expenseamount_wait");
        fieldKeys.add("currexpenseamount_wait");
        fieldKeys.add("expeapprovecurramount_w");
        fieldKeys.add("approvetax_wait");
        fieldKeys.add("reimburseamount");
        fieldKeys.add("approveamount");
        fieldKeys.add("waitamount");
        fieldKeys.add("waitapproveamount");
        fieldKeys.add("expenseentryentity_rule");
        fieldKeys.add("sharerate_comrule");
        fieldKeys.add("expeapproveamount_wait");
        fieldKeys.add("entrycurrency_wait");
        fieldKeys.add("sumsharerate");
        fieldKeys.add("taxamount_wait");
        fieldKeys.add("deductibletax_wait");
        fieldKeys.add("this_e_applyamount");
        fieldKeys.add("this_e_currapplyamount");
        fieldKeys.add("this_e_approveamount");
        fieldKeys.add("this_e_approvecurramount");
        fieldKeys.add("this_e_approvetax");
        fieldKeys.add("this_e_tax");
        fieldKeys.add("this_e_notax");
        fieldKeys.add("this_e_apporvetax");
        fieldKeys.add("this_e_approvenotax");
        fieldKeys.add("sharemethod");
        fieldKeys.add("exchangerate_wait");
        fieldKeys.add("this_e_curprice");
        fieldKeys.add("expquotetype_wait");
        fieldKeys.add("sharecompany");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billEntitys;
                for (ExtendedDataEntity billEntity : billEntitys = this.getDataEntities()) {
                    DynamicObject bill = billEntity.getDataEntity();
                    DynamicObjectCollection entrys = bill.getDynamicObjectCollection("expenseentryentity");
                    BigDecimal totalReimAmount = entrys.stream().map(v -> v.getBigDecimal("currexpenseamount")).reduce((b1, b2) -> b1.add((BigDecimal)b2)).orElse(BigDecimal.ZERO);
                    BigDecimal totalApproveAmount = entrys.stream().map(v -> v.getBigDecimal("expeapprovecurramount")).reduce((b1, b2) -> b1.add((BigDecimal)b2)).orElse(BigDecimal.ZERO);
                    DynamicObjectCollection waitEntrys = bill.getDynamicObjectCollection("expenseentryentity_wait");
                    BigDecimal totalWaitAmount = waitEntrys.stream().map(v -> v.getBigDecimal("this_e_currapplyamount")).reduce((b1, b2) -> b1.add((BigDecimal)b2)).orElse(BigDecimal.ZERO);
                    BigDecimal thisApproveAmount = waitEntrys.stream().map(v -> v.getBigDecimal("this_e_approvecurramount")).reduce((b1, b2) -> b1.add((BigDecimal)b2)).orElse(BigDecimal.ZERO);
                    bill.set("reimburseamount", (Object)totalReimAmount);
                    bill.set("approveamount", (Object)totalApproveAmount);
                    bill.set("waitamount", (Object)totalWaitAmount);
                    bill.set("waitapproveamount", (Object)thisApproveAmount);
                    if ("save".equalsIgnoreCase(this.getOperateKey()) || thisApproveAmount.compareTo(totalApproveAmount) == 0) continue;
                    this.addErrorMessage(billEntity, ResManager.loadKDString((String)"\u5206\u644a\u540e\u6838\u5b9a\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u672c\u6b21\u5f85\u644a\u6838\u5b9a\u91d1\u989d\u5408\u8ba1\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ExpenseShareBillOpPlugin_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String opKey = e.getOperationKey();
        if (opKey.equals(OP_SUBMIT) || opKey.equals(OP_APPROVE_SUBMIT)) {
            for (DynamicObject bill : e.getDataEntities()) {
                DynamicObjectCollection shareEntries = bill.getDynamicObjectCollection("expenseentryentity");
                if (!CollectionUtils.isEmpty((Collection)shareEntries)) {
                    DynamicObject costCompany = (DynamicObject)((DynamicObject)shareEntries.get(0)).get("entrycostcompany");
                    bill.set("sharecompany", (Object)costCompany);
                    continue;
                }
                logger.info("ShareEntries is empty!");
            }
        }
    }
}

