/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.trip.checking;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class CheckingBillDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CheckingBillDeleteOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billEntitys;
                for (ExtendedDataEntity billEntity : billEntitys = this.getDataEntities()) {
                    DynamicObject bill = billEntity.getDataEntity();
                    if (bill.get("billstatus") == null || !"C".equals(bill.getString("billstatus"))) continue;
                    this.addErrorMessage(billEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u5ba1\u6838\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"EM-E-537400", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.deleteCheckingBill(e);
    }

    private void deleteCheckingBill(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ORM orm = ORM.create();
        ArrayList<Long> checkingBillIds = new ArrayList<Long>();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
            String formId = dynamicObjectType.getName();
            String checkingBillId = String.valueOf(dataEntity.getPkValue());
            logger.info("checking formid:" + formId + " checkingBillId:" + checkingBillId);
            QFilter qFilter = new QFilter("checkingformid", "=", (Object)formId);
            qFilter = qFilter.and(new QFilter("checkingid", "=", (Object)checkingBillId));
            DynamicObjectCollection checkingBills = QueryServiceHelper.query((String)"er.checkingbill", (String)"er_allcheckingbill", (String)"id", (QFilter[])new QFilter[]{qFilter}, (String)"id");
            for (DynamicObject checkingBill : checkingBills) {
                long allCheckingId = checkingBill.getLong("id");
                logger.info("delete allCheckingId:" + allCheckingId);
                checkingBillIds.add(allCheckingId);
            }
        }
        if (checkingBillIds.size() > 0) {
            DeleteServiceHelper.delete((IDataEntityType)orm.getDataEntityType("er_allcheckingbill"), (Object[])checkingBillIds.toArray());
        }
    }
}

