/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.trip.checking;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class CheckingBillSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(CheckingBillSaveOp.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.saveAllCheckingBill(e);
    }

    private void saveAllCheckingBill(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList checkingBills = Lists.newArrayListWithExpectedSize((int)8);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject allCheckingBill;
            DynamicObjectType dynamicObjectType = dataEntity.getDynamicObjectType();
            String formID = dynamicObjectType.getName();
            Object checkingBillId = dataEntity.getPkValue();
            String orderNum = dataEntity.getString("ordernum");
            String queryCheckingStr = "checkingformid=? and ordernum=?";
            Object[] paramObj = new Object[]{formID, orderNum};
            QFilter qFilter = QFilter.of((String)queryCheckingStr, (Object[])paramObj);
            DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"er_allcheckingbill", (String)"id", (QFilter[])new QFilter[]{qFilter});
            DynamicObject checkingBill = dynamicObject != null ? (allCheckingBill = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("id"), (String)"er_allcheckingbill")) : BusinessDataServiceHelper.newDynamicObject((String)"er_allcheckingbill");
            checkingBill.set("checkingformid", (Object)formID);
            checkingBill.set("checkingid", checkingBillId);
            logger.info("checking formId:" + formID + " checkingOrdernum:" + orderNum);
            DataEntityPropertyCollection checkingProperties = dynamicObjectType.getProperties();
            DataEntityPropertyCollection allCheckingProperties = checkingBill.getDynamicObjectType().getProperties();
            for (IDataEntityProperty checkingProperty : checkingProperties) {
                String checkingPropName = checkingProperty.getName();
                if ("id".equals(checkingPropName) || allCheckingProperties.get((Object)checkingPropName) == null) continue;
                checkingBill.set(checkingPropName, dataEntity.get(checkingPropName));
            }
            String oabillnum = dataEntity.getString("oabillnum");
            QFilter uFilter = new QFilter("billno", "=", (Object)oabillnum);
            DynamicObject reqbillInfo = QueryServiceHelper.queryOne((String)"er_tripreqbill", (String)"id,company", (QFilter[])new QFilter[]{uFilter});
            if (null != reqbillInfo) {
                Long company = reqbillInfo.getLong("company");
                checkingBill.set("company", (Object)company);
            }
            checkingBills.add(checkingBill);
        }
        if (checkingBills.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])checkingBills.toArray(new DynamicObject[checkingBills.size()]));
        }
    }
}

