/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.trip.dailybiz;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;

public class DailyVehicleBillWriteBackOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(DailyVehicleBillWriteBackOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        Map opParameter;
        String entityNumber = "";
        String operateKey = "";
        MainEntityType billEntityType = this.billEntityType;
        BillEntityType mainType = null;
        if (billEntityType instanceof BillEntityType) {
            mainType = (BillEntityType)billEntityType;
        }
        if (mainType != null) {
            entityNumber = mainType.getName();
        }
        if ((opParameter = this.operateMeta) != null && opParameter.get("key") != null) {
            operateKey = (String)opParameter.get("key");
        }
        switch (entityNumber) {
            case "er_dailyvehiclebill": {
                this.handleBillAuditStatus(e, operateKey);
            }
        }
    }

    private void handleBillAuditStatus(AfterOperationArgs e, String operateKey) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList billNos = Lists.newArrayListWithCapacity((int)dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            billNos.add(dataEntity.get("billno"));
        }
        logger.info("Line 69 \u5f53\u524d\u64cd\u4f5c\u5355\u636e\u7f16\u53f7" + billNos);
        this.judgeIsTripReqBill(billNos);
        DynamicObject[] bills = BusinessDataServiceHelper.load((String)"er_allorderbill", (String)"billauditstatus,oabillnum", (QFilter[])new QFilter[]{new QFilter("oabillnum ", "in", (Object)billNos)});
        switch (operateKey) {
            case "audit": {
                for (DynamicObject bill : bills) {
                    bill.set("billauditstatus", (Object)ResManager.loadKDString((String)"\u5ba1\u6838\u901a\u8fc7", (String)"AbstractOrderDao_1", (String)"fi-er-business", (Object[])new Object[0]));
                }
                break;
            }
            case "unaudit": {
                for (DynamicObject bill : bills) {
                    bill.set("billauditstatus", (Object)ResManager.loadKDString((String)"\u5ba1\u6838\u672a\u901a\u8fc7", (String)"AbstractOrderDao_2", (String)"fi-er-business", (Object[])new Object[0]));
                }
                break;
            }
        }
        SaveServiceHelper.update((DynamicObject[])bills);
    }

    private void judgeIsTripReqBill(List<Object> billNos) {
        DynamicObjectCollection reqBills = QueryServiceHelper.query((String)"er_tripreqbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNos)});
        if (CollectionUtils.isEmpty((Collection)reqBills)) {
            return;
        }
        ArrayList needRemoveBillNo = Lists.newArrayListWithCapacity((int)billNos.size());
        for (int i = 0; i < reqBills.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)reqBills.get(i);
            if (!billNos.contains(dynamicObject.get("billno"))) continue;
            needRemoveBillNo.add(dynamicObject.get("billno"));
        }
        if (CollectionUtils.isNotEmpty((Collection)needRemoveBillNo)) {
            billNos.removeAll(needRemoveBillNo);
        }
    }
}

