/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.trip.dailybiz;

import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.validator.trip.dailybiz.DailyApplyCheckOrderValidator;
import kd.fi.er.validator.trip.dailybiz.TripReimburseCheckOrderValidator;
import kd.fi.er.validator.trip.dailybiz.TripReqCheckOrderValidator;

public class SyncReqBillToTripOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(SyncReqBillToTripOp.class);
    private String entityNumber;
    private String operateKey;

    public void initialize(InitOperationArgs e) {
        Map opParameter;
        super.initialize(e);
        MainEntityType entityType = this.billEntityType;
        BillEntityType mainType = null;
        if (entityType instanceof BillEntityType) {
            mainType = (BillEntityType)entityType;
        }
        if (mainType != null) {
            this.entityNumber = mainType.getName();
        }
        if ((opParameter = this.operateMeta) != null && opParameter.get("key") != null) {
            this.operateKey = (String)opParameter.get("key");
        }
        logger.info("\u5546\u65c5\u96c6\u6210,\u7533\u8bf7\u5355\u540c\u6b65,\u4e1a\u52a1\u5355\u636e\u662f:" + this.entityNumber + ",\u4e1a\u52a1\u64cd\u4f5c\u662f:" + this.operateKey);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        switch (this.entityNumber) {
            case "er_tripreqbill": {
                fieldKeys.add("applier");
                fieldKeys.add("billno");
                fieldKeys.add("isloan");
                fieldKeys.add("ischange");
                fieldKeys.add("company");
                break;
            }
            case "er_tripreimbursebill": {
                fieldKeys.add("tripentry");
                fieldKeys.add("entryentity");
                fieldKeys.add("ordernum");
                break;
            }
            case "er_dailyvehiclebill": {
                fieldKeys.add("applier");
                fieldKeys.add("billno");
                fieldKeys.add("company");
                break;
            }
            case "er_dailyapplybill": {
                fieldKeys.add("billno");
                fieldKeys.add("reimbursetype");
                fieldKeys.add("company");
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        List validators = e.getValidators();
        switch (this.entityNumber) {
            case "er_tripreqbill": {
                switch (this.operateKey) {
                    case "unaudit": 
                    case "closebill": 
                    case "invalidbtn": 
                    case "unsubmit": 
                    case "noapproval": 
                    case "tripchange": {
                        validators.add(new TripReqCheckOrderValidator());
                    }
                }
                break;
            }
            case "er_tripreimbursebill": {
                switch (this.operateKey) {
                    case "submit": {
                        validators.add(new TripReimburseCheckOrderValidator());
                    }
                }
                break;
            }
            case "er_dailyapplybill": {
                switch (this.operateKey) {
                    case "unaudit": {
                        validators.add(new DailyApplyCheckOrderValidator());
                    }
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        switch (this.entityNumber) {
            case "er_tripreqbill": {
                switch (this.operateKey) {
                    case "submit": {
                        this.handleReqBillSync(e, "checkIsVip", "1", this.operateKey);
                        break;
                    }
                    case "unsubmit": {
                        this.handleReqBillSync(e, "checkIsVip", "2", this.operateKey);
                        break;
                    }
                    case "audit": 
                    case "triprevoke": {
                        this.handleReqBillSync(e, "alreadyApproved", "1", this.operateKey);
                        break;
                    }
                    case "unaudit": 
                    case "closebill": 
                    case "invalidbtn": 
                    case "tripchange": 
                    case "noapproval": {
                        this.handleReqBillSync(e, "alreadyApproved", "2", this.operateKey);
                    }
                }
                break;
            }
            case "er_tripreimbursebill": {
                switch (this.operateKey) {
                    case "submit": {
                        this.handleReburseBillSync(e, "2");
                        break;
                    }
                    case "unsubmit": 
                    case "invalidbtn": 
                    case "noapproval": 
                    case "unaudit": {
                        this.handleReburseBillSync(e, "3");
                    }
                }
            }
            case "er_dailyvehiclebill": {
                block69: for (DynamicObject dynamicObject : e.getDataEntities()) {
                    switch (this.operateKey) {
                        case "submit": 
                        case "audit": {
                            TripCommonUtil.pushDailyVehicleBillToMQ((String)"er_dailyvehiclebill", (Long)((Long)dynamicObject.getPkValue()), (String)this.operateKey, (String)"1");
                            continue block69;
                        }
                        case "unsubmit": 
                        case "noapprive": {
                            TripCommonUtil.pushDailyVehicleBillToMQ((String)"er_dailyvehiclebill", (Long)((Long)dynamicObject.getPkValue()), (String)this.operateKey, (String)"2");
                        }
                    }
                }
                break;
            }
            case "er_dailyapplybill": {
                block70: for (final DynamicObject dynamicObject : e.getDataEntities()) {
                    switch (this.operateKey) {
                        case "audit": {
                            ThreadService.execute((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    TripCommonUtil.pushDailyApplBill((String)"er_dailyapplybill", (Long)((Long)dynamicObject.getPkValue()), (String)SyncReqBillToTripOp.this.operateKey, (String)"1");
                                }
                            }, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
                            continue block70;
                        }
                        case "closebill": 
                        case "unaudit": {
                            ThreadService.execute((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    TripCommonUtil.pushDailyApplBill((String)"er_dailyapplybill", (Long)((Long)dynamicObject.getPkValue()), (String)SyncReqBillToTripOp.this.operateKey, (String)"2");
                                }
                            }, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
                        }
                    }
                }
                break;
            }
            case "er_publicreimbursebill": {
                block71: for (final DynamicObject dynamicObject : e.getDataEntities()) {
                    switch (this.operateKey) {
                        case "audit": {
                            ThreadService.execute((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    TripCommonUtil.pushDailyApplBill((String)"er_publicreimbursebill", (Long)((Long)dynamicObject.getPkValue()), (String)SyncReqBillToTripOp.this.operateKey, (String)"2");
                                }
                            }, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
                            continue block71;
                        }
                        case "unaudit": {
                            ThreadService.execute((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    TripCommonUtil.pushDailyApplBill((String)"er_publicreimbursebill", (Long)((Long)dynamicObject.getPkValue()), (String)SyncReqBillToTripOp.this.operateKey, (String)"3");
                                }
                            }, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
                        }
                    }
                }
                break;
            }
        }
    }

    private void handleReqBillSync(AfterOperationArgs e, String approveType, String syncStatus, String operateKey) {
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            DynamicObject userObject;
            Long userId;
            Boolean isNoApprova;
            if (dynamicObject.getBoolean("isloan")) {
                logger.info("\u5546\u65c5\u96c6\u6210,\u51fa\u5dee\u7533\u8bf7\u5355\u540c\u6b65,\u540c\u6b65\u7684\u5355\u636e\u4e3a\u51fa\u5dee\u501f\u6b3e\u5355");
                continue;
            }
            if ("er_tripreqbill".equalsIgnoreCase(this.entityNumber) && "audit".equalsIgnoreCase(this.operateKey) && (isNoApprova = Boolean.valueOf(CommonServiceHelper.noApprovaWhiteList((Long)(userId = (Long)(userObject = dynamicObject.getDynamicObject("applier")).getPkValue()), (String)"1"))).booleanValue()) continue;
            TripCommonUtil.pushReqbillToMQ((String)"er_tripreqbill", (Long)((Long)dynamicObject.getPkValue()), (String)operateKey, (String)approveType, (String)syncStatus);
        }
    }

    private void handleDailyVehicleBillSync(AfterOperationArgs e, String syncStatus, String operateKey) {
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            TripCommonUtil.pushDailyVehicleBillToMQ((String)"er_dailyvehiclebill", (Long)((Long)dynamicObject.getPkValue()), (String)operateKey, (String)syncStatus);
        }
    }

    private void handleReburseBillSync(AfterOperationArgs e, String syncStatus) {
        for (DynamicObject dynamicObject : e.getDataEntities()) {
            TripCommonUtil.pushReqbillToMQ((String)"er_tripreimbursebill", (Long)((Long)dynamicObject.getPkValue()), (String)this.operateKey, (String)"alreadyApproved", (String)syncStatus);
        }
    }
}

