/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.trip.order;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;

public class SyncApplyBillOp
extends AbstractOperationServicePlugIn {
    private final Log logger = LogFactory.getLog(SyncApplyBillOp.class);
    private static final String REQ_PREFIX = "req";
    private static final String VEHICLE_PREFIX = "vehicle";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("serverfield");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    Set failBillNos;
                    DynamicObject entity = dataEntity.getDataEntity();
                    String server = entity.getString("serverfield");
                    DynamicObjectCollection reqEntry = entity.getDynamicObjectCollection("reqbillentryentity");
                    DynamicObjectCollection vehicleEntry = entity.getDynamicObjectCollection("vehiclebillentryentity");
                    List reqSelectDatas = reqEntry.stream().filter(obj -> obj.getBoolean("reqcheckbox")).collect(Collectors.toList());
                    List vehicleSelectDatas = vehicleEntry.stream().filter(obj -> obj.getBoolean("vehiclecheckbox")).collect(Collectors.toList());
                    HashSet needRemindBillNoSet = Sets.newHashSetWithExpectedSize((int)16);
                    if (CollectionUtils.isNotEmpty(reqSelectDatas)) {
                        needRemindBillNoSet.addAll(SyncApplyBillOp.this.syncApplyBills(reqSelectDatas, SyncApplyBillOp.REQ_PREFIX, "er_tripreqbill", server));
                    }
                    if (!Supplier.ALI.getValue().equals(server) && CollectionUtils.isNotEmpty(vehicleSelectDatas)) {
                        needRemindBillNoSet.addAll(SyncApplyBillOp.this.syncApplyBills(vehicleSelectDatas, SyncApplyBillOp.VEHICLE_PREFIX, "er_dailyvehiclebill", server));
                    }
                    StringBuilder notSyncSb = new StringBuilder();
                    if (CollectionUtils.isNotEmpty((Collection)needRemindBillNoSet)) {
                        for (String s : needRemindBillNoSet) {
                            notSyncSb = new StringBuilder();
                            this.addMessage(dataEntity, notSyncSb.append(s).append(":").append(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u540c\u6b65\u5f53\u524d\u7c7b\u578b\u5ba1\u6279\u5355\u81f3\u5bf9\u5e94\u670d\u52a1\u5546\u3002", (String)"TripSyncApplyBillMobPlugin_05", (String)"fi-er-formplugin", (Object[])new Object[0])).append("\n").toString());
                        }
                    }
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException exception) {
                        SyncApplyBillOp.this.logger.error("\u4f11\u7720\u9519\u8bef", (Throwable)exception);
                    }
                    Set billNos = reqEntry.stream().filter(obj -> obj.getBoolean("reqcheckbox")).map(obj -> obj.getString("reqbillno")).collect(Collectors.toSet());
                    billNos.addAll(vehicleEntry.stream().filter(obj -> obj.getBoolean("vehiclecheckbox")).map(obj -> obj.getString("vehiclebillno")).collect(Collectors.toSet()));
                    QFilter or = new QFilter("function", "=", (Object)ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u5355", (String)"ErAccountChangeBillPlugin_04", (String)"fi-er-formplugin", (Object[])new Object[0])).or("function", "=", (Object)ResManager.loadKDString((String)"\u7528\u8f66\u7533\u8bf7\u5355", (String)"ErHomeAddNewDialogPlugin_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
                    DynamicObjectCollection logs = QueryServiceHelper.query((String)"er_trip_log", (String)"server,status,billno_tag", (QFilter[])new QFilter[]{new QFilter("traceid", "=", (Object)RequestContext.get().getTraceId()), new QFilter("billno_tag", "in", billNos), or});
                    if (!CollectionUtils.isNotEmpty((Collection)logs) || !CollectionUtils.isNotEmpty(failBillNos = logs.stream().filter(obj -> obj.getString("status").equals("B")).map(obj -> obj.getString("billno_tag")).collect(Collectors.toSet()))) continue;
                    Set successBillNos = logs.stream().filter(obj -> obj.getString("status").equals("A")).map(obj -> obj.getString("billno_tag")).collect(Collectors.toSet());
                    for (String successBillNo : successBillNos) {
                        notSyncSb = new StringBuilder();
                        this.addMessage(dataEntity, notSyncSb.append(successBillNo).append(":").append(ResManager.loadKDString((String)"\u540c\u6b65\u6210\u529f\u3002", (String)"TripSyncApplyBillMobPlugin_08", (String)"fi-er-formplugin", (Object[])new Object[0])).append("\n").toString());
                    }
                    for (String failBillNo : failBillNos) {
                        notSyncSb = new StringBuilder();
                        this.addMessage(dataEntity, notSyncSb.append(failBillNo).append(":").append(ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\u3002", (String)"TripSyncApplyBillMobPlugin_06", (String)"fi-er-formplugin", (Object[])new Object[0])).append("\n").toString());
                    }
                }
            }
        });
    }

    private Set<String> syncApplyBills(List<DynamicObject> selectDatas, String prefix, String formId, String server) {
        Set billNos = selectDatas.stream().filter(obj -> StringUtils.isNotEmpty((String)obj.getString(prefix + "billno"))).map(obj -> obj.getString(prefix + "billno")).collect(Collectors.toSet());
        DynamicObjectCollection bills = QueryServiceHelper.query((String)formId, (String)"id,billno,company,org,applier.id", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNos)});
        Map<String, List<DynamicObject>> sameCompanyAndOrgs = bills.stream().collect(Collectors.groupingBy(obj -> obj.getLong("company") + "-" + obj.getLong("org")));
        Set<String> keySet = sameCompanyAndOrgs.keySet();
        HashMap orgIdAndCompanyIdMap = Maps.newHashMapWithExpectedSize((int)2);
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)keySet.size());
        for (String companyAndOrgKey : keySet) {
            String[] split = companyAndOrgKey.split("-");
            orgIdAndCompanyIdMap.put("orgId", Long.parseLong((String)split[1]));
            orgIdAndCompanyIdMap.put("companyId", Long.parseLong((String)split[0]));
            boolean bl = TripCommonUtil.checkIsNeedBill((String)server, (Map)orgIdAndCompanyIdMap, (String)formId);
            resultMap.put(companyAndOrgKey, bl);
        }
        Set entries = resultMap.entrySet();
        ArrayList needSyncBills = Lists.newArrayListWithCapacity((int)16);
        for (Map.Entry entry2 : entries) {
            String companyAndOrgKey;
            List<DynamicObject> billList;
            if (!((Boolean)entry2.getValue()).booleanValue() || CollectionUtils.isEmpty(billList = sameCompanyAndOrgs.get(companyAndOrgKey = (String)entry2.getKey()))) continue;
            needSyncBills.addAll(billList);
        }
        if (CollectionUtils.isNotEmpty((Collection)needSyncBills)) {
            if ("er_tripreqbill".equals(formId)) {
                needSyncBills.forEach(bill -> {
                    try {
                        TripCommonUtil.reqPush((String)bill.getString("billno"), (String)bill.getString("id"), (String)server, (String)"1");
                    }
                    catch (Exception ex) {
                        this.logger.error("\u4e0d\u5bf9\u5916\u629b\u5f02\u5e38", (Throwable)ex);
                    }
                });
            } else if ("er_dailyvehiclebill".equals(formId)) {
                needSyncBills.forEach(bill -> {
                    try {
                        CommonServiceHelper.dailyVehicleBillPush((Long)bill.getLong("applier.id"), (String)bill.getString("billno"), (String)bill.getString("id"), (String)server, (String)"1");
                    }
                    catch (Exception ex) {
                        this.logger.error("\u4e0d\u5bf9\u5916\u629b\u5f02\u5e38", (Throwable)ex);
                    }
                });
            }
        }
        HashSet restBillNos = Sets.newHashSetWithExpectedSize((int)sameCompanyAndOrgs.size());
        sameCompanyAndOrgs.entrySet().removeIf(entry -> (Boolean)resultMap.get(entry.getKey()));
        if (!sameCompanyAndOrgs.isEmpty()) {
            for (Map.Entry<String, List<DynamicObject>> listEntry : sameCompanyAndOrgs.entrySet()) {
                restBillNos.addAll(listEntry.getValue().stream().map(obj -> obj.getString("billno")).collect(Collectors.toSet()));
            }
        }
        return restBillNos;
    }
}

