/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.log.LogUtils;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.task.datacheck.util.ErDataCheckUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.OperateUtils;
import kd.fi.er.validator.BillAmountCheckValidator;
import kd.fi.er.validator.amount.control.AmounRangeValidator;
import org.apache.commons.lang3.StringUtils;

public class ErBillAmountValidatePlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List preparePropertys = e.getFieldKeys();
        ErDataCheckUtil.addPreparePropertys((Collection)preparePropertys);
        preparePropertys.add("invoiceentry");
        preparePropertys.add("invoiceentry.invoiceischange");
        preparePropertys.add("isinvoicemodified");
        preparePropertys.add("returnedamount");
        preparePropertys.add("balanceamount");
        preparePropertys.add("appliedreimburseamount");
        preparePropertys.add("usedamount");
        preparePropertys.add("expusedamount");
        preparePropertys.add("expnonpayamount");
        preparePropertys.add("exporiusedamount");
        preparePropertys.add("expenseamount");
        preparePropertys.add("experepayamount");
        preparePropertys.add("expeorihasreimamount");
        preparePropertys.add("orgiexpebalanceamount");
        preparePropertys.add("expehasreimamount");
        preparePropertys.add("expeorirepayamount");
        preparePropertys.add("oriaccbalamount");
        preparePropertys.add("accbalamount");
        preparePropertys.add("buildedamount");
        preparePropertys.add("oriaccpayedamount");
        preparePropertys.add("oriaccnotpayamount");
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new AmounRangeValidator());
        e.addValidator((AbstractValidator)new BillAmountCheckValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String opKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        this.saveDataLogBatch(opKey, dataEntities, "op plugin in beforeExecuteOperationTransaction");
        for (DynamicObject bill : dataEntities) {
            PayeeServiceHelper.clearLimitInfo((DynamicObject)bill);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String entryId;
        String opKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        this.saveDataLogBatch(opKey, dataEntities, "op plugin in beginOperationTransaction");
        String string = entryId = dataEntities.length > 0 ? dataEntities[0].getDataEntityType().getName() : "";
        if (!(ErEntityTypeUtils.isTripReimburseBill((String)entryId) || ErEntityTypeUtils.isDailyReimburseBill((String)entryId) || ErEntityTypeUtils.isPublicReimburseBill((String)entryId))) {
            return;
        }
        if (!StringUtils.equalsAny((CharSequence)opKey, (CharSequence[])new CharSequence[]{"save", "saveapprove", "submit"})) {
            return;
        }
        for (DynamicObject bill : dataEntities) {
            boolean invoiceIsChange = bill.getDynamicObjectCollection("invoiceentry").stream().anyMatch(row -> StringUtils.equals((CharSequence)row.getString("invoiceischange"), (CharSequence)"2"));
            bill.set("isinvoicemodified", (Object)invoiceIsChange);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String opKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        this.saveDataLogBatch(opKey, dataEntities, "op plugin in endOperationTransaction");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String opKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        this.saveDataLogBatch(opKey, dataEntities, "op plugin in afterExecuteOperationTransaction");
    }

    private void saveDataLogBatch(String opKey, DynamicObject[] dataEntities, String opdesc) {
        LogUtils.insertDataLogBatch((DynamicObject[])dataEntities, (String)opKey, (String)opdesc, null);
    }
}

