/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.common.ErBillStatusEnum;

public class ErUnAuditOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("recentry.recbillno");
        e.getFieldKeys().add("recentry.payeedate");
        e.getFieldKeys().add("recentry.receivingtype");
        e.getFieldKeys().add("recentry.payeebank");
        e.getFieldKeys().add("recentry.accountbank");
        e.getFieldKeys().add("recentry.reccurrency");
        e.getFieldKeys().add("recentry.recexchangerate");
        e.getFieldKeys().add("recentry.oriactrecamt");
        e.getFieldKeys().add("recentry.actrecamt");
        e.getFieldKeys().add("recentry.recbillid");
        e.getFieldKeys().add("recentry.accountname");
        e.getFieldKeys().add("recentry.ismanualrelated");
        e.getFieldKeys().add("repaymententry.orirepayamount");
        e.getFieldKeys().add("repaymententry.repayamount");
        e.getFieldKeys().add("repaymententry.orirecamount");
        e.getFieldKeys().add("repaymententry.recamount");
        e.getFieldKeys().add("totalactrecamt");
        e.getFieldKeys().add("totalnotactrecamt");
        e.getFieldKeys().add("amount");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList ids = Lists.newArrayList();
        boolean ismanualrelated = false;
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection recentryCollectoin = dataEntity.getDynamicObjectCollection("recentry");
            if (recentryCollectoin == null || recentryCollectoin.isEmpty()) continue;
            ismanualrelated = ((DynamicObject)recentryCollectoin.get(0)).getBoolean("ismanualrelated");
            BigDecimal totalActrecamt = BigDecimal.ZERO;
            if (!ismanualrelated) continue;
            for (int i = 0; i < recentryCollectoin.size(); ++i) {
                BigDecimal actrecamt = ((DynamicObject)recentryCollectoin.get(i)).getBigDecimal("actrecamt");
                totalActrecamt = totalActrecamt.add(actrecamt);
                Long recbillid = ((DynamicObject)recentryCollectoin.get(i)).getLong("recbillid");
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)recbillid, (String)"cas_recbill");
                if (dynamicObject == null) continue;
                DynamicObjectCollection entrys = dynamicObject.getDynamicObjectCollection("entry");
                if (entrys != null && !entrys.isEmpty()) {
                    for (int j = 0; j < entrys.size(); ++j) {
                        ((DynamicObject)entrys.get(j)).set("e_sourcebillid", (Object)0);
                        ((DynamicObject)entrys.get(j)).set("e_corebillno", (Object)"");
                        ((DynamicObject)entrys.get(j)).set("e_corebilltype", (Object)"");
                        ((DynamicObject)entrys.get(j)).set("e_sourcebillentryid", (Object)0);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                if ("D".equals(dynamicObject.getString("billstatus"))) continue;
                Object[] res = new Object[]{recbillid};
                ids.add(res);
            }
            DynamicObjectCollection repaymententryCollectoin = dataEntity.getDynamicObjectCollection("repaymententry");
            if (repaymententryCollectoin != null && !repaymententryCollectoin.isEmpty()) {
                for (int i = 0; i < repaymententryCollectoin.size(); ++i) {
                    ((DynamicObject)repaymententryCollectoin.get(i)).set("orirecamount", (Object)BigDecimal.ZERO);
                    ((DynamicObject)repaymententryCollectoin.get(i)).set("recamount", (Object)BigDecimal.ZERO);
                }
            }
            dataEntity.set("totalactrecamt", (Object)BigDecimal.ZERO);
            BigDecimal totalnotactrecamt = dataEntity.getBigDecimal("amount");
            dataEntity.set("totalnotactrecamt", (Object)totalnotactrecamt);
            dataEntity.set("billstatus", (Object)ErBillStatusEnum.A.toString());
        }
        if (ismanualrelated && ids != null && !ids.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"er"), (String)"delete from t_er_repayrecentry where frecbillid = ?", (List)ids);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }
}

