/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.servicehelper.operation.ErOperationServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.ErBillStatusEnum;
import org.apache.commons.lang3.StringUtils;

public class InvokeCloseUpStreamBillOP
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(InvokeCloseUpStreamBillOP.class);

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String detailtype;
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length <= 0) {
            return;
        }
        String entityName = dataEntities[0].getDataEntityType().getName();
        if (ErEntityTypeUtils.isContractBill((String)entityName) && !"biztype_stopbill".equals(detailtype = dataEntities[0].getString("detailtype"))) {
            return;
        }
        ArrayList idList = new ArrayList();
        Arrays.asList(dataEntities).stream().forEach(entity -> idList.add(Long.valueOf(String.valueOf(entity.getPkValue()))));
        Map soruceBillIds = BFTrackerServiceHelper.findSourceBills((String)entityName, (Long[])idList.toArray(new Long[idList.size()]));
        logger.info("\u5ba1\u6838\u901a\u8fc7\u540e\u91ca\u653e\u9884\u7b97\u5f00\u59cb>>>>>>>>>>>>>>>>>soruceBillIds:" + soruceBillIds);
        for (Map.Entry entry : soruceBillIds.entrySet()) {
            String entryKey = (String)entry.getKey();
            if (StringUtils.equalsIgnoreCase((CharSequence)entryKey, (CharSequence)"pmbs_contractpayitem")) continue;
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", entry.getValue())};
            DynamicObject[] soruceBillArray = BusinessDataServiceHelper.load((String)entryKey, (String)"id,billno,billstatus", (QFilter[])qFilters);
            List<DynamicObject> sourceBillCloseList = Arrays.asList(soruceBillArray).stream().filter(sourceBill -> this.isCloseSourceBill((DynamicObject)sourceBill)).collect(Collectors.toList());
            if (sourceBillCloseList.size() <= 0) {
                logger.info("\u5355\u636e\u5b9e\u4f53\u7f16\u53f7\u4e3a->" + entry.getValue() + "id\u4e3a->" + SerializationUtils.toJsonString(Arrays.asList(soruceBillArray)) + "\u5355\u636e\u5b9e\u4f8b\u90fd\u4e0d\u7b26\u5408\u5173\u95ed\u7684\u6761\u4ef6\uff01");
                continue;
            }
            try {
                logger.info("\u5ba1\u6838\u901a\u8fc7\u540e\u91ca\u653e\u9884\u7b97>>>>>>>>>>>>>>>>>releasebudget>>>>\u8c03\u7528");
                OperationResult result = ErOperationServiceHelper.execOperate((String)"releasebudget", (String)entryKey, (DynamicObject[])sourceBillCloseList.toArray(new DynamicObject[sourceBillCloseList.size()]), (OperateOption)OperateOption.create());
                if (result.isSuccess()) continue;
                logger.info("\u5355\u636e\u540e\u53f0\u91ca\u653e\u9884\u7b97\u64cd\u4f5c->" + entryKey + SerializationUtils.toJsonString(sourceBillCloseList) + "\u5931\u8d25->" + JSONObject.toJSONString((Object)result.getAllErrorOrValidateInfo()));
            }
            catch (KDBizException e1) {
                logger.info("\u5355\u636e\u540e\u53f0\u91ca\u653e\u9884\u7b97\u64cd\u4f5c->" + entryKey + SerializationUtils.toJsonString(sourceBillCloseList) + "\u5f02\u5e38->" + e1.getStackTraceMessage());
            }
        }
    }

    private boolean isCloseSourceBill(DynamicObject sourceBill) {
        boolean isClose = sourceBill.getString("billstatus").equals(ErBillStatusEnum.I.toString());
        Long pkid = Long.valueOf(String.valueOf(sourceBill.getPkValue()));
        String srcEntityNum = sourceBill.getDataEntityType().getName();
        Map targetBillIds = BFTrackerServiceHelper.findTargetBills((String)srcEntityNum, (Long[])new Long[]{pkid});
        for (Map.Entry entry : targetBillIds.entrySet()) {
            String targetEntityNum = (String)entry.getKey();
            if (targetEntityNum == null || !targetEntityNum.startsWith("er")) continue;
            Set oneBillTargetIds = (Set)entry.getValue();
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", (Object)oneBillTargetIds)};
            DynamicObjectCollection collection = QueryServiceHelper.query((String)targetEntityNum, (String)"id,billstatus", (QFilter[])qFilters);
            if (isClose = isClose && this.isNotInStreamBAndC((DynamicObject[])collection.toArray((Object[])new DynamicObject[0]))) continue;
            return false;
        }
        return isClose;
    }

    private boolean isNotInStreamBAndC(DynamicObject[] targetBillArray) {
        for (DynamicObject targetBill : targetBillArray) {
            String billStatus = targetBill.getString("billstatus");
            if (!ErBillStatusEnum.B.toString().equals(billStatus) && !ErBillStatusEnum.C.toString().equals(billStatus)) continue;
            return false;
        }
        return true;
    }
}

