/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ManualRepayOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("billno");
        fieldKeys.add("billstatus");
        fieldKeys.add("totalnotactrecamt");
        fieldKeys.add("amount");
        fieldKeys.add("totalactrecamt");
        fieldKeys.add("totalnotactrecamt");
        fieldKeys.add("repaymententry");
        fieldKeys.add("repaymententry.orirepayamount");
        fieldKeys.add("repaymententry.orirecamount");
        fieldKeys.add("repaymententry.recamount");
        fieldKeys.add("repaymententry.repayamount");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new InnerValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        for (ExtendedDataEntity entity : e.getValidExtDataEntities()) {
            DynamicObject bill = entity.getDataEntity();
            QFilter q1 = new QFilter("billno", "=", (Object)bill.getString("billno"));
            QFilter q2 = new QFilter("formid", "=", (Object)bill.getDynamicObjectType().getName());
            DynamicObject[] records = BusinessDataServiceHelper.load((String)"er_manualrepay", (String)"statusbeforerepay", (QFilter[])new QFilter[]{q1, q2});
            DynamicObject record = null;
            if (records.length > 0) {
                record = records[0];
            } else {
                record = BusinessDataServiceHelper.newDynamicObject((String)"er_manualrepay");
                record.set("billno", bill.get("billno"));
                record.set("formid", (Object)bill.getDynamicObjectType().getName());
            }
            record.set("statusbeforerepay", bill.get("billstatus"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{record});
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        for (DynamicObject bill : e.getDataEntities()) {
            BigDecimal amount = bill.getBigDecimal("amount");
            bill.set("totalactrecamt", (Object)amount);
            bill.set("totalnotactrecamt", (Object)BigDecimal.ZERO);
            DynamicObjectCollection repaymentEntries = bill.getDynamicObjectCollection("repaymententry");
            for (DynamicObject repaymentEntry : repaymentEntries) {
                repaymentEntry.set("orirecamount", (Object)repaymentEntry.getBigDecimal("orirepayamount"));
                repaymentEntry.set("recamount", (Object)repaymentEntry.getBigDecimal("repayamount"));
            }
        }
    }

    static class InnerValidator
    extends AbstractValidator {
        InnerValidator() {
        }

        public void validate() {
            for (ExtendedDataEntity entity : this.getDataEntities()) {
                String billstatus;
                DynamicObject bill = entity.getDataEntity();
                BigDecimal totalnotactrecamt = bill.getBigDecimal("totalnotactrecamt");
                if (BigDecimal.ZERO.compareTo(totalnotactrecamt) >= 0) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5f85\u6536\u6b3e\u91d1\u989d\u5927\u4e8e0\u624d\u80fd\u624b\u52a8\u6536\u6b3e\u3002", (String)"ManualRepayOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
                if (!"G".equals(billstatus = bill.getString("billstatus"))) continue;
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u5df2\u6536\u6b3e\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u91cd\u590d\u624b\u52a8\u6536\u6b3e\u3002", (String)"ManualRepayOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

