/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web.reimctl;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlMode;
import kd.fi.er.business.reimamountctl.mode.QuotaCtrlModeFactory;
import kd.fi.er.business.reimamountctl.model.QuotaAmountBO;
import kd.fi.er.business.reimamountctl.utils.QuotaCtrlUtil;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class ErReimCtlUnAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(ErReimCtlUnAuditOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List keys = e.getFieldKeys();
        keys.add("amounttype");
        keys.add("company");
        keys.add("dept");
        keys.add("employee");
        keys.add("expenseitem");
        keys.add("employee");
        keys.add("currency");
        keys.add("dateyear");
        keys.add("auditStatus");
        keys.add("auditor");
        keys.add("modifier");
        keys.add("modifytime");
        keys.add("wbsrcbillid");
        keys.add("wbsrcbilltype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] extDataEntities = this.getDataEntities();
                LocalDate localDate = LocalDate.now();
                int currentYear = localDate.getYear();
                Set pks = Arrays.stream(extDataEntities).map(d -> d.getDataEntity().getPkValue()).collect(Collectors.toSet());
                QFilter wbsrcbilltypeFilter = new QFilter("wbsrcbilltype", "=", (Object)"er_reimctl_modify");
                Set existIds = QueryServiceHelper.query((String)"er_reimburseamount", (String)"wbsrcbillid", (QFilter[])new QFilter[]{new QFilter("wbsrcbillid", "in", pks), wbsrcbilltypeFilter}).stream().map(r -> r.getLong("wbsrcbillid")).collect(Collectors.toSet());
                Set companyIds = Arrays.stream(extDataEntities).map(d -> (Long)d.getDataEntity().getDynamicObject("company").getPkValue()).collect(Collectors.toSet());
                Set notCtlReimCompanys = SystemParamterUtil.getBoolParamResults((List)Lists.newArrayList(companyIds), (String)"isreimburselimitcontrol").entrySet().stream().filter(e -> (Boolean)e.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
                if (CollectionUtils.isNotEmpty(notCtlReimCompanys)) {
                    log.info("\u5f53\u524d{}\u7ec4\u7ec7\u6ca1\u6709\u542f\u7528\u989d\u5ea6\u63a7\u5236", notCtlReimCompanys);
                }
                ArrayList<String> deptCltList = new ArrayList<String>();
                deptCltList.add("1");
                deptCltList.add("2");
                deptCltList.add("3");
                for (ExtendedDataEntity extDataEntity : extDataEntities) {
                    DynamicObject obj = extDataEntity.getDataEntity();
                    String dateyear = obj.getString("dateyear");
                    int year = Integer.parseInt(dateyear);
                    if (year < currentYear - 1) {
                        this.addErrorMessage(extDataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u4eca\u5e74\u548c\u4e0a\u4e00\u5e74\u7684\u989d\u5ea6\u8bb0\u5f55\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ErReimCtlUnAuditOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (existIds.contains((Long)obj.getPkValue())) {
                        this.addErrorMessage(extDataEntity, ResManager.loadKDString((String)"\u4e0b\u6e38\u5b58\u5728\u8c03\u6574\u7684\u989d\u5ea6\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"ErReimCtlUnAuditOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    if (notCtlReimCompanys.contains(ErCommonUtils.getPk((Object)obj.getDynamicObject("company")))) continue;
                    QuotaAmountBO reimAmountBO = new QuotaAmountBO();
                    reimAmountBO.setCompanyId(ErCommonUtils.getPk((Object)obj.getDynamicObject("company")));
                    reimAmountBO.setDeptCtlBill(deptCltList);
                    reimAmountBO.setEmpCtlBill(deptCltList);
                    LocalDate startDate = LocalDate.of(year, 1, 1);
                    LocalDate endDate = LocalDate.of(year, 12, 31);
                    reimAmountBO.setHappenDatePeriod(new LocalDate[]{startDate, endDate});
                    QuotaCtrlUtil.genQuotaExpItem((QuotaAmountBO)reimAmountBO, (Long)ErCommonUtils.getPk((Object)obj.getDynamicObject("expenseitem")));
                    QuotaCtrlMode quotaCtrlMode = QuotaCtrlModeFactory.getQuotaCtrlMode((QuotaAmountBO)reimAmountBO);
                    if (quotaCtrlMode == null) {
                        this.addErrorMessage(extDataEntity, ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8be5\u989d\u5ea6\u5bf9\u5e94\u8d39\u7528\u9879\u76ee\u7684\u201c\u989d\u5ea6\u63a7\u5236\u201d\u9009\u9879\u662f\u5426\u5339\u914d\u989d\u5ea6\u63a7\u5236\u7c7b\u578b\u3002", (String)"ErReimCtlUnAuditOp_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    String amountType = obj.getString("amounttype");
                    if (StringUtils.equals((CharSequence)amountType, (CharSequence)"1")) {
                        reimAmountBO.setUserOrDeptId(ErCommonUtils.getPk((Object)obj.getDynamicObject("employee")));
                        String personCtlCurrency = SystemParamterUtil.getPersonCtlCurrency((Long)ErCommonUtils.getPk((Object)obj.getDynamicObject("company")));
                        QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)personCtlCurrency, (Long)ErCommonUtils.getPk((Object)obj.getDynamicObject("currency")), (Long)ErCommonUtils.getPk((Object)obj.getDynamicObject("currency")));
                    } else {
                        reimAmountBO.setUserOrDeptId(ErCommonUtils.getPk((Object)obj.getDynamicObject("dept")));
                        String deptCtrlCurrency = SystemParamterUtil.getDeptCtlCurrency((Long)ErCommonUtils.getPk((Object)obj.getDynamicObject("company")));
                        QuotaCtrlUtil.genQuotaCurrency((QuotaAmountBO)reimAmountBO, (String)deptCtrlCurrency, (Long)ErCommonUtils.getPk((Object)obj.getDynamicObject("currency")), (Long)ErCommonUtils.getPk((Object)obj.getDynamicObject("currency")));
                    }
                    BigDecimal usedResult = quotaCtrlMode.getReimedAmount(reimAmountBO);
                    if (usedResult.compareTo(BigDecimal.ZERO) <= 0) continue;
                    this.addErrorMessage(extDataEntity, ResManager.loadKDString((String)"\u8be5\u989d\u5ea6\u8bb0\u5f55\u5df2\u88ab\u5355\u636e\u4f7f\u7528\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"ErReimCtlUnAuditOp_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        RequestContext requestContext = RequestContext.get();
        for (DynamicObject dataEntity : dataEntities) {
            dataEntity.set("auditStatus", (Object)"0");
            dataEntity.set("auditor", (Object)requestContext.getUserId());
            dataEntity.set("modifier", (Object)requestContext.getUserId());
            dataEntity.set("modifytime", (Object)new Date());
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        this.wbSrcBill(e);
    }

    private void wbSrcBill(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Long> srcBillIds = new HashSet<Long>();
        for (DynamicObject bill : dataEntities) {
            Long srcId;
            String srcType = (String)bill.get("wbsrcbilltype");
            if (!"er_reimctl_modify".equals(srcType) || (srcId = (Long)bill.get("wbsrcbillid")) == null || srcId == 0L) continue;
            srcBillIds.add(srcId);
        }
        if (srcBillIds.size() > 0) {
            QFilter qf = new QFilter("id", "in", srcBillIds);
            DynamicObject[] bills = BusinessDataServiceHelper.load((String)this.billEntityType.getName(), (String)"id,auditStatus", (QFilter[])new QFilter[]{qf});
            for (int i = 0; i < bills.length; ++i) {
                DynamicObject applyBill = bills[i];
                applyBill.set("auditStatus", (Object)Character.valueOf('1'));
            }
            SaveServiceHelper.save((DynamicObject[])bills);
        }
    }
}

