/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web.reimctl.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;

public class ErApplyReimburseAmountUtil {
    private static final String monthPrefix = "month";
    private static final String quarterPrefix = "quarter";

    protected static int getMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(date);
        int month = cal.get(2) + 1;
        return month;
    }

    protected static int getYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.setTime(date);
        int year = cal.get(1);
        return year;
    }

    protected static void calculateMonthAmount(int monthAf, int monthDue, int yearAf, int yearDue, BigDecimal approveamount, DynamicObject bill) {
        String prefix = "";
        if ("reimctlentryentity".equalsIgnoreCase(bill.getDataEntityType().getName())) {
            prefix = "reimctl";
        }
        ArrayList<Integer> hasVals = new ArrayList<Integer>();
        int yearNum = yearDue - yearAf;
        int oldMonthDue = monthDue;
        for (int y = 0; y <= yearNum; ++y) {
            if (y != 0) {
                monthAf = 1;
                monthDue = oldMonthDue;
            }
            if (y != yearNum) {
                monthDue = 12;
            }
            for (int i = monthAf; i <= monthDue; ++i) {
                bill.set(prefix + monthPrefix + i, (Object)approveamount);
                hasVals.add(i);
            }
        }
        for (int m = 1; m <= 12; ++m) {
            if (hasVals.contains(m)) continue;
            bill.set(prefix + monthPrefix + m, (Object)BigDecimal.ZERO);
        }
    }

    protected static void calculateQuarterAmount(int monthAf, int monthDue, int yearAf, int yearDue, BigDecimal approveamount, DynamicObject bill) {
        String prefix = "";
        if ("reimctlentryentity".equalsIgnoreCase(bill.getDataEntityType().getName())) {
            prefix = "reimctl";
        }
        ArrayList<Integer> hasVals = new ArrayList<Integer>();
        int s = 1;
        Boolean isContainsQuarter = false;
        int yearNum = yearDue - yearAf;
        int oldMonthDue = monthDue;
        for (int y = 0; y <= yearNum; ++y) {
            if (y != 0) {
                monthAf = 1;
                monthDue = oldMonthDue;
            }
            if (y != yearNum) {
                monthDue = 12;
            }
            for (int q = 1; q <= 4; ++q) {
                isContainsQuarter = false;
                for (int i = s; i <= q * 3; ++i) {
                    if (i >= monthAf && i <= monthDue) {
                        isContainsQuarter = true;
                    }
                    ++s;
                }
                if (!isContainsQuarter.booleanValue()) continue;
                bill.set(prefix + quarterPrefix + q, (Object)approveamount);
                hasVals.add(q);
            }
        }
        for (int m = 1; m <= 4; ++m) {
            if (hasVals.contains(m)) continue;
            bill.set(prefix + quarterPrefix + m, (Object)BigDecimal.ZERO);
        }
    }

    protected static void calculateTotalAmount(BigDecimal approveamount, DynamicObject bill) {
        String prefix = "";
        if ("reimctlentryentity".equalsIgnoreCase(bill.getDataEntityType().getName())) {
            prefix = "reimctl";
        }
        bill.set(prefix + "totalamount", (Object)approveamount);
    }

    protected static void sumMonthAmount(DynamicObject bill) {
        String prefix = "";
        if ("reimctlentryentity".equalsIgnoreCase(bill.getDataEntityType().getName())) {
            prefix = "reimctl";
        }
        BigDecimal sumAmt = BigDecimal.ZERO;
        for (int i = 1; i <= 12; ++i) {
            BigDecimal monthAmt = (BigDecimal)bill.get(prefix + monthPrefix + i);
            sumAmt = sumAmt.add(monthAmt);
        }
        bill.set(prefix + "totalamount", (Object)sumAmt);
    }

    protected static void sumQuarterAmount(DynamicObject bill) {
        String prefix = "";
        if ("reimctlentryentity".equalsIgnoreCase(bill.getDataEntityType().getName())) {
            prefix = "reimctl";
        }
        BigDecimal sumAmt = BigDecimal.ZERO;
        for (int i = 1; i <= 4; ++i) {
            BigDecimal quarterAmt = (BigDecimal)bill.get(prefix + quarterPrefix + i);
            sumAmt = sumAmt.add(quarterAmt);
        }
        bill.set(prefix + "totalamount", (Object)sumAmt);
    }
}

