/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web.reimctl.apply;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.OperateUtils;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import kd.fi.er.opplugin.web.reimctl.apply.ErApplyReimburseAmountUtil;

public class ErTransformPersonReimNewOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ErTransformPersonReimNewOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        OperateUtils.addAllFields((PreparePropertysEventArgs)e, (MainEntityType)this.billEntityType, (Map)this.operateMeta);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] billEntities;
                for (ExtendedDataEntity billEntity : billEntities = this.getDataEntities()) {
                    DynamicObject bill = billEntity.getDataEntity();
                    String errormsg = ErTransformPersonReimNewOp.this.handleReimctlEntry(bill);
                    if (!StringUtils.isBlank((CharSequence)errormsg)) {
                        this.addErrorMessage(billEntity, errormsg);
                        return;
                    }
                    DynamicObjectCollection reimctlentryentity = bill.getDynamicObjectCollection("reimctlentryentity");
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    for (int i = 0; i < reimctlentryentity.size(); ++i) {
                        DynamicObjectCollection dB_ReimctlApp_id2;
                        String msg;
                        DynamicObject dB_PersonReimDym_id;
                        QFilter qf2;
                        QFilter qf;
                        String msg2;
                        String key;
                        BigDecimal amount;
                        DynamicObject reimctlEntry = (DynamicObject)reimctlentryentity.get(i);
                        DynamicObject reimctlemployee = (DynamicObject)reimctlEntry.get("reimctlemployee");
                        DynamicObject reimctlcompany = (DynamicObject)reimctlEntry.get("reimctlcompany");
                        DynamicObject reimctlexpenseitem = (DynamicObject)reimctlEntry.get("reimctlexpenseitem");
                        String reimburseamountctlmethod = "";
                        if (reimctlexpenseitem != null) {
                            reimburseamountctlmethod = reimctlexpenseitem.getString("reimburseamountctlmethod");
                        }
                        DynamicObject reimctlcurrency = (DynamicObject)reimctlEntry.get("reimctlcurrency");
                        String reimctldatayear = (String)reimctlEntry.get("reimctldatayear");
                        if (reimctlemployee == null || reimctlcompany == null || reimctlexpenseitem == null || reimctlcurrency == null) continue;
                        if (StringUtils.equals((CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Yearly.getValue(), (CharSequence)reimburseamountctlmethod)) {
                            String msg3;
                            String newKey = reimctlemployee.getPkValue().toString() + reimctlcompany.getPkValue() + reimctlexpenseitem.getPkValue() + reimctlcurrency.getPkValue() + reimctldatayear;
                            QFilter qf3 = new QFilter("employee", "=", reimctlemployee.getPkValue());
                            qf3.and(new QFilter("company", "=", reimctlcompany.getPkValue()));
                            qf3.and(new QFilter("expenseitem", "=", reimctlexpenseitem.getPkValue()));
                            qf3.and(new QFilter("currency", "=", reimctlcurrency.getPkValue()));
                            qf3.and(new QFilter("auditstatus", "=", (Object)Character.valueOf('1')));
                            qf3.and(new QFilter("dateyear", "=", (Object)reimctldatayear));
                            QFilter qf22 = new QFilter("reimctlentryentity.reimctlemployee", "=", reimctlemployee.getPkValue());
                            qf22.and(new QFilter("reimctlentryentity.reimctlcompany", "=", reimctlcompany.getPkValue()));
                            qf22.and(new QFilter("reimctlentryentity.reimctlexpenseitem", "=", reimctlexpenseitem.getPkValue()));
                            qf22.and(new QFilter("reimctlentryentity.reimctlcurrency", "=", reimctlcurrency.getPkValue()));
                            qf22.and(new QFilter("reimctlentryentity.reimctldatayear", "=", (Object)reimctldatayear));
                            qf22.and(new QFilter("id", "<>", bill.get("id")));
                            DynamicObject dB_PersonReimDym_id2 = QueryServiceHelper.queryOne((String)"er_reimburseamount", (String)"id", (QFilter[])qf3.toArray());
                            if (dB_PersonReimDym_id2 != null) {
                                msg3 = String.format(ResManager.loadKDString((String)"%1$s\u5e74\uff0c\u516c\u53f8\u4e3a%2$s\uff0c\u804c\u5458\u4e3a%3$s\uff0c\u8d39\u7528\u9879\u76ee\u4e3a%4$s\uff0c\u5e01\u79cd\u4e3a%5$s\u7684\u62a5\u9500\u989d\u5ea6\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff0c\u82e5\u8981\u8c03\u6574\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u4e2a\u4eba\u989d\u5ea6\u8868\u4e2d\u505a\u989d\u5ea6\u8c03\u6574\u3002", (String)"ErTransformPersonReimNewOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]), reimctldatayear, reimctlcompany.get("name"), reimctlemployee.get("name"), reimctlexpenseitem.get("name"), reimctlcurrency.get("name"));
                                this.addErrorMessage(billEntity, msg3);
                                return;
                            }
                            if (map.containsKey(newKey)) {
                                msg3 = String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u6709\u6548\u671f\u95f4\u5305\u542b\u76f8\u540c\u5e74\u5ea6\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ErTransformPersonReimNewOp_5", (String)"fi-er-opplugin", (Object[])new Object[0]), String.valueOf((Integer)map.get(newKey) + 1), String.valueOf(i + 1));
                                this.addErrorMessage(billEntity, msg3);
                                return;
                            }
                            map.put(newKey, i);
                            DynamicObjectCollection dB_ReimctlApp_id22 = QueryServiceHelper.query((String)"er_reimctlapplybill", (String)"id", (QFilter[])qf22.toArray());
                            if (dB_ReimctlApp_id22 == null || dB_ReimctlApp_id22.size() <= 0) continue;
                            String msg4 = String.format(ResManager.loadKDString((String)"%1$s\u5e74\uff0c\u516c\u53f8\u4e3a%2$s\uff0c\u804c\u5458\u4e3a%3$s\uff0c\u8d39\u7528\u9879\u76ee\u4e3a%4$s\uff0c\u5e01\u79cd\u4e3a%5$s\u7684\u62a5\u9500\u989d\u5ea6\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff0c\u82e5\u8981\u8c03\u6574\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u4e2a\u4eba\u989d\u5ea6\u8868\u4e2d\u505a\u989d\u5ea6\u8c03\u6574\u3002", (String)"ErTransformPersonReimNewOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]), reimctldatayear, reimctlcompany.get("name"), reimctlemployee.get("name"), reimctlexpenseitem.get("name"), reimctlcurrency.get("name"));
                            this.addErrorMessage(billEntity, msg4);
                            return;
                        }
                        if (StringUtils.equals((CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue(), (CharSequence)reimburseamountctlmethod) || StringUtils.equals((CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue(), (CharSequence)reimburseamountctlmethod)) {
                            for (int j = 1; j <= 12; ++j) {
                                amount = reimctlEntry.getBigDecimal("reimctlmonth" + j);
                                if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
                                key = reimctlemployee.getPkValue().toString() + reimctlcompany.getPkValue() + reimctlexpenseitem.getPkValue() + reimctlcurrency.getPkValue() + reimctldatayear + "reimctlmonth" + j;
                                if (map.containsKey(key)) {
                                    msg2 = String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u5305\u542b\u76f8\u540c\u6709\u6548\u671f\u95f4\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ErTransformPersonReimNewOp_8", (String)"fi-er-opplugin", (Object[])new Object[0]), String.valueOf((Integer)map.get(key) + 1), String.valueOf(i + 1));
                                    this.addErrorMessage(billEntity, msg2);
                                    return;
                                }
                                map.put(key, i);
                                qf = new QFilter("employee", "=", reimctlemployee.getPkValue());
                                qf.and(new QFilter("company", "=", reimctlcompany.getPkValue()));
                                qf.and(new QFilter("expenseitem", "=", reimctlexpenseitem.getPkValue()));
                                qf.and(new QFilter("currency", "=", reimctlcurrency.getPkValue()));
                                qf.and(new QFilter("auditstatus", "=", (Object)Character.valueOf('1')));
                                qf.and(new QFilter("dateyear", "=", (Object)reimctldatayear));
                                qf.and(new QFilter("month" + j, "!=", (Object)BigDecimal.ZERO));
                                qf2 = new QFilter("reimctlentryentity.reimctlemployee", "=", reimctlemployee.getPkValue());
                                qf2.and(new QFilter("reimctlentryentity.reimctlcompany", "=", reimctlcompany.getPkValue()));
                                qf2.and(new QFilter("reimctlentryentity.reimctlexpenseitem", "=", reimctlexpenseitem.getPkValue()));
                                qf2.and(new QFilter("reimctlentryentity.reimctlcurrency", "=", reimctlcurrency.getPkValue()));
                                qf2.and(new QFilter("reimctlentryentity.reimctldatayear", "=", (Object)reimctldatayear));
                                qf2.and(new QFilter("id", "<>", bill.get("id")));
                                qf2.and(new QFilter("reimctlentryentity.reimctlmonth" + j, "!=", (Object)BigDecimal.ZERO));
                                dB_PersonReimDym_id = QueryServiceHelper.queryOne((String)"er_reimburseamount", (String)"id", (QFilter[])qf.toArray());
                                if (dB_PersonReimDym_id != null) {
                                    msg = String.format(ResManager.loadKDString((String)"%1$s\u5e74\u7b2c%6$s\u6708\uff0c\u516c\u53f8\u4e3a%2$s\uff0c\u804c\u5458\u4e3a%3$s\uff0c\u8d39\u7528\u9879\u76ee\u4e3a%4$s\uff0c\u5e01\u79cd\u4e3a%5$s\u7684\u62a5\u9500\u989d\u5ea6\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff0c\u82e5\u8981\u8c03\u6574\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u4e2a\u4eba\u989d\u5ea6\u8868\u4e2d\u505a\u989d\u5ea6\u8c03\u6574\u3002", (String)"ErTransformPersonReimNewOp_6", (String)"fi-er-opplugin", (Object[])new Object[0]), reimctldatayear, reimctlcompany.get("name"), reimctlemployee.get("name"), reimctlexpenseitem.get("name"), reimctlcurrency.get("name"), j);
                                    this.addErrorMessage(billEntity, msg);
                                    return;
                                }
                                dB_ReimctlApp_id2 = QueryServiceHelper.query((String)"er_reimctlapplybill", (String)"id", (QFilter[])qf2.toArray());
                                if (dB_ReimctlApp_id2 == null || dB_ReimctlApp_id2.size() <= 0) continue;
                                String msg5 = String.format(ResManager.loadKDString((String)"%1$s\u5e74\u7b2c%6$s\u6708\uff0c\u516c\u53f8\u4e3a%2$s\uff0c\u804c\u5458\u4e3a%3$s\uff0c\u8d39\u7528\u9879\u76ee\u4e3a%4$s\uff0c\u5e01\u79cd\u4e3a%5$s\u7684\u62a5\u9500\u989d\u5ea6\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff0c\u82e5\u8981\u8c03\u6574\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u4e2a\u4eba\u989d\u5ea6\u8868\u4e2d\u505a\u989d\u5ea6\u8c03\u6574\u3002", (String)"ErTransformPersonReimNewOp_6", (String)"fi-er-opplugin", (Object[])new Object[0]), reimctldatayear, reimctlcompany.get("name"), reimctlemployee.get("name"), reimctlexpenseitem.get("name"), reimctlcurrency.get("name"), j);
                                this.addErrorMessage(billEntity, msg5);
                                return;
                            }
                            continue;
                        }
                        if (!StringUtils.equals((CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Quarterly.getValue(), (CharSequence)reimburseamountctlmethod)) continue;
                        for (int j = 1; j <= 4; ++j) {
                            amount = reimctlEntry.getBigDecimal("reimctlquarter" + j);
                            if (amount.compareTo(BigDecimal.ZERO) == 0) continue;
                            key = reimctlemployee.getPkValue().toString() + reimctlcompany.getPkValue() + reimctlexpenseitem.getPkValue() + reimctlcurrency.getPkValue() + reimctldatayear + "reimctlquarter" + j;
                            if (map.containsKey(key)) {
                                msg2 = String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u7b2c%1$s\u884c\u4e0e\u7b2c%2$s\u884c\u5305\u542b\u76f8\u540c\u6709\u6548\u671f\u95f4\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"ErTransformPersonReimNewOp_8", (String)"fi-er-opplugin", (Object[])new Object[0]), String.valueOf((Integer)map.get(key) + 1), String.valueOf(i + 1));
                                this.addErrorMessage(billEntity, msg2);
                                return;
                            }
                            map.put(key, i);
                            qf = new QFilter("employee", "=", reimctlemployee.getPkValue());
                            qf.and(new QFilter("company", "=", reimctlcompany.getPkValue()));
                            qf.and(new QFilter("expenseitem", "=", reimctlexpenseitem.getPkValue()));
                            qf.and(new QFilter("currency", "=", reimctlcurrency.getPkValue()));
                            qf.and(new QFilter("auditstatus", "=", (Object)Character.valueOf('1')));
                            qf.and(new QFilter("dateyear", "=", (Object)reimctldatayear));
                            qf.and(new QFilter("quarter" + j, "!=", (Object)BigDecimal.ZERO));
                            qf2 = new QFilter("reimctlentryentity.reimctlemployee", "=", reimctlemployee.getPkValue());
                            qf2.and(new QFilter("reimctlentryentity.reimctlcompany", "=", reimctlcompany.getPkValue()));
                            qf2.and(new QFilter("reimctlentryentity.reimctlexpenseitem", "=", reimctlexpenseitem.getPkValue()));
                            qf2.and(new QFilter("reimctlentryentity.reimctlcurrency", "=", reimctlcurrency.getPkValue()));
                            qf2.and(new QFilter("reimctlentryentity.reimctldatayear", "=", (Object)reimctldatayear));
                            qf2.and(new QFilter("id", "<>", bill.get("id")));
                            qf2.and(new QFilter("reimctlentryentity.reimctlquarter" + j, "!=", (Object)BigDecimal.ZERO));
                            dB_PersonReimDym_id = QueryServiceHelper.queryOne((String)"er_reimburseamount", (String)"id", (QFilter[])qf.toArray());
                            if (dB_PersonReimDym_id != null) {
                                msg = String.format(ResManager.loadKDString((String)"%1$s\u5e74\u7b2c%6$s\u5b63\u5ea6\uff0c\u516c\u53f8\u4e3a%2$s\uff0c\u804c\u5458\u4e3a%3$s\uff0c\u8d39\u7528\u9879\u76ee\u4e3a%4$s\uff0c\u5e01\u79cd\u4e3a%5$s\u7684\u62a5\u9500\u989d\u5ea6\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff0c\u82e5\u8981\u8c03\u6574\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u4e2a\u4eba\u989d\u5ea6\u8868\u4e2d\u505a\u989d\u5ea6\u8c03\u6574\u3002", (String)"ErTransformPersonReimNewOp_7", (String)"fi-er-opplugin", (Object[])new Object[0]), reimctldatayear, reimctlcompany.get("name"), reimctlemployee.get("name"), reimctlexpenseitem.get("name"), reimctlcurrency.get("name"), j);
                                this.addErrorMessage(billEntity, msg);
                                return;
                            }
                            dB_ReimctlApp_id2 = QueryServiceHelper.query((String)"er_reimctlapplybill", (String)"id", (QFilter[])qf2.toArray());
                            if (dB_ReimctlApp_id2 == null || dB_ReimctlApp_id2.size() <= 0) continue;
                            String msg6 = String.format(ResManager.loadKDString((String)"%1$s\u5e74\u7b2c%6$s\u5b63\u5ea6\uff0c\u516c\u53f8\u4e3a%2$s\uff0c\u804c\u5458\u4e3a%3$s\uff0c\u8d39\u7528\u9879\u76ee\u4e3a%4$s\uff0c\u5e01\u79cd\u4e3a%5$s\u7684\u62a5\u9500\u989d\u5ea6\u6570\u636e\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u65b0\u589e\uff0c\u82e5\u8981\u8c03\u6574\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5728\u4e2a\u4eba\u989d\u5ea6\u8868\u4e2d\u505a\u989d\u5ea6\u8c03\u6574\u3002", (String)"ErTransformPersonReimNewOp_7", (String)"fi-er-opplugin", (Object[])new Object[0]), reimctldatayear, reimctlcompany.get("name"), reimctlemployee.get("name"), reimctlexpenseitem.get("name"), reimctlcurrency.get("name"), j);
                            this.addErrorMessage(billEntity, msg6);
                            return;
                        }
                    }
                }
            }
        });
    }

    protected String handleReimctlEntry(DynamicObject bill) {
        logger.info("\u989d\u5ea6\u660e\u7ec6\u5206\u5f55\u8d4b\u503c\uff0c\u5f00\u59cb");
        DynamicObjectCollection expenseentryentity = bill.getDynamicObjectCollection("expenseentryentity");
        DynamicObjectCollection reimctlentryentity = bill.getDynamicObjectCollection("reimctlentryentity");
        reimctlentryentity.clear();
        HashMap<String, Integer> dataMap = new HashMap<String, Integer>();
        for (int i = 0; i < expenseentryentity.size(); ++i) {
            DynamicObject applyEntry = (DynamicObject)expenseentryentity.get(i);
            DynamicObject entrycompany = (DynamicObject)applyEntry.get("entrycompany");
            DynamicObject entryemployee = (DynamicObject)applyEntry.get("entryemployee");
            DynamicObject entrycostcompany = (DynamicObject)applyEntry.get("entrycostcompany");
            DynamicObject expenseitem = (DynamicObject)applyEntry.get("expenseitem");
            DynamicObject entrycurrency = (DynamicObject)applyEntry.get("entrycurrency");
            BigDecimal expenseamount = (BigDecimal)applyEntry.get("expenseamount");
            String controlmethod = null;
            if (expenseitem != null) {
                controlmethod = (String)expenseitem.get("reimburseamountctlmethod");
            }
            if (null != entrycostcompany && "0".equals(entrycostcompany.getString("enable"))) {
                String msg = String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u660e\u7ec6\u7b2c%d\u884c\u7684\u201c\u6838\u7b97\u7ec4\u7ec7\u201d\u5df2\u7ecf\u7981\u7528\u3002", (String)"ErTransformPersonReimNewOp_9", (String)"fi-er-opplugin", (Object[])new Object[0]), i + 1);
                return msg;
            }
            Date entryeffectivedate = (Date)applyEntry.get("entryeffectivedate");
            Date entryduedate = (Date)applyEntry.get("entryduedate");
            if (entryeffectivedate == null || entryduedate == null) {
                String msg = String.format(ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u6709\u6548\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ErTransformPersonReimNewOp_3", (String)"fi-er-opplugin", (Object[])new Object[0]), i);
                return msg;
            }
            int yearAf = ErApplyReimburseAmountUtil.getYear(entryeffectivedate);
            int yearDue = ErApplyReimburseAmountUtil.getYear(entryduedate);
            int yearNum = yearDue - yearAf;
            for (int y = 0; y <= yearNum; ++y) {
                int currYear = yearAf + y;
                DynamicObject newReimctlEntry = reimctlentryentity.addNew();
                int monthAf = ErApplyReimburseAmountUtil.getMonth(entryeffectivedate);
                int monthDue = ErApplyReimburseAmountUtil.getMonth(entryduedate);
                if (y != 0) {
                    monthAf = 1;
                }
                if (y != yearNum) {
                    monthDue = 12;
                }
                newReimctlEntry.set("reimctlcompany", (Object)entrycompany);
                newReimctlEntry.set("reimctlemployee", (Object)entryemployee);
                newReimctlEntry.set("reimctlcostcompany", (Object)entrycostcompany);
                newReimctlEntry.set("reimctlexpenseitem", (Object)expenseitem);
                newReimctlEntry.set("reimctlcurrency", (Object)entrycurrency);
                newReimctlEntry.set("reimctldatayear", (Object)currYear);
                newReimctlEntry.set("reimctlremark", applyEntry.get("entryremark"));
                if (entrycompany != null && entryemployee != null && expenseitem != null && entrycurrency != null) {
                    dataMap.put(entrycompany.getPkValue().toString() + entryemployee.getPkValue().toString() + expenseitem.getPkValue().toString() + entrycurrency.getPkValue().toString() + currYear, i + 1);
                }
                if (controlmethod == null) continue;
                if (controlmethod.equalsIgnoreCase(ErExpenseItemConstant.ReimburseAmountCtlMethod.Yearly.getValue())) {
                    ErApplyReimburseAmountUtil.calculateTotalAmount(expenseamount, newReimctlEntry);
                }
                if (controlmethod.equalsIgnoreCase(ErExpenseItemConstant.ReimburseAmountCtlMethod.Quarterly.getValue())) {
                    ErApplyReimburseAmountUtil.calculateQuarterAmount(monthAf, monthDue, currYear, currYear, expenseamount, newReimctlEntry);
                    ErApplyReimburseAmountUtil.sumQuarterAmount(newReimctlEntry);
                }
                if (!controlmethod.equalsIgnoreCase(ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue()) && !controlmethod.equalsIgnoreCase(ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue())) continue;
                ErApplyReimburseAmountUtil.calculateMonthAmount(monthAf, monthDue, currYear, currYear, expenseamount, newReimctlEntry);
                ErApplyReimburseAmountUtil.sumMonthAmount(newReimctlEntry);
            }
        }
        return null;
    }
}

