/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web.reimctl.apply;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import kd.fi.er.opplugin.web.reimctl.apply.ErApplyReimburseAmountUtil;

@Deprecated
public class ErTransformPersonReimOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ErTransformPersonReimOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("applier");
        fieldKeys.add("company");
        fieldKeys.add("currency");
        fieldKeys.add("org");
        fieldKeys.add("billstatus");
        fieldKeys.add("headexpenseitem");
        fieldKeys.add("headexpenseitem.reimburseamountctlmethod");
        fieldKeys.add("approveamount");
        fieldKeys.add("effectivedate");
        fieldKeys.add("duedate");
        fieldKeys.add("reimbursecontrolcomany");
        fieldKeys.add("wbsrcbilltype");
        fieldKeys.add("wbsrcbillid");
        fieldKeys.add("employee");
        fieldKeys.add("expenseitem");
        fieldKeys.add("dept");
        fieldKeys.add("dateyear");
        fieldKeys.add("auditstatus");
        fieldKeys.add("totalamount");
        fieldKeys.add("auditdate");
        fieldKeys.add("auditor");
        fieldKeys.add("month1");
        fieldKeys.add("month2");
        fieldKeys.add("month3");
        fieldKeys.add("month4");
        fieldKeys.add("month5");
        fieldKeys.add("month6");
        fieldKeys.add("month7");
        fieldKeys.add("month8");
        fieldKeys.add("month9");
        fieldKeys.add("month10");
        fieldKeys.add("month11");
        fieldKeys.add("month12");
        fieldKeys.add("quarter1");
        fieldKeys.add("quarter2");
        fieldKeys.add("quarter3");
        fieldKeys.add("quarter4");
        fieldKeys.add("amountchangeflag");
        fieldKeys.add("quarterchangeflag");
        fieldKeys.add("amounttype");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        for (DynamicObject bill : e.getDataEntities()) {
            logger.info("\u989d\u5ea6\u7533\u8bf7\u5355,\u751f\u6210\u4e2a\u4eba\u989d\u5ea6\u8868,\u5f00\u59cb");
            DynamicObject applier = (DynamicObject)bill.get("employee");
            DynamicObject company = (DynamicObject)bill.get("reimbursecontrolcomany");
            DynamicObject headexpenseitem = (DynamicObject)bill.get("headexpenseitem");
            DynamicObject currency = (DynamicObject)bill.get("currency");
            Date effectiveDate = (Date)bill.get("effectivedate");
            Date dueDate = (Date)bill.get("duedate");
            int yearAf = ErApplyReimburseAmountUtil.getYear(effectiveDate);
            int yearDue = ErApplyReimburseAmountUtil.getYear(dueDate);
            int yearNum = yearDue - yearAf;
            ArrayList personReimBillCollection = Lists.newArrayListWithExpectedSize((int)(yearNum + 1));
            ArrayList personReimBillCollectionAddNew = Lists.newArrayListWithExpectedSize((int)(yearNum + 1));
            for (int y = 0; y <= yearNum; ++y) {
                int currYear = yearAf + y;
                QFilter qf = new QFilter("employee", "=", applier.getPkValue());
                qf.and(new QFilter("company", "=", company.getPkValue()));
                qf.and(new QFilter("expenseitem", "=", headexpenseitem.getPkValue()));
                qf.and(new QFilter("currency", "=", currency.getPkValue()));
                qf.and(new QFilter("dateyear", "=", (Object)String.valueOf(currYear)));
                DynamicObject dB_PersonReimDym_id = QueryServiceHelper.queryOne((String)"er_reimburseamount", (String)"id", (QFilter[])qf.toArray());
                if (dB_PersonReimDym_id != null) {
                    DynamicObject dB_PersonReimDym = BusinessDataServiceHelper.loadSingle((Object)dB_PersonReimDym_id.getLong("id"), (String)"er_reimburseamount");
                    this.setPersonReimBillValue(bill, dB_PersonReimDym, y, yearNum, currYear);
                    personReimBillCollection.add(dB_PersonReimDym);
                    continue;
                }
                DynamicObject personReimBill = BusinessDataServiceHelper.newDynamicObject((String)"er_reimburseamount");
                this.setPersonReimBillValue(bill, personReimBill, y, yearNum, currYear);
                personReimBillCollectionAddNew.add(personReimBill);
            }
            if (personReimBillCollection != null && personReimBillCollection.size() > 0) {
                logger.info("\u989d\u5ea6\u7533\u8bf7\u5355,\u751f\u6210\u4e2a\u4eba\u989d\u5ea6\u8868,\u66f4\u65b0\u7684\u6570\u636e:" + SerializationUtils.toJsonString((Object)personReimBillCollection));
                SaveServiceHelper.save((DynamicObject[])personReimBillCollection.toArray(new DynamicObject[personReimBillCollection.size()]));
            }
            if (personReimBillCollectionAddNew != null && personReimBillCollectionAddNew.size() > 0) {
                logger.info("\u989d\u5ea6\u7533\u8bf7\u5355,\u751f\u6210\u4e2a\u4eba\u989d\u5ea6\u8868,\u8ffd\u52a0\u7684\u6570\u636e:" + SerializationUtils.toJsonString((Object)personReimBillCollectionAddNew));
                SaveServiceHelper.save((DynamicObject[])personReimBillCollectionAddNew.toArray(new DynamicObject[personReimBillCollectionAddNew.size()]));
            }
            logger.info("\u989d\u5ea6\u7533\u8bf7\u5355,\u751f\u6210\u4e2a\u4eba\u989d\u5ea6\u8868,\u7ed3\u675f");
            bill.set("billstatus", (Object)Character.valueOf('I'));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        }
    }

    private void setPersonReimBillValue(DynamicObject bill, DynamicObject personReimBill, int y, int yearNum, int currYear) {
        DynamicObject applier = (DynamicObject)bill.get("employee");
        DynamicObject headexpenseitem = (DynamicObject)bill.get("headexpenseitem");
        DynamicObject org = (DynamicObject)bill.get("org");
        Date effectiveDate = (Date)bill.get("effectivedate");
        Date dueDate = (Date)bill.get("duedate");
        BigDecimal approveamount = (BigDecimal)bill.get("approveamount");
        String controlmethod = (String)headexpenseitem.get("reimburseamountctlmethod");
        DynamicObject company = (DynamicObject)bill.get("reimbursecontrolcomany");
        int monthAf = ErApplyReimburseAmountUtil.getMonth(effectiveDate);
        int monthDue = ErApplyReimburseAmountUtil.getMonth(dueDate);
        if (y != 0) {
            monthAf = 1;
        }
        if (y != yearNum) {
            monthDue = 12;
        }
        DataEntityPropertyCollection applyCtlProps = bill.getDynamicObjectType().getProperties();
        DataEntityPropertyCollection personReimProps = personReimBill.getDynamicObjectType().getProperties();
        applyCtlProps.forEach(applyCtlProp -> {
            String applyCtlPropName = applyCtlProp.getName();
            personReimProps.forEach(personReimProp -> {
                String personReimPropName = personReimProp.getName();
                if (!(!personReimPropName.equalsIgnoreCase(applyCtlPropName) || applyCtlPropName.equalsIgnoreCase("id") || applyCtlPropName.startsWith("month") || applyCtlPropName.startsWith("quarter") || applyCtlPropName.equalsIgnoreCase("totalamount") || applyCtlPropName.contains("id") || personReimPropName.contains("id") || personReimPropName.equalsIgnoreCase("id"))) {
                    personReimBill.set(personReimPropName, bill.get(applyCtlPropName));
                }
            });
        });
        if (controlmethod.equalsIgnoreCase(ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue()) || controlmethod.equalsIgnoreCase(ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue())) {
            ErApplyReimburseAmountUtil.calculateMonthAmount(monthAf, monthDue, currYear, currYear, approveamount, personReimBill);
            ErApplyReimburseAmountUtil.sumMonthAmount(personReimBill);
        }
        if (controlmethod.equalsIgnoreCase(ErExpenseItemConstant.ReimburseAmountCtlMethod.Quarterly.getValue())) {
            ErApplyReimburseAmountUtil.calculateQuarterAmount(monthAf, monthDue, currYear, currYear, approveamount, personReimBill);
            ErApplyReimburseAmountUtil.sumQuarterAmount(personReimBill);
        }
        if (controlmethod.equalsIgnoreCase(ErExpenseItemConstant.ReimburseAmountCtlMethod.Yearly.getValue())) {
            ErApplyReimburseAmountUtil.calculateTotalAmount(approveamount, personReimBill);
        }
        personReimBill.set("company", (Object)company);
        personReimBill.set("dateyear", (Object)String.valueOf(currYear));
        personReimBill.set("employee", (Object)applier);
        personReimBill.set("dept", (Object)org);
        personReimBill.set("expenseitem", (Object)headexpenseitem);
        personReimBill.set("amountchangeflag", (Object)false);
        personReimBill.set("quarterchangeflag", (Object)false);
        personReimBill.set("wbsrcbilltype", (Object)"er_reimctlapplybill");
        personReimBill.set("wbsrcbillid", bill.getPkValue());
        personReimBill.set("auditstatus", (Object)Character.valueOf('1'));
    }
}

