/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.opplugin.web.reimctl.importdata;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.KDBizException;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.common.constant.ErExpenseItemConstant;
import org.apache.commons.lang3.StringUtils;

public class PersonReimCtlImportDataOp
extends BatchImportPlugin {
    private static final Log logger = LogFactory.getLog(PersonReimCtlImportDataOp.class);
    public static final String NEW = "new";
    public static final String OVERRIDE = "override";
    public static final String OVERRIDE_NEW = "overridenew";
    private Map<String, DynamicObject> costCompanyMap = new ConcurrentHashMap<String, DynamicObject>(3);

    public ApiResult save(List<ImportBillData> rowdatas, ImportLogger importLogger) {
        long startProcessTime = System.currentTimeMillis();
        HashMap<String, Integer> validMap = new HashMap<String, Integer>();
        HashSet<String> companyNumberSet = new HashSet<String>(rowdatas.size());
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            if (data.getJSONObject("costcompany") != null) continue;
            JSONObject companyJson = data.getJSONObject("company");
            companyNumberSet.add(companyJson.getString("number"));
        }
        Map<String, Long> companyMap = null;
        HashMap<Long, Long> accountCompanyIdMap = new HashMap<Long, Long>(rowdatas.size());
        if (!companyNumberSet.isEmpty()) {
            DynamicObjectCollection colls = QueryServiceHelper.query((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "in", companyNumberSet)});
            companyMap = colls.stream().collect(Collectors.toMap(col -> col.getString("number"), col -> col.getLong("id"), (a, b) -> a));
            HashMap<String, Long> accountOrgIdMap = new HashMap<String, Long>(rowdatas.size());
            HashSet<Long> accountOrgIdSet = new HashSet<Long>(rowdatas.size());
            HashSet<String> costCompanyNumberSet = new HashSet<String>(rowdatas.size());
            for (ImportBillData rowdata : rowdatas) {
                JSONObject data = rowdata.getData();
                if (data.getJSONObject("costcompany") != null) continue;
                Integer rowNum = data.getInteger("rowNum");
                JSONObject companyJson = data.getJSONObject("company");
                if (!companyMap.containsKey(companyJson.getString("number"))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u3002", (String)"PersonReimCtlImportDataOp_23", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
                long companyId = companyMap.get(companyJson.getString("number"));
                companyJson.put("importprop", (Object)"id");
                companyJson.put("id", (Object)companyId);
                Long accountOrgId = null;
                if (accountCompanyIdMap.containsKey(companyId)) {
                    accountOrgId = (Long)accountCompanyIdMap.get(companyId);
                } else {
                    accountOrgId = CoreBaseBillServiceHelper.getAccountOrgId((Long)companyId, (Boolean)true);
                    accountCompanyIdMap.put(companyId, accountOrgId);
                }
                if (accountOrgId == null || accountOrgId.compareTo(0L) == 0 || accountOrgId.compareTo(-1L) == 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u65e0\u5bf9\u5e94\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u6838\u5bf9\u201c\u7533\u8bf7\u4eba\u516c\u53f8\u201d\uff0c\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"PersonReimCtlImportDataOp_24", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
                accountOrgIdMap.put(companyJson.getString("number"), accountOrgId);
                accountOrgIdSet.add(accountOrgId);
            }
            if (!accountOrgIdSet.isEmpty()) {
                DynamicObjectCollection accountOrgColls = QueryServiceHelper.query((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "in", accountOrgIdSet)});
                HashMap<Long, String> accountOrgIdMap2 = new HashMap<Long, String>(rowdatas.size());
                for (int i = 0; i < accountOrgColls.size(); ++i) {
                    String accountNumber = ((DynamicObject)accountOrgColls.get(i)).getString("number");
                    costCompanyNumberSet.add(accountNumber);
                    accountOrgIdMap2.put(((DynamicObject)accountOrgColls.get(i)).getLong("id"), accountNumber);
                }
                for (ImportBillData rowdata : rowdatas) {
                    JSONObject data = rowdata.getData();
                    if (data.getJSONObject("costcompany") != null) continue;
                    JSONObject companyJson = data.getJSONObject("company");
                    JSONObject costcompanyJsonObj = new JSONObject();
                    String companyNum = companyJson.getString("number");
                    Long accountOrgId = (Long)accountOrgIdMap.get(companyNum);
                    if (!accountOrgIdMap2.containsKey(accountOrgId)) continue;
                    costcompanyJsonObj.put("importprop", (Object)"id");
                    costcompanyJsonObj.put("id", (Object)accountOrgId);
                    costcompanyJsonObj.put("number", accountOrgIdMap2.get(accountOrgId));
                    data.put("costcompany", (Object)costcompanyJsonObj);
                }
            }
            this.QueryCostCompany(this.costCompanyMap, costCompanyNumberSet);
        }
        long endProcessTime = System.currentTimeMillis();
        logger.info(String.format("step1 \u5bfc\u5165\u5171\u8017\u65f6\uff1a%s ms", endProcessTime - startProcessTime));
        startProcessTime = System.currentTimeMillis();
        Map<String, Map<String, Object>> validData = this.progressValidData(rowdatas);
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            ImportBillData data = it.next();
            String validMsg = this.validBillData(data, validMap, validData, accountCompanyIdMap);
            if (!StringUtils.isNotBlank((CharSequence)validMsg)) continue;
            importLogger.log(Integer.valueOf(data.getStartIndex()), validMsg);
            importLogger.fail();
            it.remove();
        }
        endProcessTime = System.currentTimeMillis();
        logger.info(String.format("step2 \u5bfc\u5165\u5171\u8017\u65f6\uff1a%s ms", endProcessTime - startProcessTime));
        validMap.clear();
        validMap = null;
        startProcessTime = System.currentTimeMillis();
        ApiResult apiResult = super.save(rowdatas, importLogger);
        endProcessTime = System.currentTimeMillis();
        logger.info(String.format("step3 \u5bfc\u5165\u5171\u8017\u65f6\uff1a%s ms", endProcessTime - startProcessTime));
        return apiResult;
    }

    private Map<String, Map<String, Object>> progressValidData(List<ImportBillData> rowdatas) {
        HashSet<String> companyNumSet = new HashSet<String>(rowdatas.size());
        HashSet<String> userNumSet = new HashSet<String>(rowdatas.size());
        HashSet<String> currencyNumSet = new HashSet<String>(rowdatas.size());
        HashSet<String> expItemNumSet = new HashSet<String>(rowdatas.size());
        HashSet<String> yearSet = new HashSet<String>(rowdatas.size());
        HashMap<String, Map<String, Object>> tmap = new HashMap<String, Map<String, Object>>();
        for (ImportBillData rowdata : rowdatas) {
            JSONObject data = rowdata.getData();
            String companyNum = data.getJSONObject("company").getString("number");
            companyNumSet.add(companyNum);
            String userNum = data.getJSONObject("employee").getString("number");
            userNumSet.add(userNum);
            String currencyNum = data.getJSONObject("currency").getString("number");
            currencyNumSet.add(currencyNum);
            String expenseItemNum = data.getJSONObject("expenseitem").getString("number");
            expItemNumSet.add(expenseItemNum);
            String year = data.getString("dateyear");
            yearSet.add(year);
        }
        QFilter qf = new QFilter("number", "in", companyNumSet).and("enable", "=", (Object)true);
        DynamicObjectCollection companyDO = QueryServiceHelper.query((String)"bos_org", (String)"id,number", (QFilter[])new QFilter[]{qf});
        HashMap<String, Object> companyMap = new HashMap<String, Object>(companyDO.size());
        for (int i = 0; i < companyDO.size(); ++i) {
            companyMap.put(((DynamicObject)companyDO.get(i)).get("number").toString(), companyDO.get(i));
        }
        tmap.put("org", companyMap);
        qf = new QFilter("org.number", "in", companyNumSet).and("org.enable", "=", (Object)true).and("isfreeze", "=", (Object)false).and("view", "=", (Object)1L);
        DynamicObjectCollection orgDO = QueryServiceHelper.query((String)"bos_org_structure", (String)"id,org.number", (QFilter[])new QFilter[]{qf});
        HashMap<String, Object> orgMap = new HashMap<String, Object>(orgDO.size());
        for (int i = 0; i < orgDO.size(); ++i) {
            orgMap.put(((DynamicObject)orgDO.get(i)).get("org.number").toString(), orgDO.get(i));
        }
        tmap.put("company", orgMap);
        qf = new QFilter("number", "in", userNumSet).and("enable", "=", (Object)true);
        DynamicObjectCollection userDO = QueryServiceHelper.query((String)"bos_user", (String)"id,number", (QFilter[])new QFilter[]{qf});
        HashMap<String, Object> userMap = new HashMap<String, Object>(userDO.size());
        for (int i = 0; i < userDO.size(); ++i) {
            userMap.put(((DynamicObject)userDO.get(i)).get("number").toString(), userDO.get(i));
        }
        tmap.put("employee", userMap);
        qf = new QFilter("number", "in", currencyNumSet).and("enable", "=", (Object)true);
        DynamicObjectCollection curDO = QueryServiceHelper.query((String)"bd_currency", (String)"id,number", (QFilter[])new QFilter[]{qf});
        HashMap<String, Object> curMap = new HashMap<String, Object>(curDO.size());
        for (int i = 0; i < curDO.size(); ++i) {
            curMap.put(((DynamicObject)curDO.get(i)).get("number").toString(), curDO.get(i));
        }
        tmap.put("currency", curMap);
        QFilter qFilter = new QFilter("company.number", "in", companyNumSet).and("employee.number", "in", userNumSet).and("expenseitem.number", "in", expItemNumSet).and("currency.number", "in", currencyNumSet).and("dateyear", "in", yearSet).and("auditstatus", "!=", (Object)Character.valueOf('2'));
        DynamicObjectCollection reimburseAmountDOs = QueryServiceHelper.query((String)"er_reimburseamount", (String)"id,auditstatus,company.number,employee.number,expenseitem.number,currency.number,dateyear,month1,month2,month3,month4,month5,month6,month7,month8,month9,month10,month11,month12,quarter1,quarter2,quarter3,quarter4", (QFilter[])new QFilter[]{qFilter});
        DynamicObject reimburseAmountDO = null;
        HashMap reimburseAmountMap = new HashMap(reimburseAmountDOs.size());
        for (int i = 0; i < reimburseAmountDOs.size(); ++i) {
            reimburseAmountDO = (DynamicObject)reimburseAmountDOs.get(i);
            String pk_key = reimburseAmountDO.getString("company.number") + reimburseAmountDO.getString("employee.number") + reimburseAmountDO.getString("expenseitem.number") + reimburseAmountDO.getString("currency.number") + reimburseAmountDO.getString("dateyear");
            if (reimburseAmountMap.containsKey(pk_key)) {
                ((List)reimburseAmountMap.get(pk_key)).add(reimburseAmountDO);
                continue;
            }
            ArrayList<DynamicObject> raList = new ArrayList<DynamicObject>();
            raList.add(reimburseAmountDO);
            reimburseAmountMap.put(pk_key, raList);
        }
        tmap.put("reimburseAmount", reimburseAmountMap);
        return tmap;
    }

    private void QueryCostCompany(Map<String, DynamicObject> costCompanyMap, Set<String> costCompanyNumberSet) {
        QFilter orgFilter = new QFilter("org.number", "in", costCompanyNumberSet);
        QFilter viewType = new QFilter("view.id", "=", (Object)10);
        DynamicObjectCollection costCompanys = QueryServiceHelper.query((String)"bos_org_structure", (String)"org.id,org.number,isfreeze", (QFilter[])new QFilter[]{orgFilter, viewType});
        for (DynamicObject costCompany : costCompanys) {
            costCompanyMap.put(costCompany.getString("org.number"), costCompany);
        }
    }

    private String validBillData(ImportBillData data, HashMap<String, Integer> validMap, Map<String, Map<String, Object>> validData, Map<Long, Long> accountCompanyIdMap) {
        Object rawAmount;
        int i;
        String validMsg = "";
        validMsg = this.validateNumber(data, "company", validData, ResManager.loadKDString((String)"\u516c\u53f8", (String)"PersonReimCtlImportDataOp_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
        if (validMsg != null) {
            return validMsg;
        }
        String expenseItemNumber = data.getData().getJSONObject("expenseitem").getString("number");
        QFilter qfNumber = new QFilter("number", "=", (Object)expenseItemNumber);
        QFilter qfEnable = new QFilter("enable", "=", (Object)true);
        DynamicObject company = (DynamicObject)validData.get("org").get(this.getBasedataNumber(data, "company"));
        Long costCompanyPK = null;
        if (accountCompanyIdMap.containsKey(company.getLong("id"))) {
            costCompanyPK = accountCompanyIdMap.get(company.getLong("id"));
        } else {
            costCompanyPK = CoreBaseBillServiceHelper.getAccountOrgId((Long)company.getLong("id"), (Boolean)true);
            accountCompanyIdMap.put(company.getLong("id"), costCompanyPK);
        }
        QFilter baseDataFilter = null;
        if (costCompanyPK != null && costCompanyPK != 0L) {
            baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)costCompanyPK);
        }
        JSONObject costcompanyJSONObject = data.getData().getJSONObject("costcompany");
        DynamicObject costCompany = null;
        if (this.costCompanyMap != null && costcompanyJSONObject != null && (costCompany = this.costCompanyMap.get(costcompanyJSONObject.getString("number"))) != null && costCompany.getBoolean("isfreeze")) {
            validMsg = ResManager.loadKDString((String)"\u6b64\u6761\u6570\u636e\u4e2d\u7684\u6838\u7b97\u7ec4\u7ec7\u5df2\u5c01\u5b58\u3002", (String)"DeptReimCtlImportDataOp_20", (String)"fi-er-opplugin", (Object[])new Object[0]);
            logger.info("\u6838\u7b97\u7ec4\u7ec7\u5df2\u7ecf\u5c01\u5b58, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
            return validMsg;
        }
        DynamicObject expenseItemDO = QueryServiceHelper.queryOne((String)"er_expenseitemedit", (String)"reimburseamountctlmethod,isreimburseamountctl", (QFilter[])new QFilter[]{qfNumber, qfEnable, baseDataFilter});
        if (expenseItemDO == null) {
            validMsg = ResManager.loadKDString((String)"\u6b64\u6761\u6570\u636e\u4e2d\u7684\u8d39\u7528\u9879\u76ee\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u6216\u4e0d\u53ef\u7528\uff0c\u8bf7\u4fee\u6539\u8d39\u7528\u9879\u76ee\u7f16\u7801\u3002", (String)"PersonReimCtlImportDataOp_1", (String)"fi-er-opplugin", (Object[])new Object[0]);
            logger.info("\u5bf9\u5e94\u7684\u8d39\u7528\u9879\u76ee\u4e0d\u5b58\u5728, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
            return validMsg;
        }
        if (!"1".equals(expenseItemDO.getString("isreimburseamountctl"))) {
            validMsg = ResManager.loadKDString((String)"\u6b64\u6761\u6570\u636e\u4e2d\u7684\u8d39\u7528\u9879\u76ee\u4e0d\u662f\u4e2a\u4eba\u989d\u5ea6\u63a7\u5236\u3002", (String)"PersonReimCtlImportDataOp_2", (String)"fi-er-opplugin", (Object[])new Object[0]);
            logger.info("\u8d39\u7528\u9879\u76ee\u4e0d\u662f\u4e2a\u4eba\u989d\u5ea6\u63a7\u5236, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
            return validMsg;
        }
        validMsg = this.validateNumber(data, "employee", validData, ResManager.loadKDString((String)"\u804c\u5458", (String)"PersonReimCtlImportDataOp_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
        if (validMsg != null) {
            return validMsg;
        }
        validMsg = this.validateNumber(data, "currency", validData, ResManager.loadKDString((String)"\u5e01\u79cd", (String)"PersonReimCtlImportDataOp_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
        if (validMsg != null) {
            return validMsg;
        }
        ArrayList<Object> recorder = Lists.newArrayListWithExpectedSize((int)0);
        boolean isUpdatePartOfData = false;
        String ctrlMethod = expenseItemDO.getString("reimburseamountctlmethod");
        if (StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Yearly.getValue())) {
            if (data.getData().containsKey((Object)"month1")) {
                validMsg = ResManager.loadKDString((String)"\u6b64\u6761\u8d39\u7528\u9879\u76ee\u4e3a\u6309\u5e74\u63a7\u5236\uff0c\u8bf7\u4f7f\u7528\u201c\u989d\u5ea6\u8868\u7ef4\u62a4\uff08\u6309\u5e74\u63a7\u5236\uff09\u201d\u6a21\u677f\u5bfc\u5165\u3002", (String)"PersonReimCtlImportDataOp_5", (String)"fi-er-opplugin", (Object[])new Object[0]);
                logger.info("\u6309\u5e74\u63a7\u5236, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
                return validMsg;
            }
            BigDecimal totalAmount = new BigDecimal(data.getData().getString("totalamount"));
            if (totalAmount.compareTo(BigDecimal.ZERO) < 0) {
                validMsg = ResManager.loadKDString((String)"\u603b\u989d\u5ea6\u4e0d\u80fd\u4e3a\u8d1f\u6570\u3002", (String)"PersonReimCtlImportDataOp_6", (String)"fi-er-opplugin", (Object[])new Object[0]);
                return validMsg;
            }
        } else if (StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Monthly.getValue()) || StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Accumulative.getValue())) {
            if (data.getData().keySet().stream().noneMatch(key -> key.contains("month"))) {
                validMsg = ResManager.loadKDString((String)"\u6b64\u6761\u8d39\u7528\u9879\u76ee\u4e3a\u6309\u6708/\u7d2f\u79ef\u63a7\u5236\uff0c\u8bf7\u4f7f\u7528\u201c\u989d\u5ea6\u8868\u7ef4\u62a4\u201d\u6a21\u677f\u5bfc\u5165\u3002", (String)"PersonReimCtlImportDataOp_7", (String)"fi-er-opplugin", (Object[])new Object[0]);
                logger.info("\u6309\u6708/\u7d2f\u79ef\u63a7\u5236, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
                return validMsg;
            }
            BigDecimal totalAmount = BigDecimal.ZERO;
            recorder = new ArrayList<Object>(12);
            for (i = 1; i <= 12; ++i) {
                rawAmount = data.getData().get((Object)("month" + i));
                recorder.add(rawAmount);
                isUpdatePartOfData = isUpdatePartOfData || rawAmount == null;
                totalAmount = totalAmount.add(rawAmount == null ? BigDecimal.ZERO : new BigDecimal(rawAmount.toString()));
            }
            if (!isUpdatePartOfData) {
                data.getData().put("totalamount", (Object)totalAmount.toString());
            }
            for (int i2 = 1; i2 <= 12; ++i2) {
                BigDecimal amount;
                String name = "month" + i2;
                rawAmount = data.getData().get((Object)name);
                BigDecimal bigDecimal = amount = rawAmount == null ? BigDecimal.ZERO : new BigDecimal(rawAmount.toString());
                if (amount.compareTo(BigDecimal.ZERO) >= 0) continue;
                validMsg = String.format(ResManager.loadKDString((String)"%s\u989d\u5ea6\u4e0d\u80fd\u4e3a\u8d1f\u6570", (String)"PersonReimCtlImportDataOp_21", (String)"fi-er-opplugin", (Object[])new Object[0]), name);
                return validMsg;
            }
        } else if (StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)ErExpenseItemConstant.ReimburseAmountCtlMethod.Quarterly.getValue())) {
            if (data.getData().keySet().stream().noneMatch(key -> key.contains("quarter"))) {
                validMsg = ResManager.loadKDString((String)"\u6b64\u6761\u8d39\u7528\u9879\u76ee\u4e3a\u6309\u5b63\u63a7\u5236\uff0c\u8bf7\u4f7f\u7528\u201c\u989d\u5ea6\u8868\u7ef4\u62a4\uff08\u6309\u5b63\u63a7\u5236\uff09\u201d\u6a21\u677f\u5bfc\u5165\u3002", (String)"PersonReimCtlImportDataOp_9", (String)"fi-er-opplugin", (Object[])new Object[0]);
                logger.info("\u6309\u5b63\u63a7\u5236, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
                return validMsg;
            }
            BigDecimal totalAmount = BigDecimal.ZERO;
            recorder = new ArrayList(4);
            for (i = 1; i <= 4; ++i) {
                rawAmount = data.getData().getBigDecimal("quarter" + i);
                recorder.add(rawAmount);
                boolean bl = isUpdatePartOfData = isUpdatePartOfData || rawAmount == null;
                if (rawAmount != null && ((BigDecimal)rawAmount).compareTo(BigDecimal.ZERO) < 0) {
                    validMsg = String.format(ResManager.loadKDString((String)"%1$s%2$s\u989d\u5ea6\u4e0d\u80fd\u4e3a\u8d1f\u6570", (String)"PersonReimCtlImportDataOp_22", (String)"fi-er-opplugin", (Object[])new Object[0]), "quarter", i);
                    return validMsg;
                }
                totalAmount = totalAmount.add((BigDecimal)(rawAmount == null ? BigDecimal.ZERO : rawAmount));
            }
            if (!isUpdatePartOfData) {
                data.getData().put("totalamount", (Object)totalAmount.toString());
            }
        }
        String importType = (String)this.ctx.getOption().get("importtype");
        String companyNumber = this.getBasedataNumber(data, "company");
        String employeeNumber = this.getBasedataNumber(data, "employee");
        String currencyNumber = this.getBasedataNumber(data, "currency");
        String year = data.getData().getString("dateyear");
        String pk_key = companyNumber + employeeNumber + expenseItemNumber + currencyNumber + year;
        if (null != validMap.get(pk_key)) {
            validMsg = String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u62a5\u9500\u989d\u5ea6\u6570\u636e\uff08\u5e74\uff1a%2$s\uff0c\u804c\u5458\uff1a%3$s\uff0c\u516c\u53f8\uff1a%4$s\uff0c\u8d39\u7528\u9879\u76ee\uff1a%5$s\uff0c\u5e01\u79cd\uff1a%6$s\uff09\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u65b0\u589e\uff0c\u8bf7\u9009\u62e9\u8986\u76d6\u65b9\u5f0f\u5bfc\u5165\u3002", (String)"PersonReimCtlImportDataOp_10", (String)"fi-er-opplugin", (Object[])new Object[0]), validMap.get(pk_key), year, employeeNumber, companyNumber, expenseItemNumber, currencyNumber);
            return validMsg;
        }
        List reimburseAmountDOs = (List)validData.get("reimburseAmount").get(pk_key);
        if (reimburseAmountDOs != null) {
            if (reimburseAmountDOs.size() > 1) {
                validMsg = ResManager.loadKDString((String)"\u67e5\u8be2\u7ed3\u679c\u4e0d\u552f\u4e00\uff0c\u8bf7\u5148\u6e05\u7406\u540e\u518d\u5bfc\u5165\u3002\uff08\u6570\u636e\u5339\u914d\u7ef4\u5ea6\uff1a\u516c\u53f8\u3001\u804c\u5458\u3001\u8d39\u7528\u9879\u76ee\u3001\u5e01\u79cd\u3001\u5e74\u5ea6\uff09", (String)"PersonReimCtlImportDataOp_11", (String)"fi-er-opplugin", (Object[])new Object[0]);
                logger.info(String.format("\u516c\u53f8(%s)+\u804c\u5458(%s)+\u8d39\u7528\u9879\u76ee(%s)+\u5e01\u79cd(%s)+\u5e74\u5ea6(%s) \u67e5\u8be2\u7ed3\u679c\u4e0d\u552f\u4e00, \u6709\u810f\u6570\u636e, \u67e5\u8be2\u7ed3\u679c\u4e3a:%s", companyNumber, employeeNumber, expenseItemNumber, currencyNumber, year, SerializationUtils.toJsonString((Object)reimburseAmountDOs)));
                return validMsg;
            }
            if (reimburseAmountDOs.size() == 1) {
                if (StringUtils.equals((CharSequence)importType, (CharSequence)NEW)) {
                    String errorMsg;
                    validMsg = errorMsg = String.format(ResManager.loadKDString((String)"\u62a5\u9500\u989d\u5ea6\u6570\u636e\uff08\u5e74\uff1a%1$s, \u804c\u5458\uff1a%2$s\uff0c\u516c\u53f8\uff1a%3$s, \u8d39\u7528\u9879\u76ee\uff1a%4$s, \u5e01\u79cd\uff1a%5$s\uff09\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u65b0\u589e\uff0c\u8bf7\u9009\u62e9\u8986\u76d6\u65b9\u5f0f\u5bfc\u5165\u3002", (String)"PersonReimCtlImportDataOp_12", (String)"fi-er-opplugin", (Object[])new Object[0]), year, employeeNumber, companyNumber, expenseItemNumber, currencyNumber);
                    logger.info(errorMsg);
                    logger.info(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u5bfc\u5165\u6a21\u5f0f\u4e3a\u201c\u65b0\u589e\u201d\uff0c\u4f46\u6570\u636e\u5e93\u4e2d\u5df2\u7ecf\u5b58\u5728\u5bf9\u5e94\u7684\u989d\u5ea6\u6570\u636e\uff0c\u65b0\u589e\u5931\u8d25\u3002", (String)"PersonReimCtlImportDataOp_13", (String)"fi-er-opplugin", (Object[])new Object[0]), SerializationUtils.toJsonString((Object)reimburseAmountDOs)));
                    return validMsg;
                }
                DynamicObject reimburseAmountDO = (DynamicObject)reimburseAmountDOs.get(0);
                boolean iscover = ErStdConfig.getIsCoverAuditForReimburseAmount();
                if (!iscover && "1".equals(reimburseAmountDO.getString("auditstatus"))) {
                    String errorMsg;
                    validMsg = errorMsg = String.format(ResManager.loadKDString((String)"%1$s\u5e74\uff0c\u804c\u5458%2$s\u5728%3$s\u516c\u53f8\uff0c\u8d39\u7528\u9879\u76ee\u4e3a%4$s\uff0c\u5e01\u79cd\u4e3a%5$s\u7684\u62a5\u9500\u989d\u5ea6\u6570\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u8986\u76d6\uff0c\u8bf7\u53cd\u5ba1\u6838\u540e\u91cd\u65b0\u5bfc\u5165\u3002", (String)"PersonReimCtlImportDataOp_14", (String)"fi-er-opplugin", (Object[])new Object[0]), year, employeeNumber, companyNumber, expenseItemNumber, currencyNumber);
                    logger.info(errorMsg);
                    return validMsg;
                }
                if (isUpdatePartOfData) {
                    int i3;
                    int size = recorder.size();
                    if (size == 4) {
                        for (i3 = 0; i3 < 4; ++i3) {
                            if (recorder.get(i3) == null) {
                                recorder.set(i3, reimburseAmountDO.getBigDecimal("quarter" + (i3 + 1)));
                                continue;
                            }
                            recorder.set(i3, new BigDecimal(recorder.get(i3).toString()));
                        }
                    } else {
                        for (i3 = 0; i3 < 12; ++i3) {
                            if (recorder.get(i3) == null) {
                                recorder.set(i3, reimburseAmountDO.getBigDecimal("month" + (i3 + 1)));
                                continue;
                            }
                            recorder.set(i3, new BigDecimal(recorder.get(i3).toString()));
                        }
                    }
                    BigDecimal sum = recorder.stream().reduce((a, b) -> ((BigDecimal)a).add((BigDecimal)b)).orElse(BigDecimal.ZERO);
                    data.getData().put("totalamount", (Object)sum);
                }
                data.getData().put("id", (Object)reimburseAmountDO.getLong("id"));
            }
        }
        validMap.put(pk_key, data.getStartIndex());
        return null;
    }

    private String validateNumber(ImportBillData data, String fieldName, Map<String, Map<String, Object>> validData, String showName) {
        String validMsg = "";
        String number = data.getData().getJSONObject(fieldName).getString("number");
        DynamicObject DO = null;
        if (validData.get(fieldName) != null && validData.get(fieldName).containsKey(number)) {
            DO = (DynamicObject)validData.get(fieldName).get(number);
        }
        if (DO == null) {
            validMsg = String.format(ResManager.loadKDString((String)"\u6b64\u6761\u6570\u636e\u4e2d\u7684%s\u7f16\u7801\u4e0d\u5b58\u5728, \u8bf7\u4fee\u6539\u6b63\u786e\u540e\u518d\u5bfc\u5165", (String)"PersonReimCtlImportDataOp_15", (String)"fi-er-opplugin", (Object[])new Object[0]), showName);
            logger.info("\u6b64\u6761\u6570\u636e\u4e2d\u7684" + showName + "\u7f16\u53f7\u4e0d\u5b58\u5728, \u8fd9\u6761\u6570\u636e\u5bfc\u5165\u5931\u8d25:" + JSONObject.toJSONString((Object)data.getData()));
            return validMsg;
        }
        return null;
    }

    private String getBasedataNumber(ImportBillData data, String fieldName) {
        return data.getData().getJSONObject(fieldName).getString("number");
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        return Lists.newArrayList((Object[])new ComboItem[]{new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"PersonReimCtlImportDataOp_17", (String)"fi-er-opplugin", (Object[])new Object[0])), "id")});
    }

    public String getDefaultKeyFields() {
        return "id";
    }

    public List<String> getDefaultLockUIs() {
        return Lists.newArrayList((Object[])new String[]{"keyfields"});
    }

    protected boolean isForceBatch() {
        return true;
    }
}

