/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.datacheck.validator.CommonAmountCheckCondition;
import kd.fi.er.business.task.datacheck.util.ErDataCheckUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import org.apache.commons.lang3.StringUtils;

public class BillAmountCheckValidator
extends AbstractValidator {
    private Log logger = LogFactory.getLog(BillAmountCheckValidator.class);

    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        ErDataCheckUtil.addPreparePropertys((Collection)preparePropertys);
        return preparePropertys;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String entryId = this.getEntityKey();
        if (ErEntityTypeUtils.isTripReqBill((String)entryId)) {
            dataEntities = (ExtendedDataEntity[])Arrays.stream(dataEntities).filter(dataEntity -> dataEntity.getDataEntity().getBoolean("isloan")).toArray(ExtendedDataEntity[]::new);
        }
        try {
            this.doValidate(dataEntities);
        }
        catch (Exception e) {
            this.logger.error((Throwable)e);
        }
    }

    private void doValidate(ExtendedDataEntity[] dataEntities) throws IllegalAccessException, InstantiationException {
        if (dataEntities.length == 0) {
            return;
        }
        String operateType = this.getOperateType();
        String operateKey = this.getOperateKey();
        if (StringUtils.equalsAny((CharSequence)operateType, (CharSequence[])new CharSequence[]{"delete", "unaudit", "unsubmit"})) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Field[] fields;
            DynamicObject bill = dataEntity.getDataEntity();
            if (StringUtils.equals((CharSequence)operateKey, (CharSequence)"save") && this.isSkipStatus(bill)) continue;
            if (null == bill.get("company")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"BillAmountCheckValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return;
            }
            Class<CommonAmountCheckCondition> commonAmountCheckConditionClass = CommonAmountCheckCondition.class;
            CommonAmountCheckCondition commonAmountCheckCondition = (CommonAmountCheckCondition)commonAmountCheckConditionClass.newInstance();
            for (Field field : fields = commonAmountCheckCondition.getClass().getFields()) {
                String msg;
                Object validator;
                if (!ErDataCheckUtil.whetherExecuteValidator((String)field.getName()) || (validator = field.get(commonAmountCheckCondition)) == null || !StringUtils.isNotBlank((CharSequence)(msg = ErDataCheckUtil.assertCondition((DynamicObject)bill, (Function)((Function)validator))))) continue;
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }

    private boolean isSkipStatus(DynamicObject bill) {
        String billStatus = bill.getString("billstatus");
        return StringUtils.equalsAny((CharSequence)billStatus, (CharSequence[])new CharSequence[]{"A", "D"});
    }
}

