/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;

public class DailyapplybillCloseValidator
extends AbstractValidator {
    private static String[] outStandingState = new String[]{"A", "B", "C", "D"};
    private static String[] contraOutStandingState = new String[]{"A", "B", "C", "D", "E", "F"};

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        String[] extbillfromstatus = null;
        HashMap<String, String[]> nameToState = new HashMap<String, String[]>();
        String value = ErStdConfig.get((String)"extbillfromstatus");
        if (value != null) {
            extbillfromstatus = value.split(",");
            for (int i = 0; i < extbillfromstatus.length; ++i) {
                String[] strings = extbillfromstatus[i].split("\\.");
                String billName = strings[0];
                String[] billStandingState = Arrays.copyOfRange(strings, 1, strings.length);
                nameToState.put(billName, billStandingState);
            }
        }
        block1: for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            Long billId = (Long)dataEntity.getBillPkId();
            DynamicObject bill = dataEntity.getDataEntity();
            String entityNumber = bill.getDataEntityType().getName();
            Map tBills = BFTrackerServiceHelper.findDirtTargetBills((String)entityNumber, (Long[])new Long[]{billId});
            HashSet directTargetBillIds = new HashSet(8);
            tBills.values().stream().filter(e -> !e.isEmpty()).forEach(e -> e.stream().filter(row -> row != null && row.getId() != null).forEach(r -> directTargetBillIds.add(r.getId().getBillId())));
            Map targetBills = BFTrackerServiceHelper.findTargetBills((String)entityNumber, (Long[])new Long[]{billId});
            if (targetBills == null || targetBills.size() <= 0) continue;
            for (Map.Entry next : targetBills.entrySet()) {
                DynamicObjectCollection filterBills;
                QFilter filter = new QFilter("id", "in", next.getValue());
                filter.and(new QFilter("id", "in", directTargetBillIds));
                if (extbillfromstatus != null && nameToState.containsKey(next.getKey())) {
                    filter.and(new QFilter("billstatus", "in", nameToState.get(next.getKey())));
                } else if (ErEntityTypeUtils.isContractBill((String)entityNumber) && !ErEntityTypeUtils.isContractBill((String)((String)next.getKey()))) {
                    if (ErEntityTypeUtils.isPublicReimburseBill((String)((String)next.getKey()))) {
                        filter.and(new QFilter("billstatus", "in", (Object)Lists.newArrayList((Object[])new String[]{"A", "B", "C", "D", "F"})).or(new QFilter("billstatus", "=", (Object)"E").and(new QFilter("payamount", ">", (Object)0))));
                    } else {
                        filter.and(new QFilter("billstatus", "in", (Object)contraOutStandingState));
                    }
                } else {
                    filter.and(new QFilter("billstatus", "in", (Object)outStandingState));
                }
                if ((filterBills = QueryServiceHelper.query((String)((String)next.getKey()), (String)"id", (QFilter[])new QFilter[]{filter})) == null || filterBills.size() <= 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u4ecd\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u5173\u95ed\u3002", (String)"DailyapplybillCloseValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue block1;
            }
        }
    }
}

