/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.PayerTypeEnum;
import kd.fi.er.validator.PayeraccountSubmitValidator;

public class ErCheckAccountSubmitValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(ErCheckAccountSubmitValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            if ("er_checkingpaybill".equals(dynamicObject.getDataEntityType().getName())) {
                if (this.resolveBill(dataEntity)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4eba\u4fe1\u606f\u5df2\u7981\u7528\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"ErCheckAccountSubmitValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return;
            }
            List<Integer> indexs = this.resolveEntry(dataEntity);
            if (indexs == null || indexs.isEmpty()) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u7b2c%s\u884c\u6536\u6b3e\u4eba\u4fe1\u606f\u5df2\u7981\u7528\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"ErCheckAccountSubmitValidator_0", (String)"fi-er-opplugin", (Object[])new Object[]{indexs.toString().replaceAll("[^\\d|,]", "").replaceAll(",", "\uff0c")}));
            return;
        }
    }

    private boolean resolveBill(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObject payer = (DynamicObject)dynamicObject.get("payer");
        if (payer == null) {
            return false;
        }
        String payerType = dynamicObject.getString("payertype");
        PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)payerType);
        return this.checkPayer(payer, payerTypeEnum);
    }

    private boolean checkPayer(DynamicObject payer, PayerTypeEnum payerTypeEnum) {
        DynamicObject item;
        if (PayeraccountSubmitValidator.validaRange.contains(payerTypeEnum)) {
            return Boolean.TRUE;
        }
        String selectFields = "enable";
        QFilter filter = new QFilter("id", "=", payer.getPkValue());
        DynamicObjectCollection orderBills = QueryServiceHelper.query((String)payerTypeEnum.getType(), (String)selectFields, (QFilter[])new QFilter[]{filter});
        return !orderBills.isEmpty() && (item = (DynamicObject)orderBills.get(0)).getBoolean("enable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Integer> resolveEntry(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection accouts;
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String entry = ErEntityTypeUtils.isRepaymentBill((String)dynamicObject.getDataEntityType().getName()) ? "recentry" : "accountentry";
        try {
            accouts = dynamicObject.getDynamicObjectCollection(entry);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            accouts = null;
        }
        if (accouts == null || accouts.isEmpty()) {
            return null;
        }
        ArrayList<Integer> indexs = new ArrayList<Integer>();
        int index = 1;
        for (DynamicObject accout : accouts) {
            try {
                String payerType = accout.getString("payertype");
                PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)payerType);
                DynamicObject payer = (DynamicObject)accout.get(payerTypeEnum.name());
                if (payer == null || this.checkPayer(payer, payerTypeEnum)) continue;
                indexs.add(index);
            }
            catch (Exception e) {
                logger.info("\u5f53\u524d\u5355\u636e\u6ca1\u6709\u6b64\u79cd\u6536\u6b3e\u4eba\u7c7b\u578b\uff0c\u4e0d\u505a\u5224\u65ad");
            }
            finally {
                ++index;
            }
        }
        return indexs;
    }
}

