/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.PayerTypeEnum;

public class PayeraccountSubmitValidator
extends AbstractValidator {
    public static final Set<PayerTypeEnum> validaRange = new HashSet<PayerTypeEnum>(2);

    private boolean needVerify(ExtendedDataEntity dataEntity) {
        DynamicObject bill = dataEntity.getDataEntity();
        IDataEntityProperty dtp = (IDataEntityProperty)bill.getDataEntityType().getProperties().get((Object)"accountentry");
        if (dtp == null) {
            return false;
        }
        String entityId = bill.getDataEntityType().getName();
        if (ErEntityTypeUtils.isRepaymentBill((String)entityId) || ErEntityTypeUtils.isCheckingpayBill((String)entityId)) {
            return false;
        }
        if (ErEntityTypeUtils.isTripReqBill((String)entityId)) {
            return bill.getBoolean("isloan");
        }
        return true;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntitys;
        for (ExtendedDataEntity dataEntity : dataEntitys = this.getDataEntities()) {
            DynamicObject bill = dataEntity.getDataEntity();
            if (!this.needVerify(dataEntity)) {
                return;
            }
            DynamicObjectCollection accountEntry = bill.getDynamicObjectCollection("accountentry");
            HashMap record = new HashMap(accountEntry.size());
            HashMap<Integer, String> indexAndPayAcc = new HashMap<Integer, String>(accountEntry.size());
            for (int i = 0; i < accountEntry.size(); ++i) {
                DynamicObject row = (DynamicObject)accountEntry.get(i);
                PayerTypeEnum payerTypeEnum = PayerTypeEnum.getValue((String)row.getString("payertype"));
                if (payerTypeEnum != null && validaRange.contains(payerTypeEnum)) {
                    HashSet<Long> pks = (HashSet<Long>)record.get(payerTypeEnum);
                    if (pks == null) {
                        pks = new HashSet<Long>();
                    }
                    Long pk = 0L;
                    if (payerTypeEnum.compareTo((Enum)PayerTypeEnum.CASORG) == 0) {
                        pk = ErCommonUtils.getPk((Object)row.getDynamicObject("casorg"));
                    } else if (payerTypeEnum.compareTo((Enum)PayerTypeEnum.PAYER) == 0) {
                        pk = ErCommonUtils.getPk((Object)row.getDynamicObject("payer"));
                    }
                    pks.add(pk);
                    record.put(payerTypeEnum, pks);
                }
                indexAndPayAcc.put(i + 1, row.getString("payeraccount"));
            }
            if (record.isEmpty()) continue;
            for (PayerTypeEnum payerTypeEnum : validaRange) {
                DynamicObject[] load;
                Set pks = (Set)record.get(payerTypeEnum);
                if (pks == null || pks.isEmpty()) continue;
                Set uncorrectNumbers = null;
                if (payerTypeEnum.compareTo((Enum)PayerTypeEnum.CASORG) == 0) {
                    load = BusinessDataServiceHelper.load((String)"am_accountbank", (String)"bankaccountnumber,acctstatus", (QFilter[])new QFilter[]{new QFilter("company", "in", (Object)pks)});
                    uncorrectNumbers = Arrays.stream(load).filter(e -> !"normal".equals(e.getString("acctstatus"))).map(e -> e.getString("bankaccountnumber")).collect(Collectors.toSet());
                }
                if (payerTypeEnum.compareTo((Enum)PayerTypeEnum.PAYER) == 0) {
                    load = BusinessDataServiceHelper.load((String)"er_payeer", (String)"payeraccount,enable", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
                    uncorrectNumbers = Arrays.stream(load).filter(e -> !e.getBoolean("enable")).map(e -> e.getString("payeraccount")).collect(Collectors.toSet());
                }
                if (uncorrectNumbers == null || uncorrectNumbers.isEmpty()) continue;
                Set finalUncorrectNumbers = uncorrectNumbers;
                List indexs = indexAndPayAcc.entrySet().stream().filter(entrySet -> finalUncorrectNumbers.contains(entrySet.getValue())).map(Map.Entry::getKey).collect(Collectors.toList());
                if (indexs.isEmpty()) continue;
                String msg = null;
                msg = indexs.size() == 1 ? String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u7b2c%1$s\u884c\u6536\u6b3e\u94f6\u884c\u8d26\u53f7\u4e0d\u53ef\u7528\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"PayeraccountSubmitValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]), indexs.get(0)) : String.format(ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u7b2c%1$s\u884c\u6536\u6b3e\u94f6\u884c\u8d26\u53f7\u4e0d\u53ef\u7528\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"PayeraccountSubmitValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]), indexs);
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }

    static {
        validaRange.add(PayerTypeEnum.PAYER);
        validaRange.add(PayerTypeEnum.CASORG);
    }
}

