/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class ReimburseBillSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntitys;
        for (ExtendedDataEntity dataEntity : dataEntitys = this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            if (dynamicObject.getDynamicObject("company") == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErReimburseBaseBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            Long companyId = (Long)dynamicObject.getDynamicObject("company").getPkValue();
            boolean isFlag = SystemParamterUtil.isReimburseAmountLargerZero((Long)companyId);
            BigDecimal approveAmount = dynamicObject.getBigDecimal("approveamount");
            if (isFlag && (approveAmount == null || approveAmount.compareTo(BigDecimal.ZERO) <= 0)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReimburseBillSubmitValidator_6", (String)"fi-er-opplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection expenseEntrys = dynamicObject.getDynamicObjectCollection("expenseentryentity");
            for (DynamicObject expenseEntry : expenseEntrys) {
                Date happenDate = expenseEntry.getDate("happendate");
                if (happenDate == null) {
                    return;
                }
                if (!ErStdConfig.getBoolean((String)"expense.hanppendDate.noControl") && happenDate.after(new Date()) && !ErStdConfig.getBoolean((String)"happendate_future_permission")) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d39\u7528\u53d1\u751f\u65e5\u671f\u5e94\u65e9\u4e8e\u5f53\u524d\u65e5\u671f\u3002", (String)"ReimburseBillSubmitValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (expenseEntry.getBigDecimal("expenseamount") == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ReimburseBillSubmitValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    continue;
                }
                String itemFrom = expenseEntry.getString("itemfrom");
                if (StringUtils.equals((CharSequence)itemFrom, (CharSequence)ItemFrom.InvoiceCloud.getValue()) || expenseEntry.getBigDecimal("expeapproveamount").abs().compareTo(expenseEntry.getBigDecimal("taxamount").abs()) >= 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u5b9a\u91d1\u989d\u4e0d\u5f97\u5c0f\u4e8e\u7a0e\u989d\u3002", (String)"ReimburseBillSubmitValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            BigDecimal payAmount = dynamicObject.getBigDecimal("payamount");
            DynamicObjectCollection accountEntrys = dynamicObject.getDynamicObjectCollection("accountentry");
            ArrayList<Integer> indexs = new ArrayList<Integer>();
            if (!accountEntrys.isEmpty()) {
                int index = 1;
                for (DynamicObject accountEntry : accountEntrys) {
                    DynamicObject payerbank = accountEntry.getDynamicObject("payerbank");
                    if (payerbank != null && !payerbank.getBoolean("enable")) {
                        indexs.add(index);
                    }
                    ++index;
                }
            } else {
                if (payAmount.compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u9500\u501f\u6b3e\u91d1\u989d\u4e4b\u548c\u4e0d\u5f97\u5927\u4e8e\u8d39\u7528\u660e\u7ec6\u7684\u62a5\u9500\u91d1\u989d\u4e4b\u548c\u3002", (String)"ReimburseBillSubmitValidator_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return;
                }
                if (payAmount.compareTo(BigDecimal.ZERO) != 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6536\u6b3e\u4fe1\u606f", (String)"ReimburseBillSubmitValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    return;
                }
            }
            if (!indexs.isEmpty()) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u4fe1\u606f\u7b2c%s\u884c\u4e2d\u7684\u5f00\u6237\u94f6\u884c\u5df2\u88ab\u7981\u7528\u3002", (String)"ReimburseBillSubmitValidator_7", (String)"fi-er-opplugin", (Object[])new Object[]{((Object)indexs).toString().replaceAll("[^\\d|,]", "").replaceAll(",", "\uff0c")}));
                return;
            }
            if (!StringUtils.equals((CharSequence)"saveapprove", (CharSequence)this.getOperateKey())) continue;
            List results = InvoiceUtils.checkOffsetTaxAmount((DynamicObject)dynamicObject, (InvoiceUtils.BillEntityType)InvoiceUtils.BillEntityType.DailyReimburse);
            for (String result : results) {
                this.addErrorMessage(dataEntity, result);
            }
        }
    }
}

