/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;

public class SameCurrencySubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (ErStdConfig.getBoolean((String)"tripCurrencyExrate.noControl")) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String entryKey;
            DynamicObject dobj = dataEntity.getDataEntity();
            DataEntityPropertyCollection properties = dobj.getDynamicObjectType().getProperties();
            String currenyKey = null;
            String exchangeKey = null;
            DynamicObjectCollection collection = new DynamicObjectCollection();
            if (properties.containsKey((Object)"tripentry")) {
                currenyKey = "tripcurrency";
                exchangeKey = "tripexchangerate";
                entryKey = "tripentry";
                DataEntityPropertyCollection subProperties = ((EntryProp)properties.get((Object)entryKey)).getDynamicCollectionItemPropertyType().getProperties();
                if (subProperties.containsKey((Object)"entryentity") && ErEntityTypeUtils.isTripReimburseBill((String)dobj.getDynamicObjectType().getName())) {
                    currenyKey = "entrycurrency";
                    exchangeKey = "exchangerate";
                    for (int i = 0; i < dobj.getDynamicObjectCollection(entryKey).size(); ++i) {
                        DynamicObjectCollection subCollection = ((DynamicObject)dobj.getDynamicObjectCollection(entryKey).get(i)).getDynamicObjectCollection("entryentity");
                        collection.addAll((Collection)subCollection);
                    }
                } else {
                    collection = dobj.getDynamicObjectCollection(entryKey);
                }
            } else if (properties.containsKey((Object)"expenseentryentity")) {
                currenyKey = "entrycurrency";
                exchangeKey = "exchangerate";
                entryKey = "expenseentryentity";
                collection = dobj.getDynamicObjectCollection(entryKey);
            }
            Multimap<Object, BigDecimal> multimap = this.validatorEntryCurrencyCollection(currenyKey, exchangeKey, collection);
            if (properties.containsKey((Object)"accountentry")) {
                currenyKey = "accountcurrency";
                exchangeKey = "accexchangerate";
                entryKey = "accountentry";
                DynamicObjectCollection accCollection = dobj.getDynamicObjectCollection(entryKey);
                Multimap<Object, BigDecimal> accMultimap = this.validatorEntryCurrencyCollection(currenyKey, exchangeKey, accCollection);
                multimap.putAll(accMultimap);
            }
            this.showErrorMessage(dataEntity, multimap);
        }
    }

    private Multimap<Object, BigDecimal> validatorEntryCurrencyCollection(String currenyKey, String exchangeKey, DynamicObjectCollection collection) {
        Iterator iterator = collection.iterator();
        ArrayListMultimap multimap = ArrayListMultimap.create();
        while (iterator.hasNext()) {
            DynamicObject next = (DynamicObject)iterator.next();
            DynamicObject currency = next.getDynamicObject(currenyKey);
            BigDecimal exchangeRate = next.getBigDecimal(exchangeKey);
            if (currency == null) continue;
            multimap.put((Object)ErCommonUtils.getPk((Object)currency), (Object)exchangeRate);
        }
        return multimap;
    }

    private void showErrorMessage(ExtendedDataEntity dataEntity, Multimap<Object, BigDecimal> multimap) {
        multimap.keySet().forEach(v -> {
            Collection coll = multimap.get(v);
            if (coll.size() > 1) {
                Iterator it = coll.iterator();
                BigDecimal temp = (BigDecimal)coll.stream().findFirst().get();
                while (it.hasNext()) {
                    if (temp.compareTo((BigDecimal)it.next()) == 0) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u79cd\u5e01\u79cd\u8bf7\u5f55\u5165\u76f8\u540c\u6c47\u7387\u3002", (String)"SameCurrencySubmitValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    break;
                }
            }
        });
    }
}

