/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class TrialOrgSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashMap<String, String> functionStyleMap = new HashMap<String, String>();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String dbTrialStyle;
            DynamicObject data = dataEntity.getDataEntity();
            String function = data.getString("function");
            String trialstyle = data.getString("trialstyle");
            if (function == null || trialstyle == null) continue;
            if (!functionStyleMap.containsKey(function)) {
                functionStyleMap.put(function, trialstyle);
            } else {
                Object lastTrialstyle = functionStyleMap.get(function);
                if (!lastTrialstyle.equals(trialstyle)) {
                    ComboProp trialstyleCombo = (ComboProp)data.getDynamicObjectType().getProperty("trialstyle");
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\uff0c\u5bfc\u5165\u8bbe\u7f6e\u65b9\u5f0f\u51b2\u7a81\u3002", (String)"TrialOrgSaveValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]), trialstyleCombo.getItemByName(trialstyle)));
                }
            }
            QFilter qA = new QFilter("function", "=", (Object)function);
            qA.and("id", "!=", data.getPkValue());
            QFilter[] qFilters = new QFilter[]{qA};
            DynamicObject trial = BusinessDataServiceHelper.loadSingleFromCache((String)"er_trialorg", (String)"function, trialstyle, entryentity.trialorg", (QFilter[])qFilters);
            if (trial == null || trialstyle.equalsIgnoreCase(dbTrialStyle = trial.getString("trialstyle"))) continue;
            DynamicObjectCollection trialEntry = trial.getDynamicObjectCollection("entryentity");
            String trialorgName = ((DynamicObject)trialEntry.get(0)).getDynamicObject("trialorg").getString("name");
            ComboProp functionCombo = (ComboProp)data.getDynamicObjectType().getProperty("function");
            ComboProp trialstyleCombo = (ComboProp)data.getDynamicObjectType().getProperty("trialstyle");
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5df2\u5728%2$s\u8bbe\u7f6e\u4e3a%3$s\uff0c\u5f53\u524d\u8bbe\u7f6e\u4e3a%4$s\uff0c\u8bbe\u7f6e\u65b9\u5f0f\u51b2\u7a81\u3002", (String)"TrialOrgSaveValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]), functionCombo.getItemByName(function.toString()), trialorgName, trialstyleCombo.getItemByName(dbTrialStyle), trialstyleCombo.getItemByName(trialstyle)));
        }
    }
}

