/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.constant.ErTripExpenseItemConstant;
import org.apache.commons.lang3.StringUtils;

public class TripDateControlValidator
extends AbstractValidator {
    private static Log logger = LogFactory.getLog(TripDateControlValidator.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("company");
        fieldKeys.add("istravelers");
        fieldKeys.add("isopentripstd");
        fieldKeys.add("billkind");
        fieldKeys.add("expenseitem");
        fieldKeys.add("startdate");
        fieldKeys.add("enddate");
        fieldKeys.add("trip2startdate");
        fieldKeys.add("trip2enddate");
        fieldKeys.add("caldaycount");
        fieldKeys.add("tripentry.seq");
        fieldKeys.add("tripentry.entryentity.seq");
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObjectCollection detailEntry;
            Map<String, List<DynamicObject>> itemsRowMap;
            List collect;
            DynamicObject bill = dataEntity.getDataEntity();
            String billKind = bill.getString("billkind");
            DynamicObjectCollection tripEntry = bill.getDynamicObjectCollection("tripentry");
            String errMsg = "";
            Long companyId = ErCommonUtils.getPk((Object)bill.getDynamicObject("company"));
            if (!SystemParamterUtil.isOpenTripDateControl((Long)companyId) || bill.getBoolean("istravelers") && !bill.getBoolean("travelerssamestd") || !SystemParamterUtil.isEnableTripStandard((Long)companyId)) {
                return;
            }
            switch (billKind) {
                case "0": {
                    errMsg = this.validRowDate((Collection<DynamicObject>)tripEntry, billKind);
                    break;
                }
                case "1": {
                    DynamicObjectCollection detailEntry2 = ((DynamicObject)tripEntry.get(0)).getDynamicObjectCollection("entryentity");
                    Map<Long, List<DynamicObject>> itemsRowMap2 = IntStream.range(0, detailEntry2.size()).mapToObj(idx -> {
                        DynamicObject row = (DynamicObject)detailEntry2.get(idx);
                        row.set("seq", (Object)(idx + 1));
                        return row;
                    }).filter(v -> v.getDynamicObject("expenseitem") != null && StringUtils.equals((CharSequence)ErTripExpenseItemConstant.Attribute.Subsidy.getValue(), (CharSequence)v.getDynamicObject("expenseitem").getString("attribute")) && v.getDate("trip2startdate") != null && v.getDate("trip2enddate") != null).collect(Collectors.groupingBy(v -> v.getDynamicObject("expenseitem").getLong("id")));
                    itemsRowMap2 = itemsRowMap2.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((List)v.getValue()).stream().sorted(Comparator.comparing(row -> Integer.parseInt(row.getString("seq")))).collect(Collectors.toList())));
                    errMsg = itemsRowMap2.entrySet().stream().map(item -> this.validRowDate((Collection)item.getValue(), billKind)).filter(v -> !StringUtils.isBlank((CharSequence)v)).collect(Collectors.joining(","));
                }
            }
            if (!StringUtils.isEmpty((CharSequence)errMsg)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5df2\u5f00\u542f\u201c\u884c\u7a0b\u671f\u95f4\u63a7\u5236\u201d\u7cfb\u7edf\u53c2\u6570\u3002\u7b2c%2$s\u884c\u4e0e\u4e4b\u524d\u7684\u884c\u7a0b\u65e5\u671f\u6709\u51b2\u7a81\uff0c\u8bf7\u91cd\u65b0\u8c03\u6574\u884c\u7a0b\u7684\u884c\u7a0b\u65e5\u671f\u3002", (String)"TripDateControlValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]), bill.getDynamicObject("company").getString("name"), errMsg));
            }
            if (!"true".equals(ErStdConfig.get((String)"tripreimbill_period_confliction_check")) || !"1".equals(billKind) || (collect = (itemsRowMap = IntStream.range(0, (detailEntry = ((DynamicObject)tripEntry.get(0)).getDynamicObjectCollection("entryentity")).size()).mapToObj(idx -> {
                DynamicObject row = (DynamicObject)detailEntry.get(idx);
                row.set("seq", (Object)(idx + 1));
                return row;
            }).filter(v -> v.getDynamicObject("expenseitem") != null && StringUtils.equals((CharSequence)ErTripExpenseItemConstant.Attribute.Accommodation.getValue(), (CharSequence)v.getDynamicObject("expenseitem").getString("attribute")) && v.getDate("trip2startdate") != null && v.getDate("trip2enddate") != null).collect(Collectors.groupingBy(v -> String.join((CharSequence)",", v.getDynamicObjectCollection("trip2travelers").stream().sorted((o1, o2) -> (Long)o1.get("fbasedataid_id") - (Long)o2.get("fbasedataid_id") > 0L ? 1 : 0).map(it -> String.valueOf(it.get("fbasedataid_id"))).collect(Collectors.toSet()))))).entrySet().stream().filter(it -> ((List)it.getValue()).size() > 1).map(it -> {
                List itemList = ((List)it.getValue()).stream().sorted(Comparator.comparingInt(o -> o.getInt("seq"))).collect(Collectors.toList());
                HashSet<String> res = new HashSet<String>();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                for (int i = 0; i < itemList.size(); ++i) {
                    DynamicObject dynamic = (DynamicObject)itemList.get(i);
                    try {
                        Date startdate = sdf.parse(sdf.format(dynamic.getDate("trip2startdate")));
                        Date enddate = sdf.parse(sdf.format(dynamic.getDate("trip2enddate")));
                        for (int j = i + 1; j < itemList.size(); ++j) {
                            DynamicObject dynamicObject = (DynamicObject)itemList.get(j);
                            Date startdateIn = sdf.parse(sdf.format(dynamicObject.getDate("trip2startdate")));
                            Date enddateIn = sdf.parse(sdf.format(dynamicObject.getDate("trip2enddate")));
                            if (startdateIn.compareTo(enddate) >= 0 || enddateIn.compareTo(startdate) <= 0) continue;
                            res.add(dynamicObject.getString("seq"));
                        }
                        continue;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                        logger.error((Throwable)e);
                    }
                }
                return String.join((CharSequence)",", res);
            }).filter(it -> !"".equals(it)).collect(Collectors.toList())).size() <= 0) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u4e0e\u524d\u5e8f\u884c\u7a0b\u65e5\u671f\u6709\u51b2\u7a81\uff0c\u8bf7\u68c0\u67e5\u5e76\u8c03\u6574\u884c\u7a0b\u65e5\u671f\u6216\u51fa\u5dee\u4eba\u3002", (String)"TripDateControlValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", collect)));
        }
    }

    private String validRowDate(Collection<DynamicObject> row, String billKind) {
        List seqList;
        if (row.size() == 0) {
            return "";
        }
        String startDate = StringUtils.equals((CharSequence)"0", (CharSequence)billKind) ? "startdate" : "trip2startdate";
        String endDate = StringUtils.equals((CharSequence)"0", (CharSequence)billKind) ? "enddate" : "trip2enddate";
        List startDates = row.stream().map(v -> v.getDate(startDate)).skip(1L).collect(Collectors.toList());
        List endDates = row.stream().map(v -> v.getDate(endDate)).limit(row.size() - 1).collect(Collectors.toList());
        List list = seqList = StringUtils.equals((CharSequence)"0", (CharSequence)billKind) ? IntStream.range(1, row.size()).mapToObj(idx -> String.valueOf(idx)).collect(Collectors.toList()) : row.stream().map(v -> v.getString("seq")).skip(1L).collect(Collectors.toList());
        if (startDates.isEmpty() && endDates.isEmpty()) {
            return "";
        }
        return IntStream.range(0, startDates.size()).mapToObj(index -> {
            if (((Date)startDates.get(index)).getTime() < ((Date)endDates.get(index)).getTime()) {
                return (String)seqList.get(index);
            }
            return null;
        }).filter(v -> v != null).map(it -> StringUtils.equals((CharSequence)"0", (CharSequence)billKind) ? String.valueOf(Integer.parseInt(it) + 1) : it).collect(Collectors.joining(","));
    }
}

