/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripNotReimbursedOrderUtil;

public class TripNoReimburseOrderValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            List nos;
            QFilter qFilter;
            DynamicObjectCollection bills;
            DynamicObjectCollection writeoffapplys;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            Map sourceBillMap = BFTrackerServiceHelper.findSourceBills((String)"er_tripreimbursebill", (Long[])new Long[]{Long.parseLong(dynamicObject.getPkValue().toString())});
            if (sourceBillMap == null || sourceBillMap.isEmpty()) {
                return;
            }
            HashSet reqBillIds = new HashSet();
            if (null != sourceBillMap.get("er_tripreqbill")) {
                reqBillIds.addAll((Collection)sourceBillMap.get("er_tripreqbill"));
            }
            if (null != (writeoffapplys = dynamicObject.getDynamicObjectCollection("writeoffapply")) && null != (bills = QueryServiceHelper.query((String)"er_tripreqbill", (String)"id", (QFilter[])new QFilter[]{qFilter = new QFilter("billno", "in", nos = writeoffapplys.stream().map(w -> w.getString("applybillno")).collect(Collectors.toList()))}))) {
                reqBillIds.addAll(bills.stream().map(b -> b.getLong("id")).collect(Collectors.toList()));
            }
            if (reqBillIds == null || reqBillIds.isEmpty()) {
                return;
            }
            String orderWarningStr = TripNotReimbursedOrderUtil.getNotUsedOrderWarningStrByReq(new ArrayList(reqBillIds));
            if (null == orderWarningStr || orderWarningStr.isEmpty()) {
                return;
            }
            this.addMessage(dataEntity, ResManager.loadKDString((String)orderWarningStr, (String)"TripNoReimburseOrderValidator_01", (String)"TripNoReimburseOrderValidator_0", (Object[])new Object[0]));
        }
    }
}

