/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.utils.AmountUtils;

public class TripReimburseLoanValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity entity : this.getDataEntities()) {
            this.validateLoanEntry(entity);
        }
    }

    public void validateLoanEntry(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObjectCollection loanClearEntry = dynamicObject.getDynamicObjectCollection("clearloanentry");
        if (loanClearEntry != null && loanClearEntry.size() > 0) {
            for (DynamicObject entry : loanClearEntry) {
                BigDecimal loanoribalanceamount = entry.getBigDecimal("loanoribalanceamount");
                BigDecimal loanclearoriamount = entry.getBigDecimal("loanclearoriamount");
                if (loanclearoriamount.compareTo(loanoribalanceamount) <= 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51b2\u9500\u91d1\u989d\u4e0d\u5f97\u8d85\u8fc7\u501f\u6b3e\u4f59\u989d\u3002", (String)"TripReimburseLoanValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            DynamicObjectCollection trips = dynamicObject.getDynamicObjectCollection("tripentry");
            HashMap<String, String> currencyMap = new HashMap<String, String>();
            DynamicObjectCollection loans = dynamicObject.getDynamicObjectCollection("clearloanentry");
            for (DynamicObject loan : loans) {
                DynamicObject loancurrencyObj = loan.getDynamicObject("loancurrency");
                if (loancurrencyObj == null) continue;
                String currencyid = loancurrencyObj.getString("id");
                currencyMap.put(currencyid, loancurrencyObj.getLocaleString("name").getLocaleValue());
            }
            String loanchecktype = dynamicObject.getString("loanchecktype");
            if (loanchecktype != null && "1".equals(loanchecktype)) {
                Map entryCurrencyAmount = AmountUtils.groupByCurrency((DynamicObjectCollection)trips, (String)"entryentity", (String)"entrycurrency", (String)"orientryappamount");
                Map loanCurrencAmount = AmountUtils.groupByCurrency((DynamicObjectCollection)loans, (String)"loancurrency", (String)"loanclearoriamount");
                for (Map.Entry entry : loanCurrencAmount.entrySet()) {
                    String currency = (String)entry.getKey();
                    BigDecimal amount = (BigDecimal)loanCurrencAmount.get(currency);
                    if (amount == null || amount.compareTo(BigDecimal.ZERO) == 0) continue;
                    if (entryCurrencyAmount.get(currency) == null) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5dee\u65c5\u660e\u7ec6\u4e2d\u672a\u62a5\u9500\u201c%s\u201d\uff0c\u65e0\u6cd5\u51b2\u9500\u3002", (String)"TripReimburseLoanValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]), currencyMap.get(currency)));
                        continue;
                    }
                    if (amount.compareTo((BigDecimal)entryCurrencyAmount.get(currency)) <= 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5e01\u79cd%s\u603b\u51b2\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u8be5\u5e01\u79cd\u603b\u62a5\u9500\u91d1\u989d\u3002", (String)"TripReimburseLoanValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]), currencyMap.get(currency)));
                }
            } else {
                BigDecimal approveAmount = dynamicObject.getBigDecimal("approveamount");
                BigDecimal monthsettleAmount = dynamicObject.getBigDecimal("monthsettleamount");
                approveAmount = approveAmount.subtract(monthsettleAmount);
                BigDecimal checkLoanAmount = this.getCheckLoanAmount(dynamicObject);
                if (checkLoanAmount.compareTo(approveAmount) > 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51b2\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u62a5\u9500\u91d1\u989d\u3002", (String)"TripReimburseLoanValidator_6", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private BigDecimal getCheckLoanAmount(DynamicObject reimburseBill) {
        BigDecimal checkloanamount = BigDecimal.ZERO;
        DynamicObjectCollection clearloanentrys = reimburseBill.getDynamicObjectCollection("clearloanentry");
        if (clearloanentrys.size() > 0) {
            for (DynamicObject entry : clearloanentrys) {
                BigDecimal loanclearoriamount = entry.getBigDecimal("loanclearamount");
                checkloanamount = checkloanamount.add(loanclearoriamount);
            }
        }
        return checkloanamount;
    }
}

