/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.amount.control;

import java.time.LocalDate;
import java.time.Month;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.service.ReimburseAmountControlService;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ReimburseControlUtils;

@Deprecated
public class AllowOverYearReimburesValidate
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(AllowOverYearReimburesValidate.class);

    public void validate() {
        block0: for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            log.info(String.format("\u8d39\u7528\u62a5\u9500\u5355\u63d0\u4ea4\u65f6, \u8fdb\u884c\u8d39\u7528\u53d1\u751f\u65e5\u671f\u662f\u5426\u5141\u8bb8\u8de8\u5e74\u6821\u9a8c:%s", SerializationUtils.toJsonString((Object)dataEntity)));
            DynamicObject parameterSettingCompanyDO = ReimburseControlUtils.getParameterSettingCompany((DynamicObject)dataEntity);
            Long parameterSettingCompanyId = ErCommonUtils.getPk((Object)parameterSettingCompanyDO);
            boolean allowOverYear = ReimburseControlUtils.isAllowPreviousYear((Long)parameterSettingCompanyId);
            Month maxMonth = ReimburseControlUtils.deadlineMonthOfAllowPreviousYes((Long)parameterSettingCompanyId);
            DynamicObjectCollection expenseEntrys = dataEntity.getDynamicObjectCollection("expenseentryentity");
            for (DynamicObject expenseEntry : expenseEntrys) {
                LocalDate happenDate = ErCommonUtils.getLocalDateFromDate((Date)expenseEntry.getDate("happendate"));
                LocalDate currentLocalDate = ReimburseControlUtils.currentLocalDate();
                if (happenDate == null) {
                    return;
                }
                DynamicObject expenseItemDO = expenseEntry.getDynamicObject("expenseitem");
                if (Objects.isNull(expenseItemDO)) {
                    return;
                }
                Long expenseItemId = (Long)expenseItemDO.getPkValue();
                boolean isReimburseControl = ReimburseAmountControlService.isReimburseLimitControlByExpensenItem((Long)parameterSettingCompanyId, (Long)expenseItemId);
                if (!isReimburseControl) continue;
                if (!allowOverYear && happenDate.getYear() < currentLocalDate.getYear()) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u989d\u5ea6\u4e0d\u5141\u8bb8\u8de8\u5e74\u62a5\u9500\uff0c\u8bf7\u4fee\u6539\u8d39\u7528\u53d1\u751f\u65e5\u671f\u3002", (String)"AllowOverYearReimburesValidate_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    continue block0;
                }
                if (allowOverYear && happenDate.getYear() == currentLocalDate.getYear() - 1 && currentLocalDate.getMonthValue() > maxMonth.getValue()) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5728\u622a\u6b62\u6708\u4efd\uff08%d\u6708\uff09\u540e\u62a5\u9500\u8de8\u5e74\u989d\u5ea6\uff0c\u8bf7\u4fee\u6539\u8d39\u7528\u53d1\u751f\u65e5\u671f\u3002", (String)"AllowOverYearReimburesValidate_1", (String)"fi-er-opplugin", (Object[])new Object[0]), maxMonth.getValue()));
                    continue block0;
                }
                if (happenDate.getYear() > currentLocalDate.getYear() - 2) continue;
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8d39\u7528\u53d1\u751f\u65e5\u671f\u5728\u4e24\u5e74\u524d, \u4e0d\u5141\u8bb8\u62a5\u9500, \u8bf7\u4fee\u6539\u8d39\u7528\u53d1\u751f\u65e5\u671f\u3002", (String)"AllowOverYearReimburesValidate_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue block0;
            }
        }
    }
}

