/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.amount.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.entity.validate.ScopeValidator;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class AmounRangeValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(AmounRangeValidator.class);
    private static final String MAX_AMOUNT = "9999999999999.999999999999";

    public void validate() {
        long s1 = System.currentTimeMillis();
        MainEntityType subMainType = this.validateContext.getSubEntityType();
        List<AbstractValidator> requiredValidators = this.buildFieldDefaultValidators((IDataEntityType)subMainType);
        for (AbstractValidator v : requiredValidators) {
            AmounRangeValidator.setValidateContext(this.getValidateContext(), v);
            if (v.getDataEntities() == null || v.getDataEntities().length == 0) continue;
            v.validate();
            ValidateResult res = v.getValidateResult();
            if (res.isSuccess()) continue;
            for (OperateErrorInfo operateInfo : res.getAllErrorInfo()) {
                this.validateResult.addErrorInfo(operateInfo);
            }
            this.validateResult.addPromptField(res.getPromptField());
            res.getPromptField().clear();
        }
    }

    static void setValidateContext(ValidateContext validateContext, AbstractValidator validator) {
        ExtendedDataEntitySet entitySet = validateContext.getExtendedDataEntitySet();
        validator.setValidateContext(validateContext);
        validator.setExtendedDataEntitySet(entitySet);
        validator.initializeConfiguration();
        if (StringUtils.isBlank((CharSequence)validator.getEntityKey())) {
            return;
        }
        ExtendedDataEntity[] array = entitySet.FindByEntityKey(validator.getEntityKey());
        if (array == null || array.length == 0) {
            return;
        }
        validator.setDataEntities(array);
        validator.initialize();
    }

    private List<AbstractValidator> buildFieldDefaultValidators(IDataEntityType entityType) {
        ArrayList<AbstractValidator> defaultValidators = new ArrayList<AbstractValidator>();
        for (IDataEntityProperty prop : entityType.getProperties()) {
            IValidatorHanlder validatorHanlder;
            if (prop instanceof IValidatorHanlder && (validatorHanlder = (IValidatorHanlder)prop).getCompareProp() instanceof AmountProp) {
                AmountProp amountProp = (AmountProp)validatorHanlder.getCompareProp();
                if (null == amountProp.getDataScope() || amountProp.getDataScope().trim().isEmpty()) {
                    amountProp.setMax(new BigDecimal(MAX_AMOUNT));
                    amountProp.setMin(new BigDecimal("-9999999999999.999999999999"));
                    amountProp.setDataScope("[-9999999999999.999999999999,9999999999999.999999999999]");
                }
                ScopeValidator scopeValidator = new ScopeValidator(validatorHanlder.getCompareProp(), prop.getName(), "");
                scopeValidator.setEntityKey(entityType.getName());
                scopeValidator.setOperateKey(this.validateContext.getOperateKey());
                scopeValidator.setOperateType(this.validateContext.getOperateType());
                scopeValidator.setOperationName(this.validateContext.getOperateName());
                scopeValidator.setValidation(this.getValidation());
                scopeValidator.setErrorLevel(this.getErrorLevl());
                defaultValidators.add((AbstractValidator)scopeValidator);
            }
            if (!(prop instanceof EntryProp)) continue;
            IDataEntityType refItemType = ((ICollectionProperty)prop).getItemType();
            defaultValidators.addAll(this.buildFieldDefaultValidators(refItemType));
        }
        return defaultValidators;
    }
}

