/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.amount.control;

import java.time.LocalDate;
import java.time.Month;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.daily.service.ReimburseAmountControlService;
import kd.fi.er.business.daily.service.model.ReimburseAmountControlResultBO;
import kd.fi.er.business.expand.ErExpandServiceFacade;
import kd.fi.er.business.reimamountctl.utils.TripReimQuotaValidate;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class TripReimAmountControlValidate
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(TripReimAmountControlValidate.class);

    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            List validMsgs;
            Object invokeExtService;
            String billEntityType;
            Long parameterSettingCompanyId;
            boolean isControl;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject parameterSettingCompanyDO = ReimburseControlUtils.getParameterSettingCompany((DynamicObject)dataEntity);
            if (parameterSettingCompanyDO == null || !(isControl = SystemParamterUtil.isEnableReimburseControlByCompany((Long)(parameterSettingCompanyId = ErCommonUtils.getPk((Object)parameterSettingCompanyDO))))) continue;
            String ctrlCompanyName = ReimburseControlUtils.getPersonReimCtlCompanyField();
            if (dataEntity.getDynamicObjectType().getProperties().get((Object)ctrlCompanyName) != null && dataEntity.get(ctrlCompanyName) == null) {
                String reimCompanyAlias = ((IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)ctrlCompanyName)).getDisplayName().getLocaleValue();
                this.addFatalErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"%s\u4e0d\u80fd\u4e3a\u7a7a", (String)"TripReimAmountControlValidate_0", (String)"fi-er-opplugin", (Object[])new Object[0]), reimCompanyAlias));
                continue;
            }
            List empCltList = SystemParamterUtil.getEmpCltBillList((Long)parameterSettingCompanyId);
            List deptCltList = SystemParamterUtil.getDeptCltBillList((Long)parameterSettingCompanyId);
            boolean allowOverYear = ReimburseControlUtils.isAllowPreviousYear((Long)parameterSettingCompanyId);
            Month maxMonth = ReimburseControlUtils.deadlineMonthOfAllowPreviousYes((Long)parameterSettingCompanyId);
            DynamicObjectCollection tripEntrys = dataEntity.getDynamicObjectCollection("tripentry");
            if (tripEntrys == null || tripEntrys.size() <= 0) continue;
            boolean iscontinueValidate = true;
            block1: for (int i = 0; i < tripEntrys.size(); ++i) {
                DynamicObject tripEntry = (DynamicObject)tripEntrys.get(i);
                DynamicObjectCollection entryEntrys = tripEntry.getDynamicObjectCollection("entryentity");
                if (entryEntrys == null || entryEntrys.size() <= 0) continue;
                for (int j = 0; j < entryEntrys.size(); ++j) {
                    DynamicObject entry = (DynamicObject)entryEntrys.get(j);
                    DynamicObject entryExpenseitem = entry.getDynamicObject("travelexpenseitem");
                    if (entryExpenseitem == null) {
                        iscontinueValidate = false;
                        continue;
                    }
                    String isreimburseamountctl = entryExpenseitem.getString("isreimburseamountctl");
                    if ("0".equals(isreimburseamountctl) || "3".equals(isreimburseamountctl)) continue;
                    DynamicObjectCollection travelers = entry.getDynamicObjectCollection("trip2travelers");
                    if ("1".equals(isreimburseamountctl) && (travelers == null || travelers.size() != 1)) {
                        iscontinueValidate = false;
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u51fa\u5dee\u4eba\u7684\u4e2a\u4eba\u989d\u5ea6\u63a7\u5236\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5355\u4e2a\u51fa\u5dee\u4eba\u3002", (String)"TripReimAmountControlValidate_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue block1;
                    }
                    DynamicObject ctrlDept = entry.getDynamicObject("travelquotactldept");
                    if ("2".equals(isreimburseamountctl) && ctrlDept == null && deptCltList.contains("2")) {
                        iscontinueValidate = false;
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u90e8\u95e8\u989d\u5ea6\u63a7\u5236\u7684\u8d39\u7528\u9879\u76ee\uff0c\u989d\u5ea6\u63a7\u5236\u90e8\u95e8\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TripReimAmountControlValidate_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue block1;
                    }
                    if (!deptCltList.contains("2") && !empCltList.contains("2")) continue;
                    LocalDate happenDate = ErCommonUtils.getLocalDateFromDate((Date)entry.getDate("travelhappendate"));
                    if (happenDate == null) {
                        iscontinueValidate = false;
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8d39\u7528\u5f52\u5c5e\u6708\u4efd\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"TripReimAmountControlValidate_5", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue block1;
                    }
                    LocalDate currentLocalDate = ReimburseControlUtils.currentLocalDate();
                    if (!allowOverYear && happenDate.getYear() < currentLocalDate.getYear()) {
                        iscontinueValidate = false;
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u989d\u5ea6\u4e0d\u5141\u8bb8\u8de8\u5e74\u62a5\u9500\uff0c\u8bf7\u4fee\u6539\u8d39\u7528\u5f52\u5c5e\u6708\u4efd\u3002", (String)"TripReimAmountControlValidate_6", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue block1;
                    }
                    if (allowOverYear && happenDate.getYear() == currentLocalDate.getYear() - 1 && currentLocalDate.getMonthValue() > maxMonth.getValue()) {
                        iscontinueValidate = false;
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u5728\u622a\u6b62\u6708\u4efd\uff08%d\u6708\uff09\u540e\u62a5\u9500\u8de8\u5e74\u989d\u5ea6\uff0c\u8bf7\u4fee\u6539\u8d39\u7528\u5f52\u5c5e\u6708\u4efd\u3002", (String)"TripReimAmountControlValidate_7", (String)"fi-er-opplugin", (Object[])new Object[0]), maxMonth.getValue()));
                        continue block1;
                    }
                    if (happenDate.getYear() > currentLocalDate.getYear() - 2) continue;
                    iscontinueValidate = false;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8d39\u7528\u5f52\u5c5e\u6708\u4efd\u5728\u4e24\u5e74\u524d\uff0c\u4e0d\u5141\u8bb8\u62a5\u9500\uff0c\u8bf7\u4fee\u6539\u8d39\u7528\u5f52\u5c5e\u6708\u4efd\u3002", (String)"TripReimAmountControlValidate_8", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    continue block1;
                }
            }
            String tripEntityTypes = ErStdConfig.get((String)"trip.iscontinueValidate.entityType");
            if (tripEntityTypes != null && !"none".equals(tripEntityTypes) && tripEntityTypes.contains(billEntityType = dataEntity.getDataEntityType().getName()) && !"-1".equals(invokeExtService = ErExpandServiceFacade.get().invokeExtService("ext.service.er.amountControl", "amountControl", new Object[]{dataEntity}, new Class[]{DynamicObject.class})) && Boolean.FALSE.equals(invokeExtService)) {
                iscontinueValidate = false;
            }
            if (!iscontinueValidate || (validMsgs = TripReimQuotaValidate.validTripReimQuota((DynamicObject)dataEntity, (ExtendedDataEntity[])this.getDataEntities())) == null || validMsgs.isEmpty()) continue;
            ErrorLevel errorLevel = ErrorLevel.Error;
            String reimburseLimitControlType = ReimburseAmountControlService.getReimburseLimitControlType((Long)parameterSettingCompanyId);
            if ("3".equals(reimburseLimitControlType)) {
                errorLevel = ErrorLevel.Warning;
                if (ErStdConfig.quotaZeroIsCtrl() && validMsgs.contains(ReimburseAmountControlResultBO.getNoQuotaMsg())) {
                    errorLevel = ErrorLevel.Error;
                }
            }
            if (StringUtils.equalsIgnoreCase((CharSequence)"web", (CharSequence)RequestContext.get().getClient())) {
                ErrorLevel finalErrorLevel = errorLevel;
                validMsgs.forEach(e -> this.addMessage(extendedDataEntity, (String)e, finalErrorLevel));
                continue;
            }
            String msg = (String)validMsgs.get(0);
            if (msg.length() > 20) {
                msg = ResManager.loadKDString((String)"\u8d85\u989d\u5ea6\u6216\u8005\u8d85\u6b21\u6570\u62a5\u9500\u3002", (String)"TripReimAmountControlValidate_9", (String)"fi-er-opplugin", (Object[])new Object[0]);
            }
            this.addMessage(extendedDataEntity, msg, errorLevel);
        }
    }
}

