/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.invoicecloud.checkInvoice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.model.DetailExpenseModel;
import kd.fi.er.validator.invoicecloud.checkInvoice.AbstractCheckInvoiceValidator;
import org.apache.commons.lang3.StringUtils;

public class ReimSubmitCheckInvoiceValidator
extends AbstractCheckInvoiceValidator {
    private static final Log log = LogFactory.getLog(ReimSubmitCheckInvoiceValidator.class);

    @Override
    public InvoiceUtils.BillEntityType getEntityType() {
        return InvoiceUtils.BillEntityType.DailyReimburse;
    }

    @Override
    public List<DetailExpenseModel> getDetailExpenseEntry(DynamicObject bill, ExtendedDataEntity dataEntity) {
        DynamicObjectCollection expenseEntry = bill.getDynamicObjectCollection("expenseentryentity");
        ArrayList<DetailExpenseModel> models = new ArrayList<DetailExpenseModel>(expenseEntry.size());
        for (int rowIndex = 0; rowIndex < expenseEntry.size(); ++rowIndex) {
            DynamicObject dynamicObject = (DynamicObject)expenseEntry.get(rowIndex);
            DetailExpenseModel model = new DetailExpenseModel(dynamicObject, rowIndex, -1);
            models.add(model);
        }
        return models;
    }

    @Override
    public boolean checkReimAmount(DynamicObject detailExpense, DynamicObject billObject, ExtendedDataEntity dataEntity, int rowIndex, int parentIndex) {
        BigDecimal expeAmount = detailExpense.getBigDecimal("expenseamount");
        return expeAmount.compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    public boolean checkItem(DynamicObject detailExpense, DynamicObject billObject, ExtendedDataEntity dataEntity, int rowIndex, int parentIndex) {
        Boolean noInvoice;
        DynamicObject expense = detailExpense.getDynamicObject("expenseitem");
        if (expense == null) {
            return false;
        }
        DynamicProperty noInvoiceProp = expense.getDynamicObjectType().getProperty("noinvoice");
        return noInvoiceProp == null || (noInvoice = Boolean.valueOf(expense.getBoolean("noinvoice"))) == false;
    }

    @Override
    public void checkDetailCurrency(DynamicObject detailExpense, DynamicObject billObject, ExtendedDataEntity dataEntity, ErrorLevel errorLevel, int rowIndex, int parentIndex) {
        Long entryCurrency = ErCommonUtils.getPk((Object)detailExpense.getDynamicObject("entrycurrency"));
        boolean autoInvoice = billObject.getBoolean("automapinvoice");
        List invoiceInfo = autoInvoice ? InvoiceUtils.getAutoInvoiceInfoByItemId((DynamicObject)billObject, (Long)((Long)detailExpense.getPkValue())) : InvoiceUtils.getNonAutoInvoiceInfoByItemId((DynamicObject)billObject, (Long)((Long)detailExpense.getPkValue()));
        if (invoiceInfo == null || invoiceInfo.isEmpty()) {
            return;
        }
        Set invoiceCurrencySet = invoiceInfo.stream().map(invoiceEntry -> {
            DynamicObject invoiceCurrency = invoiceEntry.getDynamicObject("invoicecurrency");
            if (invoiceCurrency == null) {
                return 0L;
            }
            return (Long)invoiceCurrency.getPkValue();
        }).collect(Collectors.toSet());
        if (invoiceCurrencySet.size() != 1) {
            this.addCurrencyErrorMessage(dataEntity, billObject, errorLevel, rowIndex, parentIndex);
            return;
        }
        Long invoiceCurrencyId = (Long)invoiceCurrencySet.iterator().next();
        if (!Objects.equals(entryCurrency, invoiceCurrencyId)) {
            this.addCurrencyErrorMessage(dataEntity, billObject, errorLevel, rowIndex, parentIndex);
            return;
        }
    }

    @Override
    public boolean checkDetailExpenseInvoice(DynamicObject detailExpense, DynamicObject billObject, ExtendedDataEntity dataEntity, int rowIndex, int parentIndex) {
        String invoiceNo_entry;
        String itemFrom = detailExpense.getString("itemfrom");
        return !StringUtils.equalsIgnoreCase((CharSequence)ItemFrom.InvoiceCloud.getValue(), (CharSequence)itemFrom) && !StringUtils.equalsIgnoreCase((CharSequence)ItemFrom.Manual.getValue(), (CharSequence)itemFrom) && !StringUtils.equalsIgnoreCase((CharSequence)ItemFrom.EntryImport.getValue(), (CharSequence)itemFrom) || !StringUtils.isBlank((CharSequence)(invoiceNo_entry = detailExpense.getString("invoiceno_entry")));
    }

    @Override
    public void addErrorMessage(ExtendedDataEntity dataEntity, DynamicObject billObject, int rowIndex, int parentIndex) {
        String fmt = ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d39\u7528\u660e\u7ec6\u5206\u5f55\u9700\u8981\u5bfc\u5165\u53d1\u7968\u6216\u5173\u8054\u53d1\u7968\u3002", (String)"ReimSubmitCheckInvoiceValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]);
        this.addErrorMessage(dataEntity, String.format(fmt, rowIndex + 1));
    }

    @Override
    public void addCurrencyErrorMessage(ExtendedDataEntity dataEntity, DynamicObject billObject, ErrorLevel errorLevel, int rowIndex, int parentIndex) {
        String fmt = ResManager.loadKDString((String)"\u7b2c%s\u884c\u8d39\u7528\u660e\u7ec6\u5e01\u79cd\u4e0e\u53d1\u7968\u4fe1\u606f\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ReimSubmitCheckInvoiceValidator_3", (String)"fi-er-opplugin", (Object[])new Object[0]);
        this.addMessage(dataEntity, String.format(fmt, rowIndex + 1), errorLevel);
    }
}

