/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.invoicecloud.checkInvoice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.model.DetailExpenseModel;
import kd.fi.er.validator.invoicecloud.checkInvoice.AbstractCheckInvoiceValidator;
import org.apache.commons.lang3.StringUtils;

public class TripReimSubmitCheckInvoiceValidator
extends AbstractCheckInvoiceValidator {
    private static final Log log = LogFactory.getLog(TripReimSubmitCheckInvoiceValidator.class);

    @Override
    public InvoiceUtils.BillEntityType getEntityType() {
        return InvoiceUtils.BillEntityType.TripReimburse;
    }

    @Override
    public List<DetailExpenseModel> getDetailExpenseEntry(DynamicObject bill, ExtendedDataEntity dataEntity) {
        DynamicObjectCollection tripEntry = bill.getDynamicObjectCollection("tripentry");
        ArrayList<DetailExpenseModel> models = new ArrayList<DetailExpenseModel>();
        for (int parentIndex = 0; parentIndex < tripEntry.size(); ++parentIndex) {
            DynamicObjectCollection expenseEntry = ((DynamicObject)tripEntry.get(parentIndex)).getDynamicObjectCollection("entryentity");
            for (int rowIndex = 0; rowIndex < expenseEntry.size(); ++rowIndex) {
                DynamicObject dynamicObject = (DynamicObject)expenseEntry.get(rowIndex);
                DetailExpenseModel model = new DetailExpenseModel(dynamicObject, rowIndex, parentIndex);
                models.add(model);
            }
        }
        return models;
    }

    @Override
    public boolean checkReimAmount(DynamicObject detailExpense, DynamicObject billObject, ExtendedDataEntity dataEntity, int rowIndex, int parentIndex) {
        BigDecimal expeAmount = detailExpense.getBigDecimal("orientryamount");
        return expeAmount.compareTo(BigDecimal.ZERO) != 0;
    }

    @Override
    public boolean checkItem(DynamicObject detailExpense, DynamicObject billObject, ExtendedDataEntity dataEntity, int rowIndex, int parentIndex) {
        Boolean noInvoice;
        DynamicObject expense = detailExpense.getDynamicObject("expenseitem");
        if (expense == null) {
            return false;
        }
        DynamicProperty noInvoiceProp = expense.getDynamicObjectType().getProperty("noinvoice");
        return noInvoiceProp == null || (noInvoice = Boolean.valueOf(expense.getBoolean("noinvoice"))) == false;
    }

    @Override
    public void checkDetailCurrency(DynamicObject detailExpense, DynamicObject billObject, ExtendedDataEntity dataEntity, ErrorLevel errorLevel, int rowIndex, int parentIndex) {
        Long tripExpenseCurrency = ErCommonUtils.getPk((Object)detailExpense.getDynamicObject("entrycurrency"));
        boolean autoInvoice = billObject.getBoolean("automapinvoice");
        List invoiceInfo = autoInvoice ? InvoiceUtils.getAutoInvoiceInfoByItemId((DynamicObject)billObject, (Long)((Long)detailExpense.getPkValue())) : InvoiceUtils.getNonAutoInvoiceInfoByItemId((DynamicObject)billObject, (Long)((Long)detailExpense.getPkValue()));
        if (invoiceInfo == null || invoiceInfo.isEmpty()) {
            return;
        }
        Set invoiceCurrencySet = invoiceInfo.stream().map(invoiceEntry -> {
            DynamicObject invoiceCurrency = invoiceEntry.getDynamicObject("invoicecurrency");
            if (invoiceCurrency == null) {
                return 0L;
            }
            return (Long)invoiceCurrency.getPkValue();
        }).collect(Collectors.toSet());
        if (invoiceCurrencySet.size() != 1) {
            this.addCurrencyErrorMessage(dataEntity, billObject, errorLevel, rowIndex, parentIndex);
            return;
        }
        Long invoiceCurrencyId = (Long)invoiceCurrencySet.iterator().next();
        if (!Objects.equals(tripExpenseCurrency, invoiceCurrencyId)) {
            this.addCurrencyErrorMessage(dataEntity, billObject, errorLevel, rowIndex, parentIndex);
            return;
        }
    }

    @Override
    public boolean checkDetailExpenseInvoice(DynamicObject detailExpense, DynamicObject billObject, ExtendedDataEntity dataEntity, int rowIndex, int parentIndex) {
        String invoiceNo_entry;
        String itemFrom = detailExpense.getString("itemfrom");
        return !StringUtils.equalsIgnoreCase((CharSequence)ItemFrom.InvoiceCloud.getValue(), (CharSequence)itemFrom) && !StringUtils.equalsIgnoreCase((CharSequence)ItemFrom.Manual.getValue(), (CharSequence)itemFrom) && !StringUtils.equalsIgnoreCase((CharSequence)ItemFrom.EntryImport.getValue(), (CharSequence)itemFrom) || !StringUtils.isBlank((CharSequence)(invoiceNo_entry = detailExpense.getString("invoiceno_entry")));
    }

    @Override
    public void addErrorMessage(ExtendedDataEntity dataEntity, DynamicObject billObject, int rowIndex, int parentIndex) {
        String fmt = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5dee\u65c5\u660e\u7ec6\u9700\u8981\u5bfc\u5165\u53d1\u7968\u6216\u5173\u8054\u53d1\u7968\u3002", (String)"TripReimSubmitCheckInvoiceValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]), rowIndex + 1);
        String tripInfo = String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u884c\u7a0b", (String)"TripReimSubmitCheckInvoiceValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]), parentIndex + 1);
        fmt = tripInfo.concat("\uff0c").concat(fmt);
        this.addErrorMessage(dataEntity, String.format(fmt, rowIndex + 1));
    }

    @Override
    public void addCurrencyErrorMessage(ExtendedDataEntity dataEntity, DynamicObject billObject, ErrorLevel errorLevel, int rowIndex, int parentIndex) {
        String fmt = String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5dee\u65c5\u660e\u7ec6\u5e01\u79cd\u4e0e\u53d1\u7968\u4fe1\u606f\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TripReimSubmitCheckInvoiceValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]), rowIndex + 1);
        String tripInfo = String.format(ResManager.loadKDString((String)"\u7b2c%s\u6761\u884c\u7a0b", (String)"TripReimSubmitCheckInvoiceValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]), parentIndex + 1);
        fmt = tripInfo.concat("\uff0c").concat(fmt);
        this.addMessage(dataEntity, String.format(fmt, rowIndex + 1), errorLevel);
    }
}

