/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.invoicecloud.map;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class GoodCodeMappingItemUniqueValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(GoodCodeMappingItemUniqueValidator.class);
    private static final Map<String, String> INVOICE_FACTOR;

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities == null) {
            return;
        }
        boolean canSave = true;
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String invoiceType = dataEntity.getString("inv_invoicetype");
            DynamicObject TaxCode = dataEntity.getDynamicObject("inv_ratetype");
            DynamicObjectCollection invoiceOtherFactors = dataEntity.getDynamicObjectCollection("entryentity");
            Boolean isEmptyGoodName = invoiceOtherFactors == null || invoiceOtherFactors.isEmpty() || invoiceOtherFactors.stream().allMatch(entry -> StringUtils.isBlank((CharSequence)entry.getString("mapfactor")));
            Boolean isInvoiceFactorNull = StringUtils.isBlank((CharSequence)invoiceType) && TaxCode == null && isEmptyGoodName != false;
            List<String> billFactors = Arrays.asList("bill_org", "bill_applier", "bill_description", "relbilltype", "bill_bizitem", "bill_projecttype", "bill_reimbursetype");
            boolean isBillFactorNull = true;
            for (String k : billFactors) {
                Object val = dataEntity.get(k);
                if ((!(val instanceof String) || !StringUtils.isNotBlank((CharSequence)val.toString())) && (!(val instanceof DynamicObject) || val == null)) continue;
                isBillFactorNull = false;
            }
            if (!isInvoiceFactorNull.booleanValue() || !isBillFactorNull) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5355\u636e\u56e0\u7d20\u4e0e\u53d1\u7968\u56e0\u7d20\u81f3\u5c11\u9700\u8981\u5f55\u5165\u4e00\u9879\u3002", (String)"GoodCodeMappingItemUniqueValidator_4", (String)"fi-er-opplugin", (Object[])new Object[0]));
            canSave = false;
        }
        if (canSave) {
            if (this.checkRepeatInMemory(extendedDataEntities)) {
                return;
            }
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                this.update(extendedDataEntity);
            }
        }
    }

    private void update(ExtendedDataEntity extendedDataEntity) {
        DynamicObjectCollection relation;
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String invoiceType = dataEntity.getString("inv_invoicetype");
        DynamicObject TaxCode = dataEntity.getDynamicObject("inv_ratetype");
        DynamicObjectCollection invoiceOtherFactors = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList tipsList = Lists.newArrayList();
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)dataEntity.getDataEntityType().getName());
        Function mapMaker = field -> {
            List comboItems;
            ComboProp comboProp = (ComboProp)type.findProperty(field);
            if (null != comboProp && CollectionUtils.isNotEmpty((Collection)(comboItems = comboProp.getComboItems()))) {
                return comboItems.stream().collect(Collectors.toMap(vi -> vi.getValue(), vi -> vi.getName().getLocaleValue()));
            }
            return new HashMap();
        };
        Map invoiceTypeMap = (Map)mapMaker.apply((Object)"inv_invoicetype");
        Map billTypeMap = (Map)mapMaker.apply((Object)"relbilltype");
        Map reimburseTypeMap = (Map)mapMaker.apply((Object)"bill_reimbursetype");
        QFilter invoiceQF = new QFilter("inv_ratetype", "=", TaxCode == null ? Long.valueOf(0L) : TaxCode.getPkValue());
        if (TaxCode != null) {
            tipsList.add(String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"GoodCodeMappingItemUniqueValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]), TaxCode.get("number")));
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceType)) {
            invoiceQF.and("inv_invoicetype", "=", (Object)invoiceType);
            tipsList.add(String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b", (String)"GoodCodeMappingItemUniqueValidator_6", (String)"fi-er-opplugin", (Object[])new Object[0]), invoiceTypeMap.get(invoiceType)));
        } else {
            invoiceQF.and(this.strNotNull("inv_invoicetype"));
        }
        HashMap otherFactorMap = Maps.newHashMap();
        if (invoiceOtherFactors != null && !invoiceOtherFactors.isEmpty()) {
            ArrayList qf = Lists.newArrayList();
            for (DynamicObject goodName : invoiceOtherFactors) {
                QFilter goodQF = new QFilter("entryentity.invoicefactor", "=", (Object)goodName.getString("invoicefactor"));
                goodQF.and(new QFilter("entryentity.mapfactor", "=", (Object)goodName.getString("mapfactor")));
                goodQF.and(new QFilter("entryentity.inv_mappingtype", "=", (Object)goodName.getString("inv_mappingtype")));
                qf.add(goodQF);
                this.invoiceOtherFactor(goodName, otherFactorMap);
            }
            QFilter goodQF = (QFilter)qf.get(0);
            for (int i = 1; i < qf.size(); ++i) {
                goodQF.or((QFilter)qf.get(i));
            }
            invoiceQF.and(goodQF);
        } else {
            QFilter goodQF = this.strNotNull("entryentity.invoicefactor");
            goodQF.and(this.strNotNull("entryentity.mapfactor"));
            goodQF.and(this.strNotNull("entryentity.inv_mappingtype"));
            invoiceQF.and(goodQF);
        }
        DynamicObject applierdept = dataEntity.getDynamicObject("bill_org");
        DynamicObject applier = dataEntity.getDynamicObject("bill_applier");
        String description = dataEntity.getString("bill_description");
        DynamicObject bizItem = dataEntity.getDynamicObject("bill_bizitem");
        DynamicObject projectType = dataEntity.getDynamicObject("bill_projecttype");
        String reimburseType = dataEntity.getString("bill_reimbursetype");
        QFilter billQF = new QFilter("bill_org", "=", applierdept == null ? Long.valueOf(0L) : applierdept.getPkValue());
        if (applierdept != null) {
            tipsList.add(String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u90e8\u95e8", (String)"GoodCodeMappingItemUniqueValidator_7", (String)"fi-er-opplugin", (Object[])new Object[0]), applierdept.getString("name")));
        }
        billQF.and(new QFilter("bill_applier", "=", applier == null ? Long.valueOf(0L) : applier.getPkValue()));
        if (applier != null) {
            tipsList.add(String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u7533\u8bf7\u4eba", (String)"GoodCodeMappingItemUniqueValidator_8", (String)"fi-er-opplugin", (Object[])new Object[0]), applier.getString("name")));
        }
        billQF.and(new QFilter("bill_description", "=", (Object)description));
        if (StringUtils.isNotBlank((CharSequence)description)) {
            tipsList.add(String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u4e8b\u7531", (String)"GoodCodeMappingItemUniqueValidator_9", (String)"fi-er-opplugin", (Object[])new Object[0]), description));
        }
        billQF.and(new QFilter("bill_bizitem", "=", bizItem == null ? Long.valueOf(0L) : bizItem.getPkValue()));
        billQF.and(new QFilter("bill_projecttype", "=", projectType == null ? Long.valueOf(0L) : projectType.getPkValue()));
        if (StringUtils.isNotBlank((CharSequence)reimburseType)) {
            billQF.and(new QFilter("bill_reimbursetype", "=", (Object)reimburseType));
        }
        if (bizItem != null) {
            tipsList.add(String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u4e1a\u52a1\u4e8b\u9879", (String)"GoodCodeMappingItemUniqueValidator_16", (String)"fi-er-opplugin", (Object[])new Object[0]), bizItem.getString("name")));
        }
        if (projectType != null) {
            tipsList.add(String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u4e1a\u52a1\u5206\u7c7b", (String)"GoodCodeMappingItemUniqueValidator_17", (String)"fi-er-opplugin", (Object[])new Object[0]), projectType.getString("name")));
        }
        if (StringUtils.isNotBlank((CharSequence)reimburseType)) {
            tipsList.add(String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u62a5\u8d26\u7c7b\u578b", (String)"GoodCodeMappingItemUniqueValidator_18", (String)"fi-er-opplugin", (Object[])new Object[0]), reimburseTypeMap.get(reimburseType)));
        }
        DynamicObject createorg = dataEntity.getDynamicObject("createorg");
        Long createorgId = 0L;
        if (createorg != null) {
            createorgId = (Long)createorg.getPkValue();
        }
        String billtype = dataEntity.getString("billtype");
        QFilter otherQF = QFilter.of((String)"createorg = ? and billtype = ?", (Object[])new Object[]{createorgId, billtype});
        QFilter idQF = new QFilter("id", "!=", dataEntity.getPkValue());
        String relbilltype = dataEntity.getString("relbilltype");
        QFilter reBillTypeQF = new QFilter("relbilltype", "=", (Object)(StringUtils.isBlank((CharSequence)relbilltype) ? " " : relbilltype));
        if (StringUtils.isNotBlank((CharSequence)relbilltype)) {
            tipsList.add(String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"GoodCodeMappingItemUniqueValidator_10", (String)"fi-er-opplugin", (Object[])new Object[0]), billTypeMap.get(relbilltype)));
        }
        if ((relation = QueryServiceHelper.query((String)"er_rel_expense_ratetype", (String)"id", (QFilter[])new QFilter[]{invoiceQF, billQF, otherQF, idQF, reBillTypeQF})) == null || relation.size() == 0) {
            return;
        }
        DynamicObject[] relationOtherFactors = BusinessDataServiceHelper.load((String)"er_rel_expense_ratetype", (String)"id,entryentity.invoicefactor,entryentity.mapfactor,entryentity.inv_mappingtype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)relation.stream().map(v -> v.getLong("id")).toArray())});
        boolean isRepeat = false;
        if (relationOtherFactors != null && relationOtherFactors.length > 0) {
            HashMap otherFactor4DataBaseMap = Maps.newHashMap();
            for (DynamicObject data : relationOtherFactors) {
                DynamicObjectCollection otherFacterEntity = data.getDynamicObjectCollection("entryentity");
                if (otherFacterEntity.isEmpty() && invoiceOtherFactors.isEmpty()) {
                    isRepeat = true;
                }
                for (DynamicObject otherFacter : otherFacterEntity) {
                    this.invoiceOtherFactor(otherFacter, otherFactor4DataBaseMap);
                }
                ArrayList list = Lists.newArrayList();
                this.isRepeat(otherFactorMap.entrySet().iterator(), otherFactor4DataBaseMap.entrySet().iterator(), list);
                if (list.isEmpty()) continue;
                isRepeat = true;
                tipsList.addAll(list);
            }
        } else {
            isRepeat = true;
        }
        log.info("\u67e5\u91cd\u6761\u4ef6\uff1a" + invoiceQF + "\uff0c " + billQF + "\uff0c" + otherQF + "\uff0c\u67e5\u91cd\u7ed3\u679c\uff1a" + relation);
        if (isRepeat) {
            String tips = StringUtils.join((Iterable)tipsList, (String)"\uff0c");
            tips = String.format(ResManager.loadKDString((String)"%s\uff0c\u7ec4\u5408\u7ef4\u5ea6\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"GoodCodeMappingItemUniqueValidator_12", (String)"fi-er-opplugin", (Object[])new Object[0]), tips);
            this.addErrorMessage(extendedDataEntity, tips);
        }
    }

    private boolean checkRepeatInMemory(ExtendedDataEntity[] dataEntities) {
        HashMap<String, List<ExtendedDataEntity>> groups = new HashMap<String, List<ExtendedDataEntity>>();
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            this.chekBillHeadFactor(groups, extendedDataEntity);
        }
        HashMap<String, List<ExtendedDataEntity>> repeatItems = new HashMap<String, List<ExtendedDataEntity>>(groups.size());
        for (Map.Entry entry : groups.entrySet()) {
            String key = (String)entry.getKey();
            if (entry.getValue() == null || ((List)entry.getValue()).size() <= 1) continue;
            this.checkInvoiceInfoEntry(key, groups, repeatItems);
        }
        return this.addRepeatMemory(repeatItems);
    }

    private void checkInvoiceInfoEntry(String key, Map<String, List<ExtendedDataEntity>> groups, Map<String, List<ExtendedDataEntity>> repeatItems) {
        List<ExtendedDataEntity> dataEntities = groups.get(key);
        HashMap<String, List<ExtendedDataEntity>> entryGroups = new HashMap<String, List<ExtendedDataEntity>>();
        for (ExtendedDataEntity extendedDataEntity : dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection invoiceOtherFactors = dataEntity.getDynamicObjectCollection("entryentity");
            if (invoiceOtherFactors == null || invoiceOtherFactors.isEmpty()) continue;
            for (DynamicObject goodName : invoiceOtherFactors) {
                this.checkInvoiceFactor(goodName, entryGroups, extendedDataEntity);
            }
        }
        for (Map.Entry entry : entryGroups.entrySet()) {
            List items = (List)entry.getValue();
            if (items == null || items.size() <= 1) continue;
            repeatItems.put(key + (String)entry.getKey(), items);
        }
    }

    private String getBillInfo(DynamicObject dataEntity) {
        String billInfo = "";
        DynamicObject applierdept = dataEntity.getDynamicObject("bill_org");
        DynamicObject applier = dataEntity.getDynamicObject("bill_applier");
        String description = dataEntity.getString("bill_description");
        String relbilltype = dataEntity.getString("relbilltype");
        DynamicObject createOrg = dataEntity.getDynamicObject("createorg");
        DynamicObject bizItem = dataEntity.getDynamicObject("bill_bizitem");
        DynamicObject projectType = dataEntity.getDynamicObject("bill_projecttype");
        String reimburseType = dataEntity.getString("bill_reimbursetype");
        if (applierdept != null) {
            billInfo = billInfo + String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u90e8\u95e8", (String)"GoodCodeMappingItemUniqueValidator_7", (String)"fi-er-opplugin", (Object[])new Object[0]), applierdept.getPkValue());
        }
        if (applier != null) {
            billInfo = billInfo + String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u7533\u8bf7\u4eba", (String)"GoodCodeMappingItemUniqueValidator_8", (String)"fi-er-opplugin", (Object[])new Object[0]), applier.getPkValue());
        }
        if (StringUtils.isNotBlank((CharSequence)description)) {
            billInfo = billInfo + String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u4e8b\u7531", (String)"GoodCodeMappingItemUniqueValidator_9", (String)"fi-er-opplugin", (Object[])new Object[0]), description);
        }
        if (StringUtils.isNotBlank((CharSequence)relbilltype)) {
            billInfo = billInfo + String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b", (String)"GoodCodeMappingItemUniqueValidator_10", (String)"fi-er-opplugin", (Object[])new Object[0]), relbilltype);
        }
        if (createOrg != null) {
            billInfo = billInfo + String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"GoodCodeMappingItemUniqueValidator_15", (String)"fi-er-opplugin", (Object[])new Object[0]), createOrg.getString("number"));
        }
        if (bizItem != null) {
            billInfo = billInfo + String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u4e1a\u52a1\u4e8b\u9879", (String)"GoodCodeMappingItemUniqueValidator_16", (String)"fi-er-opplugin", (Object[])new Object[0]), bizItem.getPkValue());
        }
        if (projectType != null) {
            billInfo = billInfo + String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u4e1a\u52a1\u5206\u7c7b", (String)"GoodCodeMappingItemUniqueValidator_17", (String)"fi-er-opplugin", (Object[])new Object[0]), projectType.getPkValue());
        }
        if (reimburseType != null) {
            billInfo = billInfo + String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u62a5\u8d26\u7c7b\u578b", (String)"GoodCodeMappingItemUniqueValidator_18", (String)"fi-er-opplugin", (Object[])new Object[0]), reimburseType);
        }
        return billInfo;
    }

    private void checkInvoiceFactor(DynamicObject otherFacter, Map<String, List<ExtendedDataEntity>> groups, ExtendedDataEntity extendedDataEntity) {
        String mappingType = StringUtils.equals((CharSequence)otherFacter.getString("inv_mappingtype"), (CharSequence)"0") ? ResManager.loadKDString((String)"\u5b8c\u5168\u5339\u914d", (String)"GoodCodeMappingItemUniqueValidator_13", (String)"fi-er-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d", (String)"GoodCodeMappingItemUniqueValidator_14", (String)"fi-er-opplugin", (Object[])new Object[0]);
        String info = INVOICE_FACTOR.get(otherFacter.getString("invoicefactor")) + "\uff1a" + otherFacter.getString("mapfactor") + "\uff08" + mappingType + "\uff09";
        List<ExtendedDataEntity> extendList = groups.get(info);
        if (extendList == null) {
            extendList = new ArrayList<ExtendedDataEntity>();
            groups.put(info, extendList);
        }
        extendList.add(extendedDataEntity);
    }

    private void chekBillHeadFactor(Map<String, List<ExtendedDataEntity>> groups, ExtendedDataEntity extendedDataEntity) {
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        String invoiceInfo = this.getInvoiceInfo(dataEntity);
        String billInfo = this.getBillInfo(dataEntity);
        String key = billInfo + invoiceInfo;
        List<ExtendedDataEntity> extendList = groups.get(key);
        if (extendList == null) {
            extendList = new ArrayList<ExtendedDataEntity>();
            groups.put(invoiceInfo, extendList);
        }
        extendList.add(extendedDataEntity);
    }

    private boolean addRepeatMemory(Map<String, List<ExtendedDataEntity>> groups) {
        Iterator<Map.Entry<String, List<ExtendedDataEntity>>> it = groups.entrySet().iterator();
        boolean res = false;
        while (it.hasNext()) {
            Map.Entry<String, List<ExtendedDataEntity>> entry = it.next();
            String key = entry.getKey();
            List<ExtendedDataEntity> dataEntities = entry.getValue();
            if (dataEntities == null || dataEntities.size() <= 1) continue;
            for (int index = 1; index < dataEntities.size(); ++index) {
                String tips = String.format(ResManager.loadKDString((String)"%s\uff0c\u7ec4\u5408\u7ef4\u5ea6\u91cd\u590d\uff0c\u8bf7\u81f3\u5c11\u4fee\u6539\u4e00\u9879\u3002", (String)"GoodCodeMappingItemUniqueValidator_12", (String)"fi-er-opplugin", (Object[])new Object[0]), key);
                this.addErrorMessage(dataEntities.get(index), tips);
            }
            res = true;
        }
        return res;
    }

    private void findAllFactor(DynamicObject otherFacter, Map<String, List<ExtendedDataEntity>> groups, ExtendedDataEntity extendedDataEntity) {
        String mappingType = StringUtils.equals((CharSequence)otherFacter.getString("inv_mappingtype"), (CharSequence)"0") ? ResManager.loadKDString((String)"\u5b8c\u5168\u5339\u914d", (String)"GoodCodeMappingItemUniqueValidator_13", (String)"fi-er-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d", (String)"GoodCodeMappingItemUniqueValidator_14", (String)"fi-er-opplugin", (Object[])new Object[0]);
        String info = INVOICE_FACTOR.get(otherFacter.getString("invoicefactor")) + "\uff1a" + otherFacter.getString("mapfactor") + "\uff08" + mappingType + "\uff09";
        List<ExtendedDataEntity> extendList = groups.get(info);
        if (extendList == null) {
            extendList = new ArrayList<ExtendedDataEntity>();
            groups.put(info, extendList);
        }
        extendList.add(extendedDataEntity);
    }

    private String getInvoiceInfo(DynamicObject dataEntity) {
        String invoiceInfo = "";
        DynamicObject invoiceCode = (DynamicObject)dataEntity.get("inv_ratetype");
        if (invoiceCode != null) {
            invoiceInfo = invoiceInfo + String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u7a0e\u6536\u5206\u7c7b\u7f16\u7801", (String)"GoodCodeMappingItemUniqueValidator_5", (String)"fi-er-opplugin", (Object[])new Object[0]), invoiceCode.getString("number"));
        }
        if (!StringUtils.isBlank((CharSequence)dataEntity.getString("inv_invoicetype"))) {
            invoiceInfo = invoiceInfo + String.format("%1$s:%2$s", ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b", (String)"GoodCodeMappingItemUniqueValidator_6", (String)"fi-er-opplugin", (Object[])new Object[0]), dataEntity.getString("inv_invoicetype"));
        }
        return invoiceInfo;
    }

    private QFilter strNotNull(String key) {
        QFilter qFilter = new QFilter(key, "is null", (Object)"");
        qFilter.or(key, "=", (Object)" ");
        qFilter.or(key, "=", (Object)"");
        return qFilter;
    }

    private void invoiceOtherFactor(DynamicObject otherFacter, Map<String, Set<String>> otherFactorMap) {
        String invoicefactor = otherFacter.getString("invoicefactor");
        HashSet infos = otherFactorMap.get(invoicefactor);
        if (infos == null) {
            infos = Sets.newHashSet();
            otherFactorMap.put(invoicefactor, infos);
        }
        String mappingType = StringUtils.equals((CharSequence)otherFacter.getString("inv_mappingtype"), (CharSequence)"0") ? ResManager.loadKDString((String)"\u5b8c\u5168\u5339\u914d", (String)"GoodCodeMappingItemUniqueValidator_13", (String)"fi-er-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6a21\u7cca\u5339\u914d", (String)"GoodCodeMappingItemUniqueValidator_14", (String)"fi-er-opplugin", (Object[])new Object[0]);
        otherFacter.getString("invoicefactor");
        infos.add(INVOICE_FACTOR.get(otherFacter.getString("invoicefactor")) + "\uff1a" + otherFacter.getString("mapfactor") + "\uff08" + mappingType + "\uff09");
    }

    private void isRepeat(Iterator<Map.Entry<String, Set<String>>> factorEntryIterator, Iterator<Map.Entry<String, Set<String>>> otherFactorEntryIterator, List<String> result) {
        Map.Entry<String, Set<String>> infos = null;
        Map.Entry<String, Set<String>> otherInfos = null;
        if (factorEntryIterator.hasNext()) {
            infos = factorEntryIterator.next();
        }
        if (otherFactorEntryIterator.hasNext()) {
            otherInfos = otherFactorEntryIterator.next();
        }
        if (infos == null && otherInfos == null) {
            return;
        }
        if (infos != null && otherInfos == null || infos == null && otherInfos != null) {
            result.clear();
            return;
        }
        if (!StringUtils.equals((CharSequence)infos.getKey(), (CharSequence)otherInfos.getKey())) {
            result.clear();
            return;
        }
        HashSet sameInfoValue = Sets.newHashSet((Iterable)infos.getValue());
        sameInfoValue.retainAll((Collection)otherInfos.getValue());
        if (sameInfoValue.isEmpty()) {
            result.clear();
            return;
        }
        result.add((String)sameInfoValue.stream().findFirst().get());
        this.isRepeat(factorEntryIterator, otherFactorEntryIterator, result);
    }

    static {
        HashMap map = Maps.newHashMap();
        map.put("inv_ext_goodnames", ResManager.loadKDString((String)"\u5546\u54c1\u540d\u79f0", (String)"GoodCodeMappingItemUniqueValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
        map.put("inv_ext_buyerorgname", ResManager.loadKDString((String)"\u6536\u7968\u516c\u53f8", (String)"GoodCodeMappingItemUniqueValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
        map.put("inv_ext_startcity", ResManager.loadKDString((String)"\u51fa\u53d1\u57ce\u5e02", (String)"GoodCodeMappingItemUniqueValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
        map.put("inv_ext_destcity", ResManager.loadKDString((String)"\u76ee\u7684\u57ce\u5e02", (String)"GoodCodeMappingItemUniqueValidator_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
        INVOICE_FACTOR = Collections.unmodifiableMap(map);
    }
}

