/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.publicbiz.bill.reim;

import java.math.BigDecimal;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.ErStdConfig;

public class PublicReimOnWayAmountValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(PublicReimOnWayAmountValidator.class);

    public void validate() {
        ExtendedDataEntity[] dataEntitys;
        for (ExtendedDataEntity dataEntity : dataEntitys = this.getDataEntities()) {
            Set idList;
            DynamicObjectCollection contracts;
            BigDecimal notpayamount;
            DynamicObject bill = dataEntity.getDataEntity();
            if (bill.getBoolean("isredoffset")) {
                return;
            }
            String applyprojectbillRelated = ErStdConfig.getApplyprojectbillRelated();
            DynamicObjectCollection exps = bill.getDynamicObjectCollection("expenseentryentity");
            DynamicObjectCollection contractList = bill.getDynamicObjectCollection("contractentry");
            boolean frameworkcontract = bill.getBoolean("frameworkcontract");
            if (exps != null && !exps.isEmpty()) {
                Long wbsrcbillid = ((DynamicObject)exps.get(0)).getLong("wbsrcbillid");
                String wbsrcbilltype = ((DynamicObject)exps.get(0)).getString("wbsrcbilltype");
                if (wbsrcbillid != 0L && ("er_applyprojectbill".equals(wbsrcbilltype) || "project".equals(wbsrcbilltype))) {
                    DynamicObjectCollection applyprojectList;
                    BigDecimal payAmount = BigDecimal.ZERO;
                    BigDecimal availableamount = BigDecimal.ZERO;
                    Set idList2 = exps.stream().map(exp -> exp.getLong("wbsrcbillid")).collect(Collectors.toSet());
                    if (idList2 != null && idList2.size() > 0 && (applyprojectList = QueryServiceHelper.query((String)"er_applyprojectbill", (String)"id,nonpayamount,notpayamount,billno,availableamount", (QFilter[])new QFilter[]{new QFilter("id", "in", idList2)})) != null && applyprojectList.size() > 0) {
                        for (DynamicObject applyproject : applyprojectList) {
                            availableamount = applyproject.getBigDecimal("availableamount");
                            payAmount = exps.stream().filter(m -> m.getLong("wbsrcbillid") == applyproject.getLong("id")).map(n -> n.getBigDecimal("expnonpayamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                            logger.info("---availableamount---" + availableamount + "---payAmount---" + payAmount);
                            if (payAmount.compareTo(BigDecimal.ZERO) < 0) {
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7acb\u9879\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u62a5\u9500\u91d1\u989d\u5408\u8ba1\u6263\u9664\u9884\u4ed8\u6216\u501f\u6b3e\u91d1\u989d\u540e\u4e0d\u5141\u8bb8\u4e3a\u8d1f\u6570\u3002", (String)"RelationContractAmountValidator_3", (String)"fi-er-opplugin", (Object[])new Object[0]), applyproject.get("billno")));
                                continue;
                            }
                            if ("2".equals(applyprojectbillRelated)) {
                                if (payAmount.compareTo(availableamount) <= 0) continue;
                                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7acb\u9879\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u62a5\u9500\u91d1\u989d\u5408\u8ba1\u6263\u9664\u9884\u4ed8\u6216\u501f\u6b3e\u91d1\u989d\u540e\u4e0d\u5141\u8bb8\u8d85\u51fa\u8be5\u7acb\u9879\u5355\u53ef\u7528\u91d1\u989d\u3002", (String)"RelationContractAmountValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]), applyproject.get("billno")));
                                continue;
                            }
                            if ("3".equals(applyprojectbillRelated) || payAmount.compareTo(notpayamount = applyproject.getBigDecimal("notpayamount")) <= 0) continue;
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7acb\u9879\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u62a5\u9500\u91d1\u989d\u5408\u8ba1\u6263\u9664\u9884\u4ed8\u6216\u501f\u6b3e\u91d1\u989d\u540e\u4e0d\u5141\u8bb8\u8d85\u51fa\u8be5\u7acb\u9879\u5355\u672a\u4ed8\u91d1\u989d\u3002", (String)"RelationContractAmountValidator_23", (String)"fi-er-opplugin", (Object[])new Object[0]), applyproject.get("billno")));
                        }
                    }
                }
            }
            if (frameworkcontract || contractList == null || contractList.size() <= 0 || (contracts = QueryServiceHelper.query((String)"er_contractbill", (String)"id,nonpayamount,notpayamount,billno,contractcode,availableamount,billcanloanamount,balanceamount,orinotpayamount,orinonpayamount,oriavailableamount,oricanloanamount,oribalanceamount", (QFilter[])new QFilter[]{new QFilter("id", "in", idList = contractList.stream().map(exp -> exp.getLong("contractsid")).collect(Collectors.toSet()))})) == null || contracts.size() <= 0) continue;
            for (DynamicObject contract : contracts) {
                BigDecimal payAmount = contractList.stream().filter(m -> m.getLong("contractsid") == contract.getLong("id")).map(n -> n.getBigDecimal("contractnonpayamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal availableAmount = contract.getBigDecimal("availableamount");
                BigDecimal billcanloanamount = contract.getBigDecimal("billcanloanamount");
                BigDecimal balanceamount = contract.getBigDecimal("balanceamount");
                notpayamount = contract.getBigDecimal("notpayamount");
                availableAmount = availableAmount.compareTo(billcanloanamount) < 0 ? (availableAmount.compareTo(balanceamount) < 0 ? availableAmount : balanceamount) : (billcanloanamount.compareTo(balanceamount) < 0 ? billcanloanamount : balanceamount);
                BigDecimal oripayAmount = contractList.stream().filter(m -> m.getLong("contractsid") == contract.getLong("id")).map(n -> n.getBigDecimal("oricontractnonpayamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal oriavailableAmount = contract.getBigDecimal("oriavailableAmount");
                BigDecimal oricanloanamount = contract.getBigDecimal("oricanloanamount");
                BigDecimal oribalanceamount = contract.getBigDecimal("oribalanceamount");
                BigDecimal orinotpayamount = contract.getBigDecimal("orinotpayamount");
                oriavailableAmount = oriavailableAmount.compareTo(oricanloanamount) < 0 ? (oriavailableAmount.compareTo(oribalanceamount) < 0 ? oriavailableAmount : oribalanceamount) : (oricanloanamount.compareTo(oribalanceamount) < 0 ? oricanloanamount : oribalanceamount);
                logger.info("---payAmount---" + payAmount + "---availableAmount---" + availableAmount + "---billcanloanamount---" + billcanloanamount + "---balanceamount---" + balanceamount + "---oripayAmount---" + oripayAmount + "---oriavailableAmount---" + oriavailableAmount + "---oricanloanamount---" + oricanloanamount + "---oribalanceamount---" + oribalanceamount);
                if (oripayAmount.compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f0\u8d26\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u62a5\u9500\u91d1\u989d\u539f\u5e01\u5408\u8ba1\u6263\u9664\u9884\u4ed8\u6216\u501f\u6b3e\u91d1\u989d\u539f\u5e01\u540e\u4e0d\u5141\u8bb8\u4e3a\u8d1f\u6570\u3002", (String)"RelationContractAmountValidator_12", (String)"fi-er-opplugin", (Object[])new Object[0]), contract.get("contractcode")));
                    continue;
                }
                if (payAmount.compareTo(BigDecimal.ZERO) < 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f0\u8d26\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u62a5\u9500\u91d1\u989d\u5408\u8ba1\u6263\u9664\u9884\u4ed8\u6216\u501f\u6b3e\u91d1\u989d\u540e\u4e0d\u5141\u8bb8\u4e3a\u8d1f\u6570\u3002", (String)"RelationContractAmountValidator_7", (String)"fi-er-opplugin", (Object[])new Object[0]), contract.get("contractcode")));
                    continue;
                }
                if (!"2".equals(applyprojectbillRelated)) continue;
                if (payAmount.compareTo(availableAmount) > 0) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f0\u8d26\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u62a5\u9500\u91d1\u989d\u5408\u8ba1\u6263\u9664\u9884\u4ed8\u6216\u501f\u6b3e\u91d1\u989d\u540e\u4e0d\u5141\u8bb8\u8d85\u51fa\u8be5\u5408\u540c\u53f0\u8d26\u5355\u53ef\u7528\u91d1\u989d\u3002", (String)"RelationContractAmountValidator_6", (String)"fi-er-opplugin", (Object[])new Object[0]), contract.get("contractcode")));
                    continue;
                }
                if (oripayAmount.compareTo(oriavailableAmount) <= 0) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5408\u540c\u53f0\u8d26\u5355\u201c%1$s\u201d\u5173\u8054\u7684\u62a5\u9500\u91d1\u989d\u539f\u5e01\u5408\u8ba1\u6263\u9664\u9884\u4ed8\u6216\u501f\u6b3e\u91d1\u989d\u539f\u5e01\u540e\u4e0d\u5141\u8bb8\u8d85\u51fa\u8be5\u5408\u540c\u53f0\u8d26\u5355\u53ef\u7528\u91d1\u989d\u539f\u5e01\u3002", (String)"RelationContractAmountValidator_10", (String)"fi-er-opplugin", (Object[])new Object[0]), contract.get("contractcode")));
            }
        }
    }
}

