/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.publicbiz.bill.reim;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.er.business.daily.reimburse.WriteOffTypeEnum;
import kd.fi.er.business.pub.PublicBillUtil;
import kd.fi.er.business.utils.ErCommonUtils;

public class RelationContractAmountValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntitys;
        for (ExtendedDataEntity dataEntity : dataEntitys = this.getDataEntities()) {
            boolean frameworkcontract;
            DynamicObject bill = dataEntity.getDataEntity();
            if (bill.getDynamicObject("company") == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErReimburseBaseBillEdit_0", (String)"fi-er-formplugin", (Object[])new Object[0]));
                return;
            }
            String writeofftype = (String)ErCommonUtils.getEMParameter((long)ErCommonUtils.getPk((Object)((DynamicObject)bill.get("company")).getPkValue()), (String)"er010");
            DynamicObjectCollection exps = bill.getDynamicObjectCollection("expenseentryentity");
            BigDecimal currAmountTO = BigDecimal.ZERO;
            BigDecimal expenseAmountTO = BigDecimal.ZERO;
            if (exps != null && !exps.isEmpty()) {
                currAmountTO = exps.stream().map(e -> (BigDecimal)e.get("currexpenseamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
                expenseAmountTO = exps.stream().map(e -> (BigDecimal)e.get("expenseamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            }
            if (frameworkcontract = bill.getBoolean("frameworkcontract")) break;
            DynamicObjectCollection contracts = bill.getDynamicObjectCollection("contractentry");
            if (contracts.size() <= 0) {
                return;
            }
            BigDecimal currCanAmountTO = contracts.stream().map(e -> (BigDecimal)e.get("contractcurrcanamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            BigDecimal canAmountTO = contracts.stream().map(e -> (BigDecimal)e.get("contractcanamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeofftype)) {
                if (PublicBillUtil.compareWithTail((BigDecimal)expenseAmountTO, (BigDecimal)canAmountTO, (BigDecimal)BigDecimal.valueOf(0.1)) > 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\uff08\u539f\u5e01\uff09\u4e0d\u80fd\u5927\u4e8e\u5173\u8054\u5408\u540c\u53ef\u62a5\u9500\u91d1\u989d\uff08\u539f\u5e01\uff09\u5408\u8ba1\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"RelationContractAmountValidator_16", (String)"fi-er-opplugin", (Object[])new Object[0]));
                }
            } else if (PublicBillUtil.compareWithTail((BigDecimal)currAmountTO, (BigDecimal)currCanAmountTO, (BigDecimal)BigDecimal.valueOf(0.1)) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u62a5\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5173\u8054\u5408\u540c\u53ef\u62a5\u9500\u91d1\u989d\u5408\u8ba1\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"RelationContractAmountValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
            }
            BigDecimal notPayAmountTO = contracts.stream().map(e -> (BigDecimal)e.get("contractnotpayamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            BigDecimal orinotPayAmountTO = contracts.stream().map(e -> (BigDecimal)e.get("oricontractnotpayamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            DynamicObjectCollection accounts = bill.getDynamicObjectCollection("accountentry");
            BigDecimal receiveAmountTO = accounts.stream().map(e -> (BigDecimal)e.get("receiveamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            BigDecimal orireceiveAmountTO = accounts.stream().map(e -> (BigDecimal)e.get("orireceiveamount")).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            if (WriteOffTypeEnum.ORGI_WO.getValue().equals(writeofftype)) {
                if (PublicBillUtil.compareWithTail((BigDecimal)orireceiveAmountTO, (BigDecimal)orinotPayAmountTO, (BigDecimal)BigDecimal.valueOf(0.1)) <= 0) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\uff08\u539f\u5e01\uff09\u4e0d\u80fd\u5927\u4e8e\u5173\u8054\u5408\u540c\u672a\u4ed8\u91d1\u989d\uff08\u539f\u5e01\uff09\u5408\u8ba1\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"RelationContractAmountValidator_15", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (PublicBillUtil.compareWithTail((BigDecimal)receiveAmountTO, (BigDecimal)notPayAmountTO, (BigDecimal)BigDecimal.valueOf(0.1)) <= 0) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5173\u8054\u5408\u540c\u672a\u4ed8\u91d1\u989d\u5408\u8ba1\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u63d0\u4ea4\u3002", (String)"RelationContractAmountValidator_14", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
    }
}

