/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.validator.trip.dailybiz;

import com.google.common.base.Objects;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.extplugin.PluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.sdk.fi.er.extpoint.trip.ITripCheckReqBillCloseService;
import org.apache.commons.lang3.StringUtils;

public class TripReqCheckOrderValidator
extends AbstractValidator {
    private static final Log logger = LogFactory.getLog(TripReqCheckOrderValidator.class);
    private static String[] validateOperateKey = new String[]{"unsubmit", "tripchange", "unaudit"};

    public void validate() {
        ExtendedDataEntity[] dataEntitys;
        for (ExtendedDataEntity dataEntity : dataEntitys = this.getDataEntities()) {
            QFilter filter;
            boolean exists;
            PluginProxy tripCheckReqBillCloseService = PluginProxy.create(null, ITripCheckReqBillCloseService.class, (String)"FI_ER_TRIP_CHECKREQBILLCLOSE", null);
            AtomicReference[] callreplace = new AtomicReference[]{null};
            tripCheckReqBillCloseService.callReplace(p -> {
                callreplace[0] = new AtomicReference<Boolean>(p.checkReqBillClose(dataEntity.getDataEntity(), this.getOperateKey()));
                return (Boolean)callreplace[0].get();
            });
            if (null != callreplace[0] && ((Boolean)callreplace[0].get()).booleanValue()) continue;
            String billNo = dataEntity.getBillNo();
            Long companyId = ErCommonUtils.getPk((Object)dataEntity.getDataEntity().get("company"));
            QFilter[] qFilters = new QFilter[]{new QFilter("oabillnum", "=", (Object)billNo)};
            if (Arrays.asList(validateOperateKey).contains(this.getOperateKey()) && StringUtils.isNotBlank((CharSequence)billNo) && (exists = QueryServiceHelper.exists((String)"er_allorderbill", (QFilter[])new QFilter[]{filter = new QFilter("oabillnum", "=", (Object)billNo).and("server", "=", (Object)Supplier.MEIYA.getValue())}))) {
                logger.info("\u5b58\u5728\u7f8e\u4e9a\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u6216\u8005\u53d8\u66f4\u3002");
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u53d1\u751f\u9884\u8ba2\uff0c\u5b58\u5728\u5546\u65c5\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5904\u7406\u3002", (String)"TripReqCheckOrderValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObject orderBill = QueryServiceHelper.queryOne((String)"er_allorderbill", (String)"id", (QFilter[])qFilters);
            if (this.getOperateKey().equals("unsubmit") && orderBill != null && ((Boolean)dataEntity.getValue("ischange")).booleanValue()) continue;
            DynamicObject[][] ordersArray = new DynamicObject[5][0];
            if (orderBill != null) {
                if (this.getOperateKey().equals("closebill")) {
                    String sic = "isreimburse,isapprove,totalamount,oabillnum,ordernum";
                    ordersArray[0] = BusinessDataServiceHelper.load((String)"er_planebill", (String)sic, (QFilter[])qFilters);
                    ordersArray[1] = BusinessDataServiceHelper.load((String)"er_hotelbill", (String)sic, (QFilter[])qFilters);
                    ordersArray[2] = BusinessDataServiceHelper.load((String)"er_vehiclebill", (String)sic, (QFilter[])qFilters);
                    ordersArray[3] = BusinessDataServiceHelper.load((String)"er_trainbill", (String)sic, (QFilter[])qFilters);
                    ordersArray[4] = BusinessDataServiceHelper.load((String)"er_mealbill", (String)sic, (QFilter[])qFilters);
                    if (!this.isCloseable(ordersArray, companyId)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u53d1\u751f\u9884\u8ba2\uff0c\u5b58\u5728\u672a\u62a5\u9500\u5ba1\u6838\u901a\u8fc7\u7684\u5546\u65c5\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5904\u7406\u3002", (String)"TripReqCheckOrderValidator_3", (String)"fi-er-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                } else if (!"noapproval".equals(this.getOperateKey()) && !"tripchange".equals(this.getOperateKey())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fa\u5dee\u7533\u8bf7\u53d1\u751f\u9884\u8ba2\uff0c\u5b58\u5728\u5546\u65c5\u8ba2\u5355\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c\u5904\u7406\u3002", (String)"TripReqCheckOrderValidator_0", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    continue;
                }
            }
            DynamicObject tripReqData = dataEntity.getDataEntity();
            boolean isAuditRevocationBill = SystemParamterUtil.getIsAuditRevocationBill((long)tripReqData.getLong("company.id"));
            if (this.getOperateKey().equals("invalidbtn") && !isAuditRevocationBill && !Objects.equal((Object)"B", (Object)tripReqData.get("billstatus")) && !Objects.equal((Object)"D", (Object)tripReqData.get("billstatus"))) continue;
            if (this.getOperateKey().equals("unsubmit")) {
                if (!isAuditRevocationBill && !Objects.equal((Object)"B", (Object)tripReqData.get("billstatus"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u63d0\u4ea4\u72b6\u6001\u7684\u5355\u636e\u624d\u53ef\u4ee5\u64a4\u9500\u3002", (String)"TripReqCheckOrderValidator_1", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (isAuditRevocationBill && !Objects.equal((Object)"B", (Object)tripReqData.get("billstatus")) && !Objects.equal((Object)"C", (Object)tripReqData.get("billstatus"))) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u201c\u63d0\u4ea4\u201d\u548c\u201c\u5ba1\u6838\u4e2d\u201d\u72b6\u6001\u7684\u5355\u636e\u624d\u80fd\u64a4\u9500\u3002", (String)"TripReqCheckOrderValidator_2", (String)"fi-er-opplugin", (Object[])new Object[0]));
                    continue;
                }
            }
            if (!this.getOperateKey().equals("closebill")) continue;
            for (DynamicObject[] orders : ordersArray) {
                SaveServiceHelper.save((DynamicObject[])orders);
            }
        }
    }

    private boolean isCloseable(DynamicObject[][] ordersArray, Long companyId) {
        if (SystemParamterUtil.getcheckparamDefaute((long)companyId, (String)"ordertripreimburse") == 0) {
            ordersArray[0] = new DynamicObject[0];
            ordersArray[1] = new DynamicObject[0];
            ordersArray[3] = new DynamicObject[0];
        }
        if (SystemParamterUtil.getcheckparamDefaute((long)companyId, (String)"carordertripreimburse") == 0) {
            ordersArray[2] = new DynamicObject[0];
        }
        if (SystemParamterUtil.getcheckparamDefaute((long)companyId, (String)"mealOrderTripReimburse") == 0) {
            ordersArray[4] = new DynamicObject[0];
        }
        if (this.isAllAudit(ordersArray)) {
            return true;
        }
        if (this.isZeroAllAmount(ordersArray)) {
            DynamicObject[][] dynamicObjectArray = ordersArray;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject[] orders;
                for (DynamicObject order : orders = dynamicObjectArray[i]) {
                    order.set("isreimburse", (Object)"1");
                    order.set("isapprove", (Object)"1");
                }
            }
            return true;
        }
        return false;
    }

    private boolean isZeroAllAmount(DynamicObject[][] ordersArray) {
        for (DynamicObject[] orders : ordersArray) {
            BigDecimal totalamount = BigDecimal.ZERO;
            for (DynamicObject order : orders) {
                if (order.getBoolean("isreimburse")) continue;
                totalamount = totalamount.add(order.getBigDecimal("totalamount"));
            }
            if (totalamount.compareTo(BigDecimal.ZERO) == 0) continue;
            return false;
        }
        return true;
    }

    private boolean isAllAudit(DynamicObject[][] ordersArray) {
        DynamicObject[][] dynamicObjectArray = ordersArray;
        int n = dynamicObjectArray.length;
        for (int i = 0; i < n; ++i) {
            DynamicObject[] orders;
            for (DynamicObject order : orders = dynamicObjectArray[i]) {
                if (order.getBoolean("isreimburse") && order.getBoolean("isapprove")) continue;
                return false;
            }
        }
        return true;
    }
}

