/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.botp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.kdtx.common.invoke.DtxResponse;
import kd.bos.kdtx.sdk.api.EventualConsistencyService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.cas.refund.RefundRenoteOrCancelParam;
import kd.fi.er.business.bean.ReimburseWriteTravelOrder;
import kd.fi.er.business.message.ErMessageServiceHelper;
import kd.fi.er.business.trip.dailybiz.TripReimWriteBackOrderUtil;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.common.enums.PayLogEnum;
import kd.fi.er.common.enums.PayTargeBillType;
import kd.fi.er.common.integrationenum.CasWriteBackOperateEnum;
import kd.fi.er.common.model.PayLogBo;
import kd.fi.er.mservice.bill.BusinessBillSynService;
import kd.fi.er.mservice.botp.writeback.AbstractWriteBackServcie;

public abstract class AbstractPayBillSynService
extends EventualConsistencyService
implements BusinessBillSynService {
    protected static final String OPERATE = "operate";
    protected static final String SOURCEPK = "sourcepk";
    protected static final String TARGETPK = "targetpk";
    private static Log log = LogFactory.getLog(AbstractPayBillSynService.class);

    protected String getCasOpration(CasWriteBackOperateEnum operateEnum) {
        String result = null;
        if (operateEnum != null) {
            switch (operateEnum) {
                case PAY: {
                    result = "payOrSync";
                    break;
                }
                case CANCELPAY: {
                    result = "cancelPay";
                    break;
                }
                case REFUND: {
                    result = "refund";
                    break;
                }
                case REFUNDVALIDATE: {
                    result = "refundValidate";
                    break;
                }
                case RENOTE: {
                    result = "renote";
                    break;
                }
                case RENOTEVALIDATE: {
                    result = "renoteValidate";
                    break;
                }
                case PAYVALIDATE: {
                    result = "payValidate";
                    break;
                }
                case CANCELPAYVALIDATE: {
                    result = "cancelPayValidate";
                    break;
                }
                case CANCELREFUND: {
                    result = "cancelRefund";
                    break;
                }
                case CANCELREFUNDVALIDATE: {
                    result = "cancelRefundValidate";
                    break;
                }
                case CANCELRENOTE: {
                    result = "cancelRenote";
                    break;
                }
                case CANCELRENOTEVALIDATE: {
                    result = "cancelRenoteValidate";
                    break;
                }
            }
        }
        return result;
    }

    protected String getCasOpration(String operate) {
        String result = null;
        CasWriteBackOperateEnum operateEnum = CasWriteBackOperateEnum.getWriteOperateEnumByValue((String)operate);
        result = this.getCasOpration(operateEnum);
        return result;
    }

    protected abstract OperationResult writeBack(List<?> var1, String var2);

    protected OperationResult getOperationResult(boolean isSuccess, Map<String, Object> errCollection) {
        ValidateResultCollection validateResults = new ValidateResultCollection();
        if (!isSuccess && errCollection.size() > 0) {
            Iterator<Map.Entry<String, Object>> iterator = errCollection.entrySet().iterator();
            ValidateResult validateResult = new ValidateResult();
            ArrayList<OperateErrorInfo> operateErrors = new ArrayList<OperateErrorInfo>(2);
            String firstError = "";
            while (iterator.hasNext()) {
                Map.Entry<String, Object> errEntry = iterator.next();
                if (StringUtils.isEmpty((CharSequence)firstError)) {
                    firstError = String.valueOf(errEntry.getValue());
                }
                OperateErrorInfo operateErrorInfo = new OperateErrorInfo();
                operateErrorInfo.setPkValue((Object)Long.valueOf(errEntry.getKey()));
                operateErrorInfo.setTitle(ResManager.loadKDString((String)"\u5931\u8d25", (String)"AbstractPayBillSynService_0", (String)"fi-er-mservice", (Object[])new Object[0]));
                operateErrorInfo.setLevel(ErrorLevel.Error);
                operateErrorInfo.setMessage(String.valueOf(errEntry.getValue()));
                operateErrors.add(operateErrorInfo);
            }
            validateResult.setAllErrorInfo(operateErrors);
            validateResult.setSuccess(isSuccess);
            validateResult.setMessage(firstError);
            validateResults.addValidateError("", validateResult);
        }
        OperationResult operationResult = new OperationResult();
        operationResult.setValidateResult(validateResults);
        operationResult.setSuccess(isSuccess);
        return operationResult;
    }

    protected final void saveWriteBackResult(boolean isSynWriteBack, AbstractWriteBackServcie synBackService, DynamicObject[] sourceBills, Map<String, Object> errorCodeCollection, PayTargeBillType targeBillType, Object targetPk) {
        block8: {
            block6: {
                log.info("\u51fa\u7eb3\u96c6\u6210\uff0cisSynWriteBack\uff1a {}, operateName: {}", (Object)isSynWriteBack, (Object)synBackService.getOperateName());
                if (!isSynWriteBack || TripReimWriteBackOrderUtil.onlyValidate((String)synBackService.getOperateName())) break block6;
                log.info("\u51fa\u7eb3\u96c6\u6210,\u7b26\u5408\u53cd\u5199\u6761\u4ef6\uff0c\u4fdd\u5b58\u53cd\u5199\u7ed3\u679c->\u6761\u4ef6:" + isSynWriteBack + "\n\u5185\u5bb9:" + SerializationUtils.toJsonString((Object)sourceBills));
                synBackService.beforeSaveWriteBackResult(sourceBills);
                Arrays.stream(sourceBills).forEach(e -> e.set("modifytime", (Object)new Date()));
                if (!synBackService.needOverrideAfterSaveWriteBackResult()) {
                    log.info("\u51fa\u7eb3\u96c6\u6210,\u6267\u884csave\u64cd\u4f5c\u524d");
                    SaveServiceHelper.save((DynamicObject[])sourceBills);
                    PayLogBo logBo = PayLogBo.build().traceId(RequestContext.get().getTraceId()).sourceId(sourceBills[0].getPkValue()).targetId(targetPk).op(synBackService.getOperateName()).payTargeBillType(targeBillType).setp(PayLogEnum.SAVE).msg(Boolean.TRUE.toString());
                    AbstractPayBillSynService.writeLog(logBo);
                    log.info("\u51fa\u7eb3\u96c6\u6210,\u6267\u884csave\u64cd\u4f5c\u540e");
                }
                log.info("\u51fa\u7eb3\u96c6\u6210,\u6267\u884cafterSaveWriteBackResult\u64cd\u4f5c\u524d");
                String msg = "";
                try {
                    synBackService.afterSaveWriteBackResult(sourceBills);
                }
                catch (Exception e2) {
                    try {
                        msg = e2.getMessage();
                        throw e2;
                    }
                    catch (Throwable throwable) {
                        PayLogBo logBo = PayLogBo.build().traceId(RequestContext.get().getTraceId()).sourceId(sourceBills[0].getPkValue()).targetId(targetPk).op(synBackService.getOperateName()).payTargeBillType(targeBillType).setp(PayLogEnum.INVOKE).msg(StringUtils.isNotEmpty((CharSequence)msg) ? msg : Boolean.TRUE.toString());
                        AbstractPayBillSynService.writeLog(logBo);
                        throw throwable;
                    }
                }
                PayLogBo logBo = PayLogBo.build().traceId(RequestContext.get().getTraceId()).sourceId(sourceBills[0].getPkValue()).targetId(targetPk).op(synBackService.getOperateName()).payTargeBillType(targeBillType).setp(PayLogEnum.INVOKE).msg(StringUtils.isNotEmpty((CharSequence)msg) ? msg : Boolean.TRUE.toString());
                AbstractPayBillSynService.writeLog(logBo);
                log.info("\u51fa\u7eb3\u96c6\u6210,\u6267\u884cafterSaveWriteBackResult\u64cd\u4f5c\u540e");
                break block8;
            }
            if (!isSynWriteBack && synBackService.getErrorCollection() != null) {
                log.info("\u51fa\u7eb3\u96c6\u6210\uff0c\u6700\u7ec8\u53cd\u5199\u672a\u5165\u5e93");
                errorCodeCollection.putAll(synBackService.getErrorCollection());
            }
        }
        log.info("\u51fa\u7eb3\u96c6\u6210,\u8f93\u51fa\u5168\u90e8\u9519\u8bef\u4fe1\u606f\uff1a {}", (Object)SerializationUtils.toJsonString(synBackService.getErrorCollection()));
    }

    private boolean isOnlyValidate(String operateName) {
        CasWriteBackOperateEnum operateEnum = CasWriteBackOperateEnum.getWriteOperateEnumByValue((String)operateName);
        return CasWriteBackOperateEnum.CANCELPAYVALIDATE == operateEnum || CasWriteBackOperateEnum.PAYVALIDATE == operateEnum;
    }

    void saveWriteBackLog(String operatetype, String targetBillType, Object param) {
        MainEntityType dynamicObjectType = EntityMetadataCache.getDataEntityType((String)"er_caswriteback_log");
        DynamicObject object = new DynamicObject((DynamicObjectType)dynamicObjectType);
        object.set("operatetype", (Object)operatetype);
        object.set("billtype", (Object)targetBillType);
        object.set("createtime", (Object)new Date());
        object.set("requestparam", (Object)SerializationUtils.toJsonString((Object)param).substring(0, 20));
        object.set("requestparam_tag", (Object)SerializationUtils.toJsonString((Object)param));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{object});
    }

    public static void writeLog(PayLogBo payLogBo) {
        AbstractPayBillSynService.writeLog(Collections.singletonList(payLogBo));
    }

    public static void writeLog(List<PayLogBo> payLogBos) {
        payLogBos.stream().forEach(m -> m.username(RequestContext.get().getUserName()));
        ThreadService.execute(() -> {
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"er_caswblog");
            ArrayList<DynamicObject> dyns = new ArrayList<DynamicObject>(payLogBos.size());
            for (PayLogBo payLogBo : payLogBos) {
                DynamicObject d = new DynamicObject((DynamicObjectType)type);
                d.set("username", (Object)payLogBo.getUsername());
                d.set("opname", (Object)payLogBo.getOp());
                if (payLogBo.getMsg().length() > 20) {
                    d.set("msg", (Object)payLogBo.getMsg().substring(0, 20));
                }
                d.set("msg_tag", (Object)payLogBo.getMsg());
                d.set("opdate", (Object)payLogBo.getTime());
                d.set("traceid", (Object)payLogBo.getTraceId());
                d.set("targetid", payLogBo.getTargetId());
                d.set("sourceid", payLogBo.getSourceId());
                d.set("targebilltype", (Object)payLogBo.getPayTargeBillType().getCode());
                d.set("setp", (Object)payLogBo.getSetp().getCode());
                dyns.add(d);
            }
            LogORM logORM = LogORM.create();
            logORM.insert(dyns);
        }, (TaskType)TaskType.ER_LOG_TASK, (RequestContext)RequestContext.get());
    }

    protected String printStack(Exception ex) {
        StringBuilder sb = new StringBuilder();
        sb.append(ex.getMessage()).append("\r\n");
        for (StackTraceElement s : ex.getStackTrace()) {
            sb.append(s.getClassName()).append(s.getMethodName()).append(s.getLineNumber()).append("\r\n");
        }
        return sb.toString();
    }

    void afterOperate(Set<ReimburseWriteTravelOrder> writeBackReimburseList) {
        if (writeBackReimburseList.size() == 0) {
            return;
        }
        for (ReimburseWriteTravelOrder travelOrder : writeBackReimburseList) {
            TripReimWriteBackOrderUtil.reimburseStatus((String)travelOrder.getEntityId(), (Long)travelOrder.getId(), (String)("G".equals(travelOrder.getBillStatus()) ? "C" : "B"));
        }
        Map<String, List<DynamicObject>> bilMap = writeBackReimburseList.stream().map(m -> m.getBill()).collect(Collectors.groupingBy(m -> m.getDynamicObjectType().getName()));
        for (Map.Entry<String, List<DynamicObject>> entry : bilMap.entrySet()) {
            List<DynamicObject> list = entry.getValue();
            for (DynamicObject sourceBill : list) {
                DynamicProperty property = sourceBill.getDynamicObjectType().getProperty("billstatus");
                if (property == null || !sourceBill.getString("billstatus").equalsIgnoreCase(ErBillStatusEnum.G.toString())) continue;
                ErMessageServiceHelper.sendMessage((DynamicObject[])new DynamicObject[]{sourceBill}, (String)entry.getKey(), (String)"applier", (String)"er_cas_pay");
            }
        }
    }

    Map<String, Set<Long>> getIdMap(RefundRenoteOrCancelParam param) {
        HashMap<String, Set<Long>> sourceIds = new HashMap<String, Set<Long>>(16);
        param.getRefundPayInfos().stream().forEach(m -> m.getEntryInfos().forEach(n -> n.getSourceInfos().stream().forEach(x -> {
            HashSet<Long> set = (HashSet<Long>)sourceIds.get(x.getSourceEntity());
            if (set == null) {
                set = new HashSet<Long>(16);
                sourceIds.put(x.getSourceEntity(), set);
            }
            set.add(x.getSourcePk());
        })));
        return sourceIds;
    }

    public DtxResponse execute(Object o, Object o1) {
        throw new KDBizException("unsupported operation");
    }
}

