/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.mservice.botp;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.RepaymentAssociateUtil;
import kd.fi.er.common.ErBillStatusEnum;
import kd.fi.er.mservice.bill.ICasBillWriteBackService;

public class CasBillWriteBackService
implements ICasBillWriteBackService {
    private static Log logger = LogFactory.getLog(CasBillWriteBackService.class);

    public Map<String, Object> execute(Object param) {
        Map map = (Map)param;
        logger.info("\u51fa\u7eb3\u96c6\u6210,\u6536\u6b3e\u5355\u53cd\u5199\u8fd8\u6b3e\u5355,cas_recbill writeback :" + map);
        Object billType = map.get("billType");
        if ("cas_recbill".equals(billType)) {
            String operate = (String)map.get("operate");
            Long[] recbillIds = Stream.of((DynamicObject[])map.get("dataEntities")).map(v -> (Long)v.getPkValue()).collect(Collectors.toList()).toArray(new Long[0]);
            HashSet allSourceBillPs = new HashSet();
            Map findSourceBills = BFTrackerServiceHelper.findSourceBills((String)"cas_recbill", (Long[])recbillIds);
            findSourceBills.values().stream().forEach(v -> allSourceBillPs.addAll(v));
            if (!allSourceBillPs.isEmpty()) {
                MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)"er_repaymentbill");
                DynamicObject[] repaymentbills = BusinessDataServiceHelper.load((Object[])allSourceBillPs.toArray(), (DynamicObjectType)dt);
                ArrayList<DynamicObject> saveList = new ArrayList<DynamicObject>();
                for (DynamicObject repaymentbill : repaymentbills) {
                    DynamicObject[] casRecbill = this.getCurrentReceiveBills((Long)repaymentbill.getPkValue());
                    if ("receivingrec".equals(operate)) {
                        if (repaymentbill.getBigDecimal("totalactrecamt").compareTo(repaymentbill.getBigDecimal("approveamount")) == 0 && !ErBillStatusEnum.G.toString().equals(repaymentbill.get("billstatus")) && Arrays.stream(casRecbill).filter(e -> !"D".equals(e.getString("billstatus"))).count() < 1L) {
                            repaymentbill.set("billstatus", (Object)ErBillStatusEnum.G.toString());
                        }
                        this.updateReceiveEntrys(repaymentbill, casRecbill, true);
                        saveList.add(repaymentbill);
                        continue;
                    }
                    if (!"cancelrec".equals(operate)) continue;
                    repaymentbill.set("billstatus", (Object)"F");
                    this.updateReceiveEntrys(repaymentbill, casRecbill, false);
                    saveList.add(repaymentbill);
                }
                if (!saveList.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])saveList.toArray(new DynamicObject[0]));
                    logger.info("\u51fa\u7eb3\u96c6\u6210,\u6536\u6b3e\u5355\u53cd\u5199\u8fd8\u6b3e\u5355,saveListids : " + saveList.stream().map(v -> v.getLong("id")).collect(Collectors.toList()));
                } else {
                    logger.info("\u51fa\u7eb3\u96c6\u6210,\u6536\u6b3e\u5355\u53cd\u5199\u8fd8\u6b3e\u5355,saveList.size == 0");
                }
            }
            if (allSourceBillPs.isEmpty()) {
                DynamicObjectCollection entrys;
                DynamicObject[] dynamicObjects = (DynamicObject[])map.get("dataEntities");
                long type = 0L;
                long sourcebillId = 0L;
                if (dynamicObjects != null && dynamicObjects.length > 0 && !(entrys = dynamicObjects[0].getDynamicObjectCollection("entry")).isEmpty()) {
                    type = ((DynamicObject)entrys.get(0)).getLong("e_sourcebillentryid");
                    sourcebillId = ((DynamicObject)entrys.get(0)).getLong("e_sourcebillid");
                    if ("cancelrec".equals(operate)) {
                        for (int i = 0; i < entrys.size(); ++i) {
                            ((DynamicObject)entrys.get(i)).set("e_sourcebillid", (Object)0);
                            ((DynamicObject)entrys.get(i)).set("e_corebillno", (Object)"");
                            ((DynamicObject)entrys.get(i)).set("e_corebilltype", (Object)"");
                            ((DynamicObject)entrys.get(i)).set("e_sourcebillentryid", (Object)0);
                        }
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObjects[0]});
                    }
                }
                if (type == -1L) {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)sourcebillId, (String)"er_repaymentbill");
                    if ("cancelrec".equals(operate)) {
                        if (dynamicObject != null) {
                            DynamicObjectCollection repaymententryCollectoin;
                            dynamicObject.set("billstatus", (Object)ErBillStatusEnum.A.toString());
                            DynamicObjectCollection receiveEntrys = dynamicObject.getDynamicObjectCollection("recentry");
                            if (!receiveEntrys.isEmpty()) {
                                for (int i = 0; i < receiveEntrys.size(); ++i) {
                                    DynamicObjectCollection entrys2;
                                    DynamicObject casbill = BusinessDataServiceHelper.loadSingleFromCache((Object)((DynamicObject)receiveEntrys.get(i)).getLong("recbillid"), (String)"cas_recbill");
                                    if (casbill == null || (entrys2 = casbill.getDynamicObjectCollection("entry")).isEmpty()) continue;
                                    for (DynamicObject entry : entrys2) {
                                        entry.set("e_sourcebillid", (Object)0);
                                        entry.set("e_corebillno", (Object)"");
                                        entry.set("e_corebilltype", (Object)"");
                                        entry.set("e_sourcebillentryid", (Object)0);
                                    }
                                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{casbill});
                                }
                                receiveEntrys.removeIf(e -> e.getLong("recbillid") != 0L);
                            }
                            if (!(repaymententryCollectoin = dynamicObject.getDynamicObjectCollection("repaymententry")).isEmpty()) {
                                for (int i = 0; i < repaymententryCollectoin.size(); ++i) {
                                    ((DynamicObject)repaymententryCollectoin.get(i)).set("orirecamount", (Object)BigDecimal.ZERO);
                                    ((DynamicObject)repaymententryCollectoin.get(i)).set("recamount", (Object)BigDecimal.ZERO);
                                }
                            }
                            dynamicObject.set("totalactrecamt", (Object)BigDecimal.ZERO);
                            BigDecimal totalnotactrecamt = dynamicObject.getBigDecimal("amount");
                            dynamicObject.set("totalnotactrecamt", (Object)totalnotactrecamt);
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                        }
                    } else if ("receivingrec".equals(operate) && dynamicObject.getBigDecimal("totalactrecamt").compareTo(dynamicObject.getBigDecimal("approveamount")) == 0 && !ErBillStatusEnum.G.toString().equals(dynamicObject.get("billstatus"))) {
                        dynamicObject.set("billstatus", (Object)ErBillStatusEnum.G.toString());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                    }
                }
            }
        }
        return null;
    }

    private DynamicObject[] getCurrentReceiveBills(Long rePaymentBillId) {
        Map targetBillMap = BFTrackerServiceHelper.findTargetBills((String)"er_repaymentbill", (Long[])new Long[]{rePaymentBillId});
        HashSet targetBillIdSet = (HashSet)targetBillMap.get("cas_recbill");
        String selectFields = "id,billstatus,entry.id, entry.e_actamt,entry.e_localamt, entry.e_sourcebillid, payeracctbank,accountbank.id,accountcash.id,billno,bizdate,receivingtype,payeebank,accountbank,currency,exchangerate,actrecamt,localamt,approveamount";
        QFilter qFilter = new QFilter("id", "in", (Object)targetBillIdSet);
        return BusinessDataServiceHelper.load((String)"cas_recbill", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
    }

    private void updateReceiveEntrys(DynamicObject repaymentbill, DynamicObject[] casRecbills, boolean isUpdate) {
        DynamicObjectCollection recEntryDetails = repaymentbill.getDynamicObjectCollection("recentrydetail");
        for (DynamicObject receiveBill : casRecbills) {
            DynamicObjectCollection casEntryCollection = receiveBill.getDynamicObjectCollection("entry");
            if (isUpdate) {
                recEntryDetails.removeIf(e -> receiveBill.get("id").equals(e.get("casid")));
                for (DynamicObject casEntry : casEntryCollection) {
                    if (!casEntry.get("e_sourcebillid").equals(repaymentbill.getPkValue())) continue;
                    DynamicObject recEntryDetail = recEntryDetails.addNew();
                    this.addReceiveEntryDetail(receiveBill, casEntry, recEntryDetail);
                }
                this.removeReceiveEntry(repaymentbill, (Long)receiveBill.getPkValue());
                this.addReceiveEntry(repaymentbill, receiveBill, (Long)receiveBill.getPkValue());
                continue;
            }
            recEntryDetails.removeIf(e -> receiveBill.get("id").equals(e.get("casid")));
            this.removeReceiveEntry(repaymentbill, (Long)receiveBill.getPkValue());
        }
    }

    private void addReceiveEntryDetail(DynamicObject receiveBill, DynamicObject casEntry, DynamicObject recEntryDetail) {
        recEntryDetail.set("casbillno", receiveBill.get("billno"));
        recEntryDetail.set("casbizdate", receiveBill.get("bizdate"));
        recEntryDetail.set("casreceivingtype_id", (Object)ErCommonUtils.getPk((Object)receiveBill.get("receivingtype")));
        recEntryDetail.set("cascurrency_id", (Object)ErCommonUtils.getPk((Object)receiveBill.get("currency")));
        recEntryDetail.set("casexchangerate", receiveBill.get("exchangerate"));
        recEntryDetail.set("caseactamt", casEntry.get("e_actamt"));
        recEntryDetail.set("caselocalamt", casEntry.get("e_localamt"));
        recEntryDetail.set("casid", receiveBill.getPkValue());
        recEntryDetail.set("casentryid", casEntry.getPkValue());
        recEntryDetail.set("cascashaccount_id", receiveBill.get("accountcash.id"));
        recEntryDetail.set("casbankaccount_id", receiveBill.get("accountbank.id"));
        recEntryDetail.set("casbank", (Object)ErCommonUtils.getPk((Object)receiveBill.get("payeebank")));
        if (receiveBill.get("accountbank.id") != null) {
            recEntryDetail.set("accountnumber", receiveBill.get("accountbank.number"));
            recEntryDetail.set("bankaccountname", (Object)receiveBill.getString("accountbank.name"));
        } else if (receiveBill.get("accountcash.id") != null) {
            recEntryDetail.set("accountnumber", receiveBill.get("accountcash.number"));
            recEntryDetail.set("bankaccountname", (Object)receiveBill.getString("accountcash.name"));
        }
    }

    private void addReceiveEntry(DynamicObject repaymentbill, DynamicObject receiveBill, Long receiveBillId) {
        if (repaymentbill != null && !"2".equals(repaymentbill.get("buildrelationway"))) {
            DynamicObjectCollection receiveEntrys = repaymentbill.getDynamicObjectCollection("recentry");
            ArrayList receiveBillList = Lists.newArrayList((Object[])new Object[]{receiveBill});
            RepaymentAssociateUtil.fillRecEntry((DynamicObjectCollection)receiveEntrys, (List)receiveBillList, Collections.singletonList(receiveBillId));
        }
    }

    private void removeReceiveEntry(DynamicObject repaymentbill, Long receiveBillId) {
        if (repaymentbill != null && !"2".equals(repaymentbill.get("buildrelationway"))) {
            DynamicObjectCollection receiveEntrys = repaymentbill.getDynamicObjectCollection("recentry");
            receiveEntrys.removeIf(e -> receiveBillId.equals(e.getLong("recbillid")));
        }
    }
}

